/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ApparitionDoorBlock
extends Block {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty VANISHED = BooleanProperty.m_61465_((String)"vanish");
    private static final VoxelShape VANISHED_SHAPE = Shapes.m_83064_((AABB)new AABB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625));

    public ApparitionDoorBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VANISHED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{ACTIVE, VANISHED});
    }

    public boolean m_6104_(BlockState pState, BlockState otherState, Direction direction) {
        return otherState.m_60734_() instanceof ApparitionDoorBlock && otherState.m_61143_((Property)VANISHED) == pState.m_61143_((Property)VANISHED);
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return (Boolean)pState.m_61143_((Property)VANISHED) != false || (Boolean)pState.m_61143_((Property)ACTIVE) == false ? Shapes.m_83040_() : super.m_7952_(pState, pLevel, pPos);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)pState.m_61143_((Property)VANISHED) != false ? Shapes.m_83040_() : super.m_5939_(pState, pLevel, pPos, pContext);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)pState.m_61143_((Property)VANISHED) != false ? VANISHED_SHAPE : super.m_5940_(pState, pLevel, pPos, pContext);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        return this.onActivation(pLevel, pPos, pState);
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!(block instanceof ApparitionDoorBlock) && pLevel.m_276867_(pPos)) {
            this.onActivation(pLevel, pPos, pState);
        }
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.BLOCK;
    }

    private InteractionResult onActivation(Level pLevel, BlockPos pPos, BlockState pState) {
        if (((Boolean)pState.m_61143_((Property)VANISHED)).booleanValue() || ((Boolean)pState.m_61143_((Property)ACTIVE)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        this.changeToActiveBlock(pLevel, pPos, pState);
        return InteractionResult.SUCCESS;
    }

    private void changeToActiveBlock(Level pLevel, BlockPos pPos, BlockState originState) {
        if (originState.m_60734_() instanceof ApparitionDoorBlock) {
            pLevel.m_46597_(pPos, (BlockState)originState.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
        }
        pLevel.m_186460_(pPos, originState.m_60734_(), 2 + pLevel.m_213780_().m_188503_(5));
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.m_61143_((Property)VANISHED)).booleanValue()) {
            if (((Boolean)pState.m_61143_((Property)ACTIVE)).booleanValue()) {
                pLevel.m_46597_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)VANISHED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            } else {
                this.changeToActiveBlock((Level)pLevel, pPos, pState);
            }
            this.playReappearSound((Level)pLevel, pPos);
        } else if (((Boolean)pState.m_61143_((Property)ACTIVE)).booleanValue()) {
            pLevel.m_46597_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)VANISHED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            pLevel.m_186460_(pPos, (Block)this, 80);
            this.playVanishSound((Level)pLevel, pPos);
            this.vanishParticles((Level)pLevel, pPos);
            for (Direction direction : Direction.values()) {
                this.checkAndActivateCastleDoor((Level)pLevel, pPos.m_121945_(direction));
            }
        }
    }

    private void playVanishSound(Level pLevel, BlockPos pPos) {
        pLevel.m_5594_(null, pPos, (SoundEvent)ModSounds.WRAITH_TELEPORT.get(), SoundSource.BLOCKS, 0.125f, pLevel.m_213780_().m_188501_() * 0.25f + 1.75f);
    }

    private void playReappearSound(Level pLevel, BlockPos pPos) {
        pLevel.m_5594_(null, pPos, (SoundEvent)ModSounds.WRAITH_TELEPORT.get(), SoundSource.BLOCKS, 0.125f, pLevel.m_213780_().m_188501_() * 0.25f + 1.25f);
    }

    public void checkAndActivateCastleDoor(Level pLevel, BlockPos pPos) {
        BlockState state = pLevel.m_8055_(pPos);
        if (state.m_60734_() instanceof ApparitionDoorBlock && !((Boolean)state.m_61143_((Property)VANISHED)).booleanValue() && !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            this.changeToActiveBlock(pLevel, pPos, state);
        }
    }

    private void vanishParticles(Level pLevel, BlockPos pPos) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            for (int dx = 0; dx < 4; ++dx) {
                for (int dy = 0; dy < 4; ++dy) {
                    for (int dz = 0; dz < 4; ++dz) {
                        double x = (double)pPos.m_123341_() + ((double)dx + 0.5) / 4.0;
                        double y = (double)pPos.m_123342_() + ((double)dy + 0.5) / 4.0;
                        double z = (double)pPos.m_123343_() + ((double)dz + 0.5) / 4.0;
                        ColorUtil colorUtil = new ColorUtil(9300729);
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SPELL_SQUARE.get()), x, y, z, 0, (double)colorUtil.red, (double)colorUtil.green, (double)colorUtil.blue, 0.5);
                    }
                }
            }
        }
    }
}

