/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks;

import com.Polarice3.Goety.common.blocks.entities.BrewCauldronBlockEntity;
import com.Polarice3.Goety.common.blocks.properties.ModStateProperties;
import com.Polarice3.Goety.common.effects.brew.BrewEffect;
import com.Polarice3.Goety.common.effects.brew.BrewEffectInstance;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.WaystoneItem;
import com.Polarice3.Goety.common.items.brew.ThrowableBrewItem;
import com.Polarice3.Goety.common.items.magic.TaglockKit;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BrewUtils;
import com.Polarice3.Goety.utils.ConstantPaths;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BrewCauldronBlock
extends BaseEntityBlock {
    private static final VoxelShape INSIDE = BrewCauldronBlock.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private static final VoxelShape LEGS = Shapes.m_83124_((VoxelShape)BrewCauldronBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)2.0, (double)3.0, (double)2.0), (VoxelShape[])new VoxelShape[]{BrewCauldronBlock.m_49796_((double)14.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)2.0), BrewCauldronBlock.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)15.0, (double)3.0, (double)15.0), BrewCauldronBlock.m_49796_((double)1.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)15.0)});
    private static final VoxelShape BOTTOM = Shapes.m_83110_((VoxelShape)BrewCauldronBlock.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), (VoxelShape)LEGS);
    private static final VoxelShape BODY = Shapes.m_83124_((VoxelShape)BrewCauldronBlock.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0), (VoxelShape[])new VoxelShape[]{BrewCauldronBlock.m_49796_((double)14.0, (double)3.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0), BrewCauldronBlock.m_49796_((double)0.0, (double)3.0, (double)14.0, (double)16.0, (double)13.0, (double)16.0), BrewCauldronBlock.m_49796_((double)0.0, (double)3.0, (double)2.0, (double)2.0, (double)13.0, (double)14.0)});
    private static final VoxelShape TOP = Shapes.m_83124_((VoxelShape)BrewCauldronBlock.m_49796_((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)15.0, (double)2.0), (VoxelShape[])new VoxelShape[]{BrewCauldronBlock.m_49796_((double)14.0, (double)13.0, (double)2.0, (double)15.0, (double)15.0, (double)14.0), BrewCauldronBlock.m_49796_((double)1.0, (double)13.0, (double)14.0, (double)15.0, (double)15.0, (double)15.0), BrewCauldronBlock.m_49796_((double)1.0, (double)13.0, (double)2.0, (double)2.0, (double)15.0, (double)14.0)});
    protected static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)BODY, (VoxelShape[])new VoxelShape[]{TOP, BOTTOM});
    public static final IntegerProperty LEVEL = ModStateProperties.LEVEL_BREW;
    public static final BooleanProperty FAILED = ModStateProperties.FAILED;

    public BrewCauldronBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60999_().m_60978_(2.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)FAILED, (Comparable)Boolean.FALSE));
    }

    public void m_213897_(BlockState p_220702_, ServerLevel p_220703_, BlockPos p_220704_, RandomSource p_220705_) {
        Fluid fluid;
        BlockPos blockpos = PointedDripstoneBlock.m_154055_((Level)p_220703_, (BlockPos)p_220704_);
        if (blockpos != null && (fluid = PointedDripstoneBlock.m_221849_((ServerLevel)p_220703_, (BlockPos)blockpos)) == Fluids.f_76193_) {
            this.receiveStalactiteDrip(p_220702_, (Level)p_220703_, p_220704_, fluid);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof BrewCauldronBlockEntity) {
            BrewCauldronBlockEntity cauldron = (BrewCauldronBlockEntity)blockEntity;
            ItemStack stack = pPlayer.m_21120_(pHand);
            boolean bucket = ItemHelper.isValidFluidContainerToFill(stack, (Fluid)Fluids.f_76193_);
            boolean waterBucket = ItemHelper.isValidFluidContainerToDrain(stack, (Fluid)Fluids.f_76193_);
            boolean glassBottle = stack.m_41720_() == Items.f_42590_;
            boolean waterBottle = (stack.m_41720_() == Items.f_42589_ || stack.m_41720_() == ModItems.BREW.get()) && PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_;
            boolean apple = BrewUtils.brewableFood(stack);
            boolean waystone = stack.m_41720_() instanceof WaystoneItem;
            boolean ladle = stack.m_41720_() == ModItems.CAULDRON_LADLE.get();
            boolean taglock = stack.m_41720_() instanceof TaglockKit && TaglockKit.hasEntity(stack);
            boolean playSound = false;
            if (!pLevel.f_46443_) {
                int targetLevel;
                if ((bucket || waterBucket || apple || taglock || glassBottle || waterBottle || waystone || ladle) && (targetLevel = cauldron.getTargetLevel(stack, pPlayer)) > -1) {
                    if (bucket) {
                        ItemHelper.addAndConsumeItem(pPlayer, pHand, ItemHelper.fill((Fluid)Fluids.f_76193_, stack), false);
                        playSound = true;
                    } else if (waterBucket) {
                        ItemHelper.addAndConsumeItem(pPlayer, pHand, ItemHelper.drain((Fluid)Fluids.f_76193_, stack), false);
                        playSound = true;
                    } else if (apple) {
                        if (cauldron.mode == BrewCauldronBlockEntity.Mode.COMPLETED) {
                            ItemStack itemStack = BrewUtils.setCustomEffects(stack.m_41620_(1), PotionUtils.m_43571_((ItemStack)cauldron.getBrew()), BrewUtils.getBrewEffects(cauldron.getBrew()));
                            ItemHelper.addAndConsumeItem(pPlayer, pHand, itemStack);
                            SEHelper.increaseBottling(pPlayer);
                            playSound = true;
                        }
                    } else if (taglock && (Integer)pState.m_61143_((Property)LEVEL) >= 3) {
                        LivingEntity target;
                        if (cauldron.mode == BrewCauldronBlockEntity.Mode.COMPLETED && (target = TaglockKit.getEntity(stack)) != null) {
                            if (TaglockKit.isSameDimension((LivingEntity)pPlayer, stack) && TaglockKit.isInRange(Vec3.m_82512_((Vec3i)pPos), stack, BrewCauldronBlockEntity.getWitchPoles(cauldron))) {
                                List list = PotionUtils.m_43547_((ItemStack)cauldron.getBrew());
                                List<BrewEffectInstance> list1 = BrewUtils.getBrewEffects(cauldron.getBrew());
                                if (!list.isEmpty()) {
                                    for (MobEffectInstance mobeffectinstance : list) {
                                        MobEffect mobeffect = mobeffectinstance.m_19544_();
                                        if (mobeffect.m_8093_()) {
                                            mobeffect.m_19461_((Entity)pPlayer, (Entity)pPlayer, target, mobeffectinstance.m_19564_(), 1.0);
                                            continue;
                                        }
                                        int i = (int)(1.0 * (double)mobeffectinstance.m_19557_() + 0.5);
                                        if (i <= 20) continue;
                                        target.m_147207_(new MobEffectInstance(mobeffect, i, mobeffectinstance.m_19564_(), mobeffectinstance.m_19571_(), mobeffectinstance.m_19572_()), (Entity)pPlayer);
                                    }
                                }
                                if (!list1.isEmpty()) {
                                    for (BrewEffectInstance brewEffectInstance : list1) {
                                        BrewEffect brewEffect = brewEffectInstance.getEffect();
                                        if (!brewEffect.isInstantenous()) continue;
                                        brewEffect.applyInstantenousEffect((Entity)pPlayer, (Entity)pPlayer, target, brewEffectInstance.getAmplifier(), 1.0);
                                    }
                                }
                                pLevel.m_5594_(null, pPos, (SoundEvent)ModSounds.CAST_SPELL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                ItemHelper.addAndConsumeItem(pPlayer, pHand, new ItemStack((ItemLike)Items.f_42590_));
                                SEHelper.increaseBottling(pPlayer, 5);
                                playSound = true;
                            } else {
                                pLevel.m_5594_(null, pPos, (SoundEvent)ModSounds.SPELL_FAIL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                pPlayer.m_5661_((Component)Component.m_237115_((String)"info.goety.taglock.difDimension"), true);
                            }
                        }
                    } else if (waystone && (Integer)pState.m_61143_((Property)LEVEL) >= 3 && cauldron.getBrew().m_41720_() instanceof ThrowableBrewItem) {
                        GlobalPos globalPos;
                        if (cauldron.mode == BrewCauldronBlockEntity.Mode.COMPLETED && (globalPos = WaystoneItem.getPosition(stack)) != null) {
                            if (globalPos.m_122640_() == pLevel.m_46472_() && WaystoneItem.isInRange(Vec3.m_82512_((Vec3i)pPos), stack, BrewCauldronBlockEntity.getWitchPoles(cauldron))) {
                                BrewUtils.onHit((LivingEntity)pPlayer, cauldron.getBrew(), null, globalPos.m_122646_(), WaystoneItem.getDirection(cauldron.getBrew()));
                                pLevel.m_5594_(null, pPos, (SoundEvent)ModSounds.CAST_SPELL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                SEHelper.increaseBottling(pPlayer, 5);
                                playSound = true;
                            } else {
                                pLevel.m_5594_(null, pPos, (SoundEvent)ModSounds.SPELL_FAIL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                pPlayer.m_5661_((Component)Component.m_237115_((String)"info.goety.waystone.difDimension"), true);
                            }
                        }
                    } else if (glassBottle) {
                        ItemStack bottle = null;
                        if (cauldron.mode == BrewCauldronBlockEntity.Mode.IDLE) {
                            bottle = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
                        } else if (cauldron.mode == BrewCauldronBlockEntity.Mode.COMPLETED) {
                            SEHelper.increaseBottling(pPlayer);
                            bottle = cauldron.getBrew();
                        } else if (cauldron.mode == BrewCauldronBlockEntity.Mode.FAILED) {
                            bottle = new ItemStack((ItemLike)ModItems.REFUSE_BOTTLE.get());
                        }
                        if (bottle != null) {
                            ItemHelper.addAndConsumeItem(pPlayer, pHand, bottle);
                            playSound = true;
                        }
                    } else if (waterBottle) {
                        ItemHelper.addAndConsumeItem(pPlayer, pHand, new ItemStack((ItemLike)Items.f_42590_));
                        playSound = true;
                    } else if (ladle) {
                        cauldron.brew();
                    }
                    if (targetLevel == 0) {
                        cauldron.mode = cauldron.reset();
                    }
                    pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)ModStateProperties.LEVEL_BREW, (Comparable)Integer.valueOf(targetLevel)));
                    if (playSound) {
                        pLevel.m_5594_(null, pPos, bucket ? SoundEvents.f_11781_ : (waterBucket ? SoundEvents.f_11778_ : (glassBottle ? SoundEvents.f_11770_ : SoundEvents.f_11769_)), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
                cauldron.markUpdated();
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public RenderShape m_7514_(BlockState p_222219_) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState p_151964_, BlockGetter p_151965_, BlockPos p_151966_, CollisionContext p_151967_) {
        return SHAPE;
    }

    public VoxelShape m_6079_(BlockState p_151955_, BlockGetter p_151956_, BlockPos p_151957_) {
        return INSIDE;
    }

    protected double getContentHeight(BlockState p_153528_) {
        return (6.0 + (double)((Integer)p_153528_.m_61143_((Property)LEVEL)).intValue() * 3.0) / 16.0;
    }

    protected boolean isEntityInsideContent(BlockState p_151980_, BlockPos p_151981_, Entity p_151982_) {
        return p_151982_.m_20186_() < (double)p_151981_.m_123342_() + this.getContentHeight(p_151980_) && p_151982_.m_20191_().f_82292_ > (double)p_151981_.m_123342_() + 0.25;
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        BrewCauldronBlockEntity blockEntity = (BrewCauldronBlockEntity)pLevel.m_7702_(pPos);
        if (!pLevel.f_46443_ && blockEntity != null) {
            ItemEntity itemEntity;
            boolean flag;
            if ((Integer)pLevel.m_8055_(pPos).m_61143_((Property)LEVEL) > 0 && pEntity instanceof LivingEntity && this.isEntityInsideContent(pState, pPos, pEntity) && blockEntity.isHeated() && !pEntity.m_5825_() && (flag = pEntity.m_6469_(ModDamageSource.getDamageSource(pLevel, ModDamageSource.BOILING, new EntityType[0]), 1.0f)) && (Integer)pLevel.m_8055_(pPos).m_61143_((Property)LEVEL) == 3 && !pEntity.m_6084_()) {
                blockEntity.mode = blockEntity.addSacrifice(pEntity);
                blockEntity.markUpdated();
            }
            if ((Integer)pLevel.m_8055_(pPos).m_61143_((Property)LEVEL) == 3 && blockEntity.mode != BrewCauldronBlockEntity.Mode.COMPLETED && pEntity instanceof ItemEntity && !(itemEntity = (ItemEntity)pEntity).m_32055_().m_41619_() && !itemEntity.m_19880_().contains(ConstantPaths.resultItem())) {
                pLevel.m_5594_(null, pPos, SoundEvents.f_11917_, SoundSource.BLOCKS, 0.33f, 1.0f);
                ItemStack stack = itemEntity.m_32055_();
                ItemStack remain = stack.getCraftingRemainingItem();
                if (remain != null) {
                    ItemEntity remainder = new ItemEntity(pLevel, (double)pPos.m_123341_() + 0.5, (double)(pPos.m_123342_() + 1), (double)pPos.m_123343_() + 0.5, remain);
                    remainder.m_20256_(Vec3.f_82478_);
                    remainder.m_20242_(true);
                    remainder.m_20049_(ConstantPaths.resultItem());
                    pLevel.m_7967_((Entity)remainder);
                }
                blockEntity.mode = blockEntity.insertItem(stack.m_41620_(1));
                blockEntity.markUpdated();
            }
        }
        super.m_7892_(pState, pLevel, pPos, pEntity);
    }

    public void m_141997_(BlockState blockState, Level level, BlockPos blockPos, Biome.Precipitation precipitation) {
        BlockEntity blockEntity;
        if (precipitation == Biome.Precipitation.RAIN && level.m_213780_().m_188503_(20) == 1 && (blockEntity = level.m_7702_(blockPos)) instanceof BrewCauldronBlockEntity) {
            BrewCauldronBlockEntity blockEntity1 = (BrewCauldronBlockEntity)blockEntity;
            if ((Integer)blockState.m_61143_((Property)LEVEL) < 3 && BrewUtils.isEmpty(blockEntity1.getBrew())) {
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf((Integer)blockState.m_61143_((Property)LEVEL) + 1)));
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LEVEL, FAILED});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    protected void receiveStalactiteDrip(BlockState p_152940_, Level p_152941_, BlockPos p_152942_, Fluid p_152943_) {
        BlockEntity blockEntity = p_152941_.m_7702_(p_152942_);
        if (blockEntity instanceof BrewCauldronBlockEntity) {
            BrewCauldronBlockEntity blockEntity1 = (BrewCauldronBlockEntity)blockEntity;
            if ((Integer)p_152940_.m_61143_((Property)LEVEL) < 3 && BrewUtils.isEmpty(blockEntity1.getBrew()) && p_152943_ == Fluids.f_76193_) {
                p_152941_.m_46597_(p_152942_, (BlockState)p_152940_.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf((Integer)p_152940_.m_61143_((Property)LEVEL) + 1)));
                p_152941_.m_220407_(GameEvent.f_157792_, p_152942_, GameEvent.Context.m_223722_((BlockState)p_152940_));
                p_152941_.m_46796_(1047, p_152942_, 0);
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LEVEL) == 3 ? 15 : ((Integer)state.m_61143_((Property)LEVEL) == 2 ? 10 : ((Integer)state.m_61143_((Property)LEVEL) == 1 ? 5 : 0));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new BrewCauldronBlockEntity(p_153215_, p_153216_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return (world, pos, state, blockEntity) -> {
            if (!world.f_46443_ && blockEntity instanceof BrewCauldronBlockEntity) {
                BrewCauldronBlockEntity blockEntity1 = (BrewCauldronBlockEntity)blockEntity;
                blockEntity1.tick();
            }
        };
    }
}

