/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks;

import com.Polarice3.Goety.client.particles.ShockwaveParticleOption;
import com.Polarice3.Goety.common.blocks.entities.HookBellBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HookBellBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<BellAttachType> ATTACHMENT = BlockStateProperties.f_61377_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final VoxelShape NORTH_SOUTH_FLOOR_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape EAST_WEST_FLOOR_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape BELL_TOP_SHAPE = Block.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0);
    private static final VoxelShape BELL_BOTTOM_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    private static final VoxelShape BELL_SHAPE = Shapes.m_83110_((VoxelShape)BELL_BOTTOM_SHAPE, (VoxelShape)BELL_TOP_SHAPE);
    private static final VoxelShape NORTH_SOUTH_BETWEEN = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)7.0, (double)13.0, (double)0.0, (double)9.0, (double)15.0, (double)16.0));
    private static final VoxelShape EAST_WEST_BETWEEN = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_WEST = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)7.0, (double)13.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_EAST = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)13.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_NORTH = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)7.0, (double)13.0, (double)0.0, (double)9.0, (double)15.0, (double)13.0));
    private static final VoxelShape TO_SOUTH = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)7.0, (double)13.0, (double)3.0, (double)9.0, (double)15.0, (double)16.0));
    private static final VoxelShape CEILING_SHAPE = Shapes.m_83110_((VoxelShape)BELL_SHAPE, (VoxelShape)Block.m_49796_((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));

    public HookBellBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_280606_().m_284180_(MapColor.f_283784_).m_60999_().m_60978_(5.0f).m_278166_(PushReaction.DESTROY).m_60918_(SoundType.f_56749_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(ATTACHMENT, (Comparable)BellAttachType.FLOOR)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6861_(BlockState p_49729_, Level p_49730_, BlockPos p_49731_, Block p_49732_, BlockPos p_49733_, boolean p_49734_) {
        boolean flag = p_49730_.m_276867_(p_49731_);
        if (flag != (Boolean)p_49729_.m_61143_((Property)POWERED)) {
            p_49730_.m_7731_(p_49731_, (BlockState)p_49729_.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    public void m_5581_(Level p_49708_, BlockState p_49709_, BlockHitResult p_49710_, Projectile p_49711_) {
        Entity entity = p_49711_.m_19749_();
        Player player = entity instanceof Player ? (Player)entity : null;
        this.onHit(p_49708_, p_49709_, p_49710_, player, true);
    }

    public InteractionResult m_6227_(BlockState p_49722_, Level p_49723_, BlockPos p_49724_, Player p_49725_, InteractionHand p_49726_, BlockHitResult p_49727_) {
        return this.onHit(p_49723_, p_49722_, p_49727_, p_49725_, true) ? InteractionResult.m_19078_((boolean)p_49723_.f_46443_) : InteractionResult.PASS;
    }

    public boolean onHit(Level p_49702_, BlockState p_49703_, BlockHitResult p_49704_, @Nullable Player p_49705_, boolean p_49706_) {
        boolean flag;
        Direction direction = p_49704_.m_82434_();
        BlockPos blockpos = p_49704_.m_82425_();
        boolean bl = flag = !p_49706_ || this.isProperHit(p_49703_, direction, p_49704_.m_82450_().f_82480_ - (double)blockpos.m_123342_());
        if (flag && p_49705_ != null) {
            boolean flag1 = this.attemptToRing((Entity)p_49705_, p_49702_, blockpos, direction);
            if (flag1) {
                p_49705_.m_36220_(Stats.f_12979_);
            }
            return true;
        }
        return false;
    }

    private boolean isProperHit(BlockState p_49740_, Direction p_49741_, double p_49742_) {
        if (p_49741_.m_122434_() != Direction.Axis.Y && !(p_49742_ > (double)0.8124f)) {
            Direction direction = (Direction)p_49740_.m_61143_((Property)FACING);
            BellAttachType bellattachtype = (BellAttachType)p_49740_.m_61143_(ATTACHMENT);
            switch (bellattachtype) {
                case FLOOR: {
                    return direction.m_122434_() == p_49741_.m_122434_();
                }
                case SINGLE_WALL: 
                case DOUBLE_WALL: {
                    return direction.m_122434_() != p_49741_.m_122434_();
                }
                case CEILING: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean attemptToRing(Level p_49713_, BlockPos p_49714_, @Nullable Direction p_49715_) {
        return this.attemptToRing(null, p_49713_, p_49714_, p_49715_);
    }

    public boolean attemptToRing(@Nullable Entity p_152189_, Level p_152190_, BlockPos p_152191_, @Nullable Direction p_152192_) {
        BlockEntity blockentity = p_152190_.m_7702_(p_152191_);
        if (!p_152190_.f_46443_ && blockentity instanceof HookBellBlockEntity) {
            if (p_152192_ == null) {
                p_152192_ = (Direction)p_152190_.m_8055_(p_152191_).m_61143_((Property)FACING);
            }
            ((HookBellBlockEntity)blockentity).onHit(p_152192_);
            p_152190_.m_5594_((Player)null, p_152191_, SoundEvents.f_11699_, SoundSource.BLOCKS, 10.0f, 0.5f);
            if (p_152190_ instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)p_152190_;
                serverLevel.m_8767_((ParticleOptions)new ShockwaveParticleOption(), (double)p_152191_.m_123341_() + 0.5, (double)((float)p_152191_.m_123342_() + 0.5f), (double)p_152191_.m_123343_() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
            }
            p_152190_.m_142346_(p_152189_, GameEvent.f_157792_, p_152191_);
            return true;
        }
        return false;
    }

    private VoxelShape getVoxelShape(BlockState p_49767_) {
        Direction direction = (Direction)p_49767_.m_61143_((Property)FACING);
        BellAttachType bellattachtype = (BellAttachType)p_49767_.m_61143_(ATTACHMENT);
        if (bellattachtype == BellAttachType.FLOOR) {
            return direction != Direction.NORTH && direction != Direction.SOUTH ? EAST_WEST_FLOOR_SHAPE : NORTH_SOUTH_FLOOR_SHAPE;
        }
        if (bellattachtype == BellAttachType.CEILING) {
            return CEILING_SHAPE;
        }
        if (bellattachtype == BellAttachType.DOUBLE_WALL) {
            return direction != Direction.NORTH && direction != Direction.SOUTH ? EAST_WEST_BETWEEN : NORTH_SOUTH_BETWEEN;
        }
        if (direction == Direction.NORTH) {
            return TO_NORTH;
        }
        if (direction == Direction.SOUTH) {
            return TO_SOUTH;
        }
        return direction == Direction.EAST ? TO_EAST : TO_WEST;
    }

    public VoxelShape m_5939_(BlockState p_49760_, BlockGetter p_49761_, BlockPos p_49762_, CollisionContext p_49763_) {
        return this.getVoxelShape(p_49760_);
    }

    public VoxelShape m_5940_(BlockState p_49755_, BlockGetter p_49756_, BlockPos p_49757_, CollisionContext p_49758_) {
        return this.getVoxelShape(p_49755_);
    }

    public RenderShape m_7514_(BlockState p_49753_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_49698_) {
        Direction direction = p_49698_.m_43719_();
        BlockPos blockpos = p_49698_.m_8083_();
        Level level = p_49698_.m_43725_();
        Direction.Axis direction$axis = direction.m_122434_();
        if (direction$axis == Direction.Axis.Y) {
            BlockState blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_(ATTACHMENT, (Comparable)(direction == Direction.DOWN ? BellAttachType.CEILING : BellAttachType.FLOOR))).m_61124_((Property)FACING, (Comparable)p_49698_.m_8125_());
            if (blockstate.m_60710_((LevelReader)p_49698_.m_43725_(), blockpos)) {
                return blockstate;
            }
        } else {
            boolean flag = direction$axis == Direction.Axis.X && level.m_8055_(blockpos.m_122024_()).m_60783_((BlockGetter)level, blockpos.m_122024_(), Direction.EAST) && level.m_8055_(blockpos.m_122029_()).m_60783_((BlockGetter)level, blockpos.m_122029_(), Direction.WEST) || direction$axis == Direction.Axis.Z && level.m_8055_(blockpos.m_122012_()).m_60783_((BlockGetter)level, blockpos.m_122012_(), Direction.SOUTH) && level.m_8055_(blockpos.m_122019_()).m_60783_((BlockGetter)level, blockpos.m_122019_(), Direction.NORTH);
            BlockState blockstate1 = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_61124_(ATTACHMENT, (Comparable)(flag ? BellAttachType.DOUBLE_WALL : BellAttachType.SINGLE_WALL));
            if (blockstate1.m_60710_((LevelReader)p_49698_.m_43725_(), p_49698_.m_8083_())) {
                return blockstate1;
            }
            boolean flag1 = level.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)level, blockpos.m_7495_(), Direction.UP);
            if ((blockstate1 = (BlockState)blockstate1.m_61124_(ATTACHMENT, (Comparable)(flag1 ? BellAttachType.FLOOR : BellAttachType.CEILING))).m_60710_((LevelReader)p_49698_.m_43725_(), p_49698_.m_8083_())) {
                return blockstate1;
            }
        }
        return null;
    }

    public BlockState m_7417_(BlockState p_49744_, Direction p_49745_, BlockState p_49746_, LevelAccessor p_49747_, BlockPos p_49748_, BlockPos p_49749_) {
        BellAttachType bellattachtype = (BellAttachType)p_49744_.m_61143_(ATTACHMENT);
        Direction direction = HookBellBlock.getConnectedDirection(p_49744_).m_122424_();
        if (direction == p_49745_ && !p_49744_.m_60710_((LevelReader)p_49747_, p_49748_) && bellattachtype != BellAttachType.DOUBLE_WALL) {
            return Blocks.f_50016_.m_49966_();
        }
        if (p_49745_.m_122434_() == ((Direction)p_49744_.m_61143_((Property)FACING)).m_122434_()) {
            if (bellattachtype == BellAttachType.DOUBLE_WALL && !p_49746_.m_60783_((BlockGetter)p_49747_, p_49749_, p_49745_)) {
                return (BlockState)((BlockState)p_49744_.m_61124_(ATTACHMENT, (Comparable)BellAttachType.SINGLE_WALL)).m_61124_((Property)FACING, (Comparable)p_49745_.m_122424_());
            }
            if (bellattachtype == BellAttachType.SINGLE_WALL && direction.m_122424_() == p_49745_ && p_49746_.m_60783_((BlockGetter)p_49747_, p_49749_, (Direction)p_49744_.m_61143_((Property)FACING))) {
                return (BlockState)p_49744_.m_61124_(ATTACHMENT, (Comparable)BellAttachType.DOUBLE_WALL);
            }
        }
        return super.m_7417_(p_49744_, p_49745_, p_49746_, p_49747_, p_49748_, p_49749_);
    }

    public boolean m_7898_(BlockState p_49736_, LevelReader p_49737_, BlockPos p_49738_) {
        Direction direction = HookBellBlock.getConnectedDirection(p_49736_).m_122424_();
        return direction == Direction.UP ? Block.m_49863_((LevelReader)p_49737_, (BlockPos)p_49738_.m_7494_(), (Direction)Direction.DOWN) : FaceAttachedHorizontalDirectionalBlock.m_53196_((LevelReader)p_49737_, (BlockPos)p_49738_, (Direction)direction);
    }

    private static Direction getConnectedDirection(BlockState p_49769_) {
        switch ((BellAttachType)p_49769_.m_61143_(ATTACHMENT)) {
            case FLOOR: {
                return Direction.UP;
            }
            case CEILING: {
                return Direction.DOWN;
            }
        }
        return ((Direction)p_49769_.m_61143_((Property)FACING)).m_122424_();
    }

    public PushReaction getPistonPushReaction(BlockState p_49765_) {
        return PushReaction.DESTROY;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49751_) {
        p_49751_.m_61104_(new Property[]{FACING, ATTACHMENT, POWERED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_152198_, BlockState p_152199_) {
        return new HookBellBlockEntity(p_152198_, p_152199_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152194_, BlockState p_152195_, BlockEntityType<T> p_152196_) {
        return HookBellBlock.m_152132_(p_152196_, (BlockEntityType)((BlockEntityType)ModBlockEntities.HOOK_BELL.get()), (BlockEntityTicker)(p_152194_.f_46443_ ? HookBellBlockEntity::clientTick : HookBellBlockEntity::serverTick));
    }

    public boolean m_7357_(BlockState p_49717_, BlockGetter p_49718_, BlockPos p_49719_, PathComputationType p_49720_) {
        return false;
    }
}

