/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.effects.brew.block;

import com.Polarice3.Goety.common.effects.brew.BrewEffect;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.ritual.RitualRequirements;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class RaiseDeadBrewEffect
extends BrewEffect {
    public RaiseDeadBrewEffect(int soulCost, int capacityExtra) {
        super("raise_dead", soulCost, capacityExtra, MobEffectCategory.BENEFICIAL, 2036769);
    }

    @Override
    public boolean isInstantenous() {
        return true;
    }

    @Override
    public boolean canLinger() {
        return true;
    }

    @Override
    public void applyBlockEffect(Level pLevel, BlockPos pPos, LivingEntity pSource, int pAmplifier, int pAreaOfEffect) {
        RaiseDeadBrewEffect.raiseDead(pLevel, pPos, pSource, pAmplifier, pAreaOfEffect, MobUtil.getSummonLifespan(pLevel) * (pAmplifier + 1));
    }

    public static void raiseDead(Level pLevel, BlockPos pPos, LivingEntity pSource, int pAmplifier, int pAreaOfEffect, int lifetime) {
        RaiseDeadBrewEffect.raiseUndead(pLevel, pPos, pSource, lifetime);
        pLevel.m_6263_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.NECROMANCER_SUMMON.get(), pSource.m_5720_(), 1.4f, 0.7f);
        int j = 0;
        for (int h = 0; h <= pAmplifier; ++h) {
            if (h == 1) {
                if (!(pLevel.f_46441_.m_188500_() < (double)pAmplifier * 0.5)) continue;
                ++j;
                continue;
            }
            if (h <= 1 || !(pLevel.f_46441_.m_188500_() < (double)pAmplifier * 0.25)) continue;
            ++j;
        }
        for (int i = 0; i < j; ++i) {
            int radius = 4 + pAreaOfEffect;
            int x = pPos.m_123341_() - radius / 2 + pLevel.f_46441_.m_188503_(radius) + 1;
            int y = pPos.m_123342_() + radius;
            int z = pPos.m_123343_() - radius / 2 + pLevel.f_46441_.m_188503_(radius) + 1;
            RaiseDeadBrewEffect.raiseUndead(pLevel, BlockFinder.SummonPosition((Entity)pSource, x, y, z), pSource, lifetime);
        }
    }

    private static void raiseUndead(Level pLevel, BlockPos pPos, LivingEntity pSource, int lifetime) {
        if (!pLevel.f_46443_) {
            Summoned summoned = (Summoned)((EntityType)ModEntityType.ZOMBIE_SERVANT.get()).m_20615_(pLevel);
            if (pLevel.f_46441_.m_188499_()) {
                summoned = (Summoned)((EntityType)ModEntityType.SKELETON_SERVANT.get()).m_20615_(pLevel);
            }
            if (summoned != null) {
                EntityType entityType;
                Player player = null;
                if (pSource instanceof Player) {
                    Player player1;
                    player = player1 = (Player)pSource;
                }
                if ((entityType = summoned.getVariant(player, pLevel, pPos)) != null) {
                    Summoned summoned1;
                    Entity entity = entityType.m_20615_(pLevel);
                    summoned = entity instanceof Summoned ? (summoned1 = (Summoned)entity) : null;
                }
                if (summoned != null) {
                    ServerLevel serverLevel;
                    if (pLevel instanceof ServerLevel && !RitualRequirements.canSummon((Level)(serverLevel = (ServerLevel)pLevel), player, entityType)) {
                        return;
                    }
                    summoned.m_146884_(Vec3.m_82514_((Vec3i)pPos, (double)1.0));
                    if (pSource != null) {
                        summoned.setTrueOwner(pSource);
                    }
                    if (pLevel instanceof ServerLevel) {
                        serverLevel = (ServerLevel)pLevel;
                        summoned.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(pPos), MobSpawnType.MOB_SUMMONED, null, null);
                    }
                    summoned.m_21530_();
                    summoned.setLimitedLife(lifetime);
                    pLevel.m_7967_((Entity)summoned);
                }
            }
        }
    }
}

