/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ai;

import com.Polarice3.Goety.api.entities.IBreathing;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class BreathingAttackGoal<T extends Mob>
extends Goal {
    public final T attacker;
    public LivingEntity attackTarget;
    public double spewX;
    public double spewY;
    public double spewZ;
    public final int maxDuration;
    public final float attackChance;
    public final float spewingRange;
    public int durationLeft;

    public BreathingAttackGoal(T pLivingEntity, float pRange, int pSeconds, float pFloatChance) {
        this.attacker = pLivingEntity;
        this.spewingRange = pRange;
        this.maxDuration = pSeconds;
        this.attackChance = pFloatChance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        this.attackTarget = this.attacker.m_5448_();
        if (this.attackTarget != null && this.attacker.m_20270_((Entity)this.attackTarget) <= this.spewingRange && this.attacker.m_21574_().m_148306_((Entity)this.attackTarget)) {
            return this.attacker.m_217043_().m_188501_() < this.attackChance;
        }
        return false;
    }

    public void m_8056_() {
        if (this.attackTarget != null) {
            this.spewX = this.attackTarget.m_20185_();
            this.spewY = this.attackTarget.m_20186_() + (double)this.attackTarget.m_20192_();
            this.spewZ = this.attackTarget.m_20189_();
        }
        this.durationLeft = this.maxDuration;
        ((IBreathing)this.attacker).setBreathing(true);
    }

    public boolean m_8045_() {
        return this.durationLeft > 0 && this.attacker.m_6084_() && !this.attacker.m_21224_() && this.attackTarget.m_6084_() && this.attacker.m_20270_((Entity)this.attackTarget) <= this.spewingRange && this.attacker.m_21574_().m_148306_((Entity)this.attackTarget);
    }

    public void m_8037_() {
        if (this.durationLeft > 0) {
            --this.durationLeft;
        }
        if (this.attackTarget != null) {
            Vec3 vector3d = new Vec3(this.attackTarget.m_20185_() - this.spewX, this.attackTarget.m_20186_() + (double)this.attackTarget.m_20192_() - this.spewY, this.attackTarget.m_20189_() - this.spewZ);
            vector3d = vector3d.m_82541_();
            double speed = 0.25;
            this.spewX += vector3d.f_82479_ * speed;
            this.spewY += vector3d.f_82480_ * speed;
            this.spewZ += vector3d.f_82481_ * speed;
        }
        this.attacker.m_21563_().m_24950_(this.spewX, this.spewY, this.spewZ, 100.0f, 100.0f);
        this.rotateAttacker(this.spewX, this.spewY, this.spewZ, 100.0f, 100.0f);
        int duration = this.maxDuration - this.durationLeft;
        if (duration > 5) {
            for (Entity entity : MobUtil.getTargets(((Mob)this.attacker).f_19853_, this.attacker, this.spewingRange, 3.0)) {
                if (entity == null) continue;
                ((IBreathing)this.attacker).doBreathing(entity);
            }
        }
    }

    public void m_8041_() {
        this.durationLeft = 0;
        this.attackTarget = null;
        ((IBreathing)this.attacker).setBreathing(false);
    }

    public void rotateAttacker(double x, double y, double z, float pDeltaYaw, float pDeltaPitch) {
        double xOffset = x - this.attacker.m_20185_();
        double zOffset = z - this.attacker.m_20189_();
        double yOffset = this.attacker.m_20186_() + 0.25 - y;
        double distance = Mth.m_14116_((float)((float)(xOffset * xOffset + zOffset * zOffset)));
        float xyAngle = (float)(Math.atan2(zOffset, xOffset) * 180.0 / Math.PI) - 90.0f;
        float zdAngle = (float)(-(Math.atan2(yOffset, distance) * 180.0 / Math.PI));
        this.attacker.m_146926_(-this.updateRotation(this.attacker.m_146909_(), zdAngle, pDeltaPitch));
        this.attacker.m_146922_(this.updateRotation(this.attacker.m_146908_(), xyAngle, pDeltaYaw));
    }

    private float updateRotation(float origin, float target, float maxDelta) {
        float delta = Mth.m_14177_((float)(target - origin));
        if (delta > maxDelta) {
            delta = maxDelta;
        }
        if (delta < -maxDelta) {
            delta = -maxDelta;
        }
        return origin + delta;
    }
}

