/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.BackawayCrossbowGoal;
import com.Polarice3.Goety.common.entities.ally.illager.AbstractIllagerServant;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.SkeletonPillagerServant;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;

public class PillagerServant
extends AbstractIllagerServant
implements CrossbowAttackMob {
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(PillagerServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public double arrowPower = 0.0;

    public PillagerServant(EntityType<? extends PillagerServant> p_33262_, Level p_33263_) {
        super(p_33262_, p_33263_);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, new BackawayCrossbowGoal<PillagerServant>(this, 1.0, 8.0f));
        this.f_21345_.m_25352_(8, new RaiderServant.RaiderWanderGoal<PillagerServant>(this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.PillagerServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.PillagerServantArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.PillagerServantDamage.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.PillagerServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.PillagerServantArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.PillagerServantDamage.get());
    }

    public double getBaseRangeDamage() {
        return (Double)AttributesConfig.PillagerServantRangeDamage.get();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    public boolean m_5886_(ProjectileWeaponItem p_33280_) {
        return p_33280_ == Items.f_42717_;
    }

    @Override
    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean p_33302_) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)p_33302_);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setArrowPower(pCompound.m_128451_("arrowPower"));
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (pCompound.m_128441_("arrowPower")) {
            pCompound.m_128347_("arrowPower", this.arrowPower);
        }
    }

    public double getArrowPower() {
        return this.arrowPower;
    }

    public void setArrowPower(int arrowPower) {
        this.arrowPower = arrowPower;
    }

    @Override
    public AbstractIllagerServant.IllagerServantArmPose getArmPose() {
        if (this.isChargingCrossbow()) {
            return AbstractIllagerServant.IllagerServantArmPose.CROSSBOW_CHARGE;
        }
        if (this.m_21093_(is -> is.m_41720_() instanceof CrossbowItem)) {
            if (this.m_5912_()) {
                return AbstractIllagerServant.IllagerServantArmPose.CROSSBOW_HOLD;
            }
            return this.isCelebrating() ? AbstractIllagerServant.IllagerServantArmPose.CELEBRATING : AbstractIllagerServant.IllagerServantArmPose.NEUTRAL;
        }
        if (this.isCelebrating()) {
            return AbstractIllagerServant.IllagerServantArmPose.CELEBRATING;
        }
        return this.m_5912_() ? AbstractIllagerServant.IllagerServantArmPose.ATTACKING : AbstractIllagerServant.IllagerServantArmPose.NEUTRAL;
    }

    public float m_5610_(BlockPos p_33288_, LevelReader p_33289_) {
        return 0.0f;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33282_, DifficultyInstance p_33283_, MobSpawnType p_33284_, @Nullable SpawnGroupData p_33285_, @Nullable CompoundTag p_33286_) {
        RandomSource randomsource = p_33282_.m_213780_();
        this.m_213945_(randomsource, p_33283_);
        this.m_213946_(randomsource, p_33283_);
        return super.m_6518_(p_33282_, p_33283_, p_33284_, p_33285_, p_33286_);
    }

    @Override
    protected void m_213945_(RandomSource p_219059_, DifficultyInstance p_219060_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    protected void m_214095_(RandomSource p_219056_, float p_219057_) {
        ItemStack itemstack;
        super.m_214095_(p_219056_, p_219057_);
        if (p_219056_.m_188503_(300) == 0 && (itemstack = this.m_21205_()).m_150930_(Items.f_42717_)) {
            Map map = EnchantmentHelper.m_44831_((ItemStack)itemstack);
            map.putIfAbsent(Enchantments.f_44961_, 1);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    protected SoundEvent m_7975_(DamageSource p_33306_) {
        return SoundEvents.f_12310_;
    }

    public void m_6504_(LivingEntity p_33272_, float p_33273_) {
        this.m_32336_((LivingEntity)this, 1.6f);
    }

    public void m_5811_(LivingEntity p_33275_, ItemStack p_33276_, Projectile p_33277_, float p_33278_) {
        if (p_33277_ instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)p_33277_;
            arrow.m_36781_(arrow.m_36789_() + this.getArrowPower() + this.getBaseRangeDamage());
        }
        this.m_32322_((LivingEntity)this, p_33275_, p_33277_, p_33278_, 1.6f);
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return SoundEvents.f_12308_;
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        SkeletonPillagerServant servant;
        if (!this.f_19853_.f_46443_ && this.getTrueOwner() != null && CuriosFinder.hasNamelessSet(this.getTrueOwner()) && (servant = (SkeletonPillagerServant)this.m_21406_((EntityType)ModEntityType.SKELETON_PILLAGER_SERVANT.get(), true)) != null) {
            servant.setTrueOwner(this.getTrueOwner());
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)servant);
            if (!this.m_20067_()) {
                this.f_19853_.m_5898_((Player)null, 1026, this.m_20183_(), 0);
            }
        }
        super.m_6667_(pCause);
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        ItemStack itemstack2 = this.m_21205_();
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && !(pPlayer.m_21206_().m_41720_() instanceof IWand)) {
            if (item instanceof CrossbowItem) {
                this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41777_());
                this.dropEquipment(EquipmentSlot.MAINHAND, itemstack2);
                this.m_21508_(EquipmentSlot.MAINHAND);
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (item instanceof ArrowItem) {
                this.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
                this.m_8061_(EquipmentSlot.OFFHAND, itemstack.m_41777_());
                this.dropEquipment(EquipmentSlot.OFFHAND, this.m_21206_());
                this.m_21508_(EquipmentSlot.OFFHAND);
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }
}

