/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.bound;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractBoundIllager
extends RaiderServant {
    private static final EntityDataAccessor<Byte> DATA_SPELL_CASTING_ID = SynchedEntityData.m_135353_(AbstractBoundIllager.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected int spellCastingTickCount;
    private BoundSpell currentSpell = BoundSpell.NONE;

    public AbstractBoundIllager(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.m_20242_(true);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SPELL_CASTING_ID, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag p_33732_) {
        super.m_7378_(p_33732_);
        this.spellCastingTickCount = p_33732_.m_128451_("SpellTicks");
    }

    @Override
    public void m_7380_(CompoundTag p_33734_) {
        super.m_7380_(p_33734_);
        p_33734_.m_128405_("SpellTicks", this.spellCastingTickCount);
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof AbstractBoundIllager;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.BoundIllagerLimit.get();
    }

    @Override
    public boolean canBeLeader() {
        return true;
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel){

            public boolean m_6342_(BlockPos blockPos) {
                return !this.f_26495_.m_8055_(blockPos.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                super.m_7638_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() || this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.9f));
            }
        }
        this.m_267651_(false);
    }

    public BoundArmPose getArmPose() {
        if (this.isCastingSpell()) {
            return BoundArmPose.SPELLCASTING;
        }
        return BoundArmPose.CROSSED;
    }

    @Override
    protected boolean isSunSensitive() {
        return true;
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource damageSource) {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_20068_() {
        return true;
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSounds.HAUNT_FLY.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    protected float m_6059_() {
        return this.f_19788_ + 2.0f;
    }

    public boolean isCastingSpell() {
        if (this.f_19853_.f_46443_) {
            return (Byte)this.f_19804_.m_135370_(DATA_SPELL_CASTING_ID) > 0;
        }
        return this.spellCastingTickCount > 0;
    }

    public void setIsCastingSpell(BoundSpell p_33728_) {
        this.currentSpell = p_33728_;
        this.f_19804_.m_135381_(DATA_SPELL_CASTING_ID, (Object)((byte)p_33728_.id));
    }

    protected BoundSpell getCurrentSpell() {
        return !this.f_19853_.f_46443_ ? this.currentSpell : BoundSpell.byId(((Byte)this.f_19804_.m_135370_(DATA_SPELL_CASTING_ID)).byteValue());
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.spellCastingTickCount > 0) {
            --this.spellCastingTickCount;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.isCastingSpell() && this.getCurrentSpell() != BoundSpell.CLOUDLESS) {
            BoundSpell spellcasterillager$illagerspell = this.getCurrentSpell();
            double d0 = spellcasterillager$illagerspell.spellColor[0];
            double d1 = spellcasterillager$illagerspell.spellColor[1];
            double d2 = spellcasterillager$illagerspell.spellColor[2];
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, d0, d1, d2);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, d0, d1, d2);
        }
    }

    protected int getSpellCastingTime() {
        return this.spellCastingTickCount;
    }

    protected abstract SoundEvent getCastingSoundEvent();

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
                if (itemstack.m_150930_((Item)ModItems.ECTOPLASM.get()) && this.m_21223_() < this.m_21233_()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_5496_(SoundEvents.f_12404_, 1.0f, 1.0f);
                    this.m_5634_(2.0f);
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    pPlayer.m_6674_(pHand);
                    return InteractionResult.SUCCESS;
                }
                Item i = itemstack.m_41720_();
                if (i instanceof ArmorItem) {
                    ArmorItem armor = (ArmorItem)i;
                    ItemStack helmet = this.m_6844_(EquipmentSlot.HEAD);
                    ItemStack chestplate = this.m_6844_(EquipmentSlot.CHEST);
                    this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                    if (armor.m_266204_() == ArmorItem.Type.HELMET) {
                        this.m_8061_(EquipmentSlot.HEAD, itemstack.m_255036_(1));
                        this.dropEquipment(EquipmentSlot.HEAD, helmet);
                        this.m_21508_(EquipmentSlot.HEAD);
                    }
                    if (armor.m_266204_() == ArmorItem.Type.CHESTPLATE) {
                        this.m_8061_(EquipmentSlot.CHEST, itemstack.m_255036_(1));
                        this.dropEquipment(EquipmentSlot.CHEST, chestplate);
                        this.m_21508_(EquipmentSlot.CHEST);
                    }
                    for (int i2 = 0; i2 < 7; ++i2) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                    }
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    protected static enum BoundSpell {
        NONE(0, 0.0, 0.0, 0.0),
        SUMMON_VEX(1, 0.7, 0.7, 0.8),
        FANGS(2, 0.4, 0.3, 0.35),
        WOLOLO(3, 0.7, 0.5, 0.2),
        DISAPPEAR(4, 0.3, 0.3, 0.8),
        BLINDNESS(5, 0.1, 0.1, 0.2),
        CLOUDLESS(6, 0.0, 0.0, 0.0);

        final int id;
        final double[] spellColor;

        private BoundSpell(int p_33754_, double p_33755_, double p_33756_, double p_33757_) {
            this.id = p_33754_;
            this.spellColor = new double[]{p_33755_, p_33756_, p_33757_};
        }

        public static BoundSpell byId(int p_33759_) {
            for (BoundSpell spellcasterillager$illagerspell : BoundSpell.values()) {
                if (p_33759_ != spellcasterillager$illagerspell.id) continue;
                return spellcasterillager$illagerspell;
            }
            return NONE;
        }
    }

    public static enum BoundArmPose {
        CROSSED,
        ATTACKING,
        SPELLCASTING,
        BOW_AND_ARROW,
        CROSSBOW_HOLD,
        CROSSBOW_CHARGE,
        CELEBRATING,
        NEUTRAL;

    }

    protected abstract class BoundUseSpellGoal
    extends Goal {
        protected int attackWarmupDelay;
        protected int nextAttackTickCount;

        protected BoundUseSpellGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = AbstractBoundIllager.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                if (AbstractBoundIllager.this.isCastingSpell()) {
                    return false;
                }
                return AbstractBoundIllager.this.f_19797_ >= this.nextAttackTickCount;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = AbstractBoundIllager.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.attackWarmupDelay > 0;
        }

        public void m_8056_() {
            this.attackWarmupDelay = this.m_183277_(this.getCastWarmupTime());
            AbstractBoundIllager.this.spellCastingTickCount = this.getCastingTime();
            this.nextAttackTickCount = AbstractBoundIllager.this.f_19797_ + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                AbstractBoundIllager.this.m_5496_(soundevent, 1.0f, 1.0f);
            }
            AbstractBoundIllager.this.setIsCastingSpell(this.getSpell());
        }

        public void m_8037_() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == 0) {
                this.performSpellCasting();
                if (AbstractBoundIllager.this.getCastingSoundEvent() != null) {
                    AbstractBoundIllager.this.m_5496_(AbstractBoundIllager.this.getCastingSoundEvent(), 1.0f, 1.0f);
                }
            }
        }

        protected abstract void performSpellCasting();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract BoundSpell getSpell();
    }

    protected class BoundCastingSpellGoal
    extends Goal {
        public BoundCastingSpellGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return AbstractBoundIllager.this.getSpellCastingTime() > 0;
        }

        public void m_8056_() {
            super.m_8056_();
            AbstractBoundIllager.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            super.m_8041_();
            AbstractBoundIllager.this.setIsCastingSpell(BoundSpell.NONE);
        }

        public void m_8037_() {
            if (AbstractBoundIllager.this.m_5448_() != null) {
                AbstractBoundIllager.this.m_21563_().m_24960_((Entity)AbstractBoundIllager.this.m_5448_(), (float)AbstractBoundIllager.this.m_8085_(), (float)AbstractBoundIllager.this.m_8132_());
            }
        }
    }
}

