/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.zombie;

import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieServant;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class BlackguardServant
extends ZombieServant {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(BlackguardServant.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> HAS_SHIELD = SynchedEntityData.m_135353_(BlackguardServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int attackTick;
    public int shieldHealth = 1;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState standAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();

    public BlackguardServant(EntityType<? extends Summoned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void attackGoal() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(4, (Goal)new BlackguardAttackGoal());
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.BlackguardServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.BlackguardServantDamage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.BlackguardServantArmor.get()).doubleValue()).m_22268_(Attributes.f_22285_, ((Double)AttributesConfig.BlackguardServantToughness.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.BlackguardServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.BlackguardServantDamage.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.BlackguardServantArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22285_), (Double)AttributesConfig.BlackguardServantToughness.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_SHIELD, (Object)true);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("hasShield")) {
            this.setShield(pCompound.m_128471_("hasShield"));
        }
        if (pCompound.m_128441_("ShieldHeath")) {
            this.setShieldHealth(pCompound.m_128451_("ShieldHeath"));
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("hasShield", this.hasShield());
        pCompound.m_128405_("ShieldHeath", this.getShieldHealth());
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof BlackguardServant;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.BlackguardLimit.get();
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean hasShield() {
        return (Boolean)this.f_19804_.m_135370_(HAS_SHIELD);
    }

    public void setShield(boolean shield) {
        this.f_19804_.m_135381_(HAS_SHIELD, (Object)shield);
    }

    public int getShieldHealth() {
        return this.shieldHealth;
    }

    public void setShieldHealth(int shieldHealth) {
        this.shieldHealth = shieldHealth;
    }

    public void destroyShield() {
        if (this.hasShield()) {
            if (this.getShieldHealth() > 1) {
                this.setShieldHealth(this.getShieldHealth() - 1);
                this.m_216990_(SoundEvents.f_12346_);
            } else {
                this.setShieldHealth(0);
                this.setShield(false);
                this.m_216990_(SoundEvents.f_12347_);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42146_)), (Entity)this);
                }
            }
        }
    }

    public boolean isMeleeAttacking() {
        return this.getFlag(1);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.setFlags(1, attacking);
        this.attackTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    @Override
    protected boolean isSunSensitive() {
        return false;
    }

    @Override
    protected boolean convertsInWater() {
        return false;
    }

    @Override
    public EntityType<?> getVariant(Level level, BlockPos blockPos) {
        return (EntityType)ModEntityType.BLACKGUARD_SERVANT.get();
    }

    @Override
    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficulty) {
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.standAnimationState);
        animationStates.add(this.attackAnimationState);
        return animationStates;
    }

    public void stopAllAnimations() {
        for (AnimationState animationState : this.getAnimations()) {
            animationState.m_216973_();
        }
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        this.m_5496_((SoundEvent)ModSounds.PLATE_DROP.get(), this.m_6121_(), this.m_6100_());
        super.m_6667_(pCause);
    }

    protected void m_6677_(DamageSource p_21160_) {
        super.m_6677_(p_21160_);
        this.m_5496_((SoundEvent)ModSounds.PLATE.get(), this.m_6121_(), this.m_6100_());
    }

    @Override
    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSounds.BLACKGUARD_STEP.get();
    }

    @Override
    public void m_6863_(boolean pChildZombie) {
    }

    @Override
    public boolean m_6162_() {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.m_6084_()) {
            this.idleAnimationState.m_246184_(!this.isMeleeAttacking() && !this.isStaying() && !this.isMoving(), this.f_19797_);
            this.standAnimationState.m_246184_(!this.isMeleeAttacking() && this.isStaying() && !this.isMoving(), this.f_19797_);
            if (!this.isMeleeAttacking()) {
                this.attackAnimationState.m_216973_();
            }
        }
        if (this.isMeleeAttacking()) {
            ++this.attackTick;
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.f_19853_.f_46443_) {
            Entity entity;
            if (this.hasShield() && !source.m_269533_(DamageTypeTags.f_268738_)) {
                this.destroyShield();
                return false;
            }
            if (this.m_5448_() != null && (entity = source.m_7639_()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                double d0 = this.m_20270_((Entity)this.m_5448_());
                double d1 = this.m_20270_((Entity)livingEntity);
                if (MobUtil.ownedCanAttack(this, livingEntity) && livingEntity != this.getTrueOwner() && d0 > d1) {
                    this.m_6710_(livingEntity);
                }
            }
        }
        return super.m_6469_(source, amount);
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
        if (!this.hasShield()) {
            super.m_147240_(p_147241_, p_147242_, p_147243_);
        }
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.stopAllAnimations();
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (p_21375_ == 5) {
            this.attackTick = 0;
        } else if (p_21375_ == 6) {
            this.setShield(true);
            this.setShieldHealth(1);
        } else {
            super.m_7822_(p_21375_);
        }
    }

    protected double getAttackReachSqr(LivingEntity enemy) {
        return this.m_20205_() * 6.0f * this.m_20205_() * 6.0f + enemy.m_20205_();
    }

    public boolean targetClose(LivingEntity enemy, double distToEnemySqr) {
        return distToEnemySqr <= this.getAttackReachSqr(enemy) || this.m_20191_().m_82381_(enemy.m_20191_());
    }

    public Vec3 getHorizontalLookAngle() {
        return this.m_20171_(0.0f, this.m_146908_());
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
            if (item == Items.f_42583_ && this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                this.m_5634_(2.0f);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (!this.f_19853_.f_46443_ && !this.hasShield() && itemstack.m_204117_(Tags.Items.INGOTS_IRON) && this.m_5448_() == null && this.f_20916_ <= 0) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.setShield(true);
                this.setShieldHealth(1);
                this.f_19853_.m_7605_((Entity)this, (byte)6);
                this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    class MeleeGoal
    extends Goal {
        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return BlackguardServant.this.m_5448_() != null && BlackguardServant.this.isMeleeAttacking();
        }

        public boolean m_8045_() {
            return BlackguardServant.this.attackTick < MathHelper.secondsToTicks(1.42f);
        }

        public void m_8056_() {
            BlackguardServant.this.setMeleeAttacking(true);
            BlackguardServant.this.f_19853_.m_7605_((Entity)BlackguardServant.this, (byte)4);
        }

        public void m_8041_() {
            BlackguardServant.this.setMeleeAttacking(false);
        }

        public void m_8037_() {
            if (BlackguardServant.this.m_5448_() != null) {
                LivingEntity livingentity = BlackguardServant.this.m_5448_();
                MobUtil.instaLook((Mob)BlackguardServant.this, (Entity)livingentity);
                BlackguardServant.this.m_5618_(BlackguardServant.this.m_6080_());
                BlackguardServant.this.m_146922_(BlackguardServant.this.m_6080_());
            }
            if (BlackguardServant.this.attackTick == 1) {
                BlackguardServant.this.m_5496_((SoundEvent)ModSounds.BLACKGUARD_PRE_ATTACK.get(), BlackguardServant.this.m_6121_() + 1.0f, BlackguardServant.this.m_6100_());
            }
            if (BlackguardServant.this.attackTick == 9) {
                BlackguardServant.this.m_5496_((SoundEvent)ModSounds.BLACKGUARD_SMASH.get(), BlackguardServant.this.m_6121_() + 1.0f, BlackguardServant.this.m_6100_());
            }
            if (BlackguardServant.this.attackTick == 14) {
                LivingEntity target2;
                double x = BlackguardServant.this.m_20185_() + BlackguardServant.this.getHorizontalLookAngle().f_82479_ * 2.0;
                double z = BlackguardServant.this.m_20189_() + BlackguardServant.this.getHorizontalLookAngle().f_82481_ * 2.0;
                AABB aabb = MobUtil.makeAttackRange(x, BlackguardServant.this.m_20186_(), z, 3.0, 3.0, 3.0);
                for (LivingEntity target2 : BlackguardServant.this.f_19853_.m_45976_(LivingEntity.class, aabb)) {
                    if (target2 == BlackguardServant.this || MobUtil.areAllies((Entity)target2, (Entity)BlackguardServant.this)) continue;
                    BlackguardServant.this.m_7327_((Entity)target2);
                }
                target2 = BlackguardServant.this.f_19853_;
                if (target2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)target2;
                    BlockPos blockPos = BlockPos.m_274561_((double)x, (double)(BlackguardServant.this.m_20186_() - 1.0), (double)z);
                    BlockParticleOption option = new BlockParticleOption(ParticleTypes.f_123794_, serverLevel.m_8055_(blockPos));
                    for (int i = 0; i < 2; ++i) {
                        ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)option, BlackguardServant.this.m_20185_() + BlackguardServant.this.getHorizontalLookAngle().f_82479_ * 2.0, BlackguardServant.this.m_20186_() + 0.25, BlackguardServant.this.m_20189_() + BlackguardServant.this.getHorizontalLookAngle().f_82481_ * 2.0, 1.5f);
                    }
                    ColorUtil colorUtil = new ColorUtil(serverLevel.m_8055_((BlockPos)blockPos).m_284242_((BlockGetter)serverLevel, (BlockPos)blockPos).f_283871_);
                    serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), 1.5f, 1), x, BlockFinder.moveDownToGround((Entity)BlackguardServant.this), z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class BlackguardAttackGoal
    extends MeleeAttackGoal {
        private int delayCounter;
        private static final float SPEED = 1.0f;

        public BlackguardAttackGoal() {
            super((PathfinderMob)BlackguardServant.this, 1.0, true);
        }

        public boolean m_8036_() {
            return BlackguardServant.this.m_5448_() != null && BlackguardServant.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            BlackguardServant.this.m_21561_(true);
            this.delayCounter = 0;
        }

        public void m_8041_() {
            BlackguardServant.this.m_21573_().m_26573_();
            if (BlackguardServant.this.m_5448_() == null) {
                BlackguardServant.this.m_21561_(false);
            }
        }

        public void m_8037_() {
            LivingEntity livingentity = BlackguardServant.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            BlackguardServant.this.f_21365_.m_24960_((Entity)livingentity, 30.0f, 30.0f);
            double d0 = BlackguardServant.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            if (--this.delayCounter <= 0 && !BlackguardServant.this.targetClose(livingentity, d0)) {
                this.delayCounter = 10;
                BlackguardServant.this.m_21573_().m_5624_((Entity)livingentity, 1.0);
            }
            this.m_6739_(livingentity, BlackguardServant.this.m_20275_(livingentity.m_20185_(), livingentity.m_20191_().f_82289_, livingentity.m_20189_()));
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            if (BlackguardServant.this.targetClose(enemy, distToEnemySqr) && !BlackguardServant.this.isMeleeAttacking()) {
                BlackguardServant.this.setMeleeAttacking(true);
            }
        }
    }
}

