/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.zombie;

import com.Polarice3.Goety.common.entities.ai.path.ModWaterPathNavigation;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieServant;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MobUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class DrownedServant
extends ZombieServant
implements RangedAttackMob {
    private boolean searchingForLand;
    protected final ModWaterPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;

    public DrownedServant(EntityType<? extends ZombieServant> type, Level worldIn) {
        super((EntityType<? extends Summoned>)type, worldIn);
        this.m_274367_(1.0f);
        this.f_21342_ = new MoveHelperController(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.waterNavigation = new ModWaterPathNavigation((Mob)this, worldIn);
        this.groundNavigation = new GroundPathNavigation((Mob)this, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new Summoned.GoToWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TridentAttackGoal(this, 1.0, 40, 10.0f));
        this.f_21345_.m_25352_(5, (Goal)new GoToBeachGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new SwimUpGoal(this, 1.0, this.f_19853_.m_5736_()));
        this.f_21345_.m_25352_(7, (Goal)new Summoned.WaterWanderGoal((Summoned)this, (PathfinderMob)this));
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(5, (Goal)new Summoned.FollowOwnerWaterGoal(this, 1.0, 10.0f, 2.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.DrownedServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.DrownedServantDamage.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.DrownedServantArmor.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.DrownedServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.DrownedServantArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.DrownedServantDamage.get());
    }

    @Override
    protected SoundEvent m_7515_() {
        return this.m_20069_() ? SoundEvents.f_11816_ : SoundEvents.f_11815_;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return this.m_20069_() ? SoundEvents.f_11820_ : SoundEvents.f_11819_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return this.m_20069_() ? SoundEvents.f_11818_ : SoundEvents.f_11817_;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundEvents.f_11875_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11876_;
    }

    @Override
    public void populateDefaultWeapons(RandomSource randomSource, DifficultyInstance difficulty) {
        if (randomSource.m_188501_() > 0.9f) {
            int i = randomSource.m_188503_(16);
            if (i < 10) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42713_));
            }
            this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        }
    }

    public boolean m_6063_() {
        return !this.m_6069_();
    }

    @Override
    protected boolean convertsInWater() {
        return false;
    }

    public boolean m_6914_(LevelReader pLevel) {
        return pLevel.m_45784_((Entity)this);
    }

    private boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        if (this.m_5448_() != null && this.m_5448_().m_20069_()) {
            return true;
        }
        return this.getTrueOwner() != null && this.isFollowing() && (this.getTrueOwner().m_20069_() || this.m_20069_() && this.getTrueOwner().m_20186_() > this.m_20186_());
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.01f, pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_5844_() {
        if (!this.f_19853_.f_46443_) {
            if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.m_20282_(false);
            }
        }
    }

    public boolean m_6067_() {
        return this.m_6069_();
    }

    protected boolean closeToNextPos() {
        BlockPos blockpos;
        Path path = this.m_21573_().m_26570_();
        if (path != null && (blockpos = path.m_77406_()) != null) {
            double d0 = this.m_20275_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
            return d0 < 4.0;
        }
        return false;
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        ThrownTrident tridententity = new ThrownTrident(this.f_19853_, (LivingEntity)this, new ItemStack((ItemLike)Items.f_42713_));
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - tridententity.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        tridententity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        ItemHelper.hurtAndBreak(this.m_21205_(), 1, this);
        this.f_19853_.m_7967_((Entity)tridententity);
    }

    public void setSearchingForLand(boolean p_204713_1_) {
        this.searchingForLand = p_204713_1_;
    }

    static class MoveHelperController
    extends MoveControl {
        private final DrownedServant drowned;

        public MoveHelperController(DrownedServant p_i48909_1_) {
            super((Mob)p_i48909_1_);
            this.drowned = p_i48909_1_;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.drowned.m_5448_();
            LivingEntity owner = this.drowned.getTrueOwner();
            if (this.drowned.wantsToSwim() && this.drowned.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.drowned.m_20186_() || this.drowned.searchingForLand || owner != null && owner.m_20186_() > this.drowned.m_20186_() && this.drowned.isFollowing()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.drowned.m_21573_().m_26571_()) {
                    this.drowned.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.drowned.m_20185_();
                double d1 = this.f_24976_ - this.drowned.m_20186_();
                double d2 = this.f_24977_ - this.drowned.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.m_146922_(this.m_24991_(this.drowned.m_146908_(), f, 90.0f));
                this.drowned.m_5618_(this.drowned.m_146908_());
                float f1 = (float)(this.f_24978_ * this.drowned.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.drowned.m_6113_(), (float)f1);
                this.drowned.m_7910_(f2);
                this.drowned.m_20256_(this.drowned.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.drowned.m_20096_()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }

    static class TridentAttackGoal
    extends RangedAttackGoal {
        private final DrownedServant drowned;

        public TridentAttackGoal(RangedAttackMob p_i48907_1_, double p_i48907_2_, int p_i48907_4_, float p_i48907_5_) {
            super(p_i48907_1_, p_i48907_2_, p_i48907_4_, p_i48907_5_);
            this.drowned = (DrownedServant)p_i48907_1_;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.drowned.m_21205_().m_41720_() == Items.f_42713_;
        }

        public void m_8056_() {
            super.m_8056_();
            this.drowned.m_21561_(true);
            this.drowned.m_6672_(InteractionHand.MAIN_HAND);
        }

        public void m_8041_() {
            super.m_8041_();
            this.drowned.m_5810_();
            this.drowned.m_21561_(false);
        }
    }

    static class GoToBeachGoal
    extends MoveToBlockGoal {
        private final DrownedServant drowned;

        public GoToBeachGoal(DrownedServant p_i48911_1_, double p_i48911_2_) {
            super((PathfinderMob)p_i48911_1_, p_i48911_2_, 8, 2);
            this.drowned = p_i48911_1_;
        }

        public boolean m_8036_() {
            if (this.drowned.getTrueOwner() != null && this.drowned.isFollowing()) {
                return false;
            }
            return super.m_8036_() && !this.drowned.m_9236_().m_46461_() && this.drowned.m_20069_() && this.drowned.m_20186_() >= (double)(this.drowned.m_9236_().m_5736_() - 3);
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            BlockPos blockpos = pPos.m_7494_();
            return pLevel.m_46859_(blockpos) && pLevel.m_46859_(blockpos.m_7494_()) && pLevel.m_8055_(pPos).m_60634_((BlockGetter)pLevel, pPos, (Entity)this.drowned);
        }

        public void m_8056_() {
            this.drowned.setSearchingForLand(false);
            this.drowned.f_21344_ = (PathNavigation)this.drowned.groundNavigation;
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class SwimUpGoal
    extends Goal {
        private final DrownedServant drowned;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public SwimUpGoal(DrownedServant p_i48908_1_, double p_i48908_2_, int p_i48908_4_) {
            this.drowned = p_i48908_1_;
            this.speedModifier = p_i48908_2_;
            this.seaLevel = p_i48908_4_;
        }

        public boolean m_8036_() {
            if (this.drowned.getTrueOwner() != null && this.drowned.isFollowing()) {
                return false;
            }
            return !this.drowned.m_9236_().m_46461_() && this.drowned.m_20069_() && this.drowned.m_20186_() < (double)(this.seaLevel - 2);
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.stuck;
        }

        public void m_8037_() {
            if (this.drowned.m_20186_() < (double)(this.seaLevel - 1) && (this.drowned.m_21573_().m_26571_() || this.drowned.closeToNextPos())) {
                Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.drowned, (int)4, (int)8, (Vec3)new Vec3(this.drowned.m_20185_(), (double)(this.seaLevel - 1), this.drowned.m_20189_()), (double)1.5707963705062866);
                if (vec3 == null) {
                    this.stuck = true;
                    return;
                }
                this.drowned.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
            }
        }

        public void m_8056_() {
            this.drowned.setSearchingForLand(true);
            this.stuck = false;
        }

        public void m_8041_() {
            this.drowned.setSearchingForLand(false);
        }
    }
}

