/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.cultists;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.boss.Apostle;
import com.Polarice3.Goety.common.entities.hostile.cultists.Cultist;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public abstract class SpellCastingCultist
extends Cultist {
    private static final EntityDataAccessor<Byte> SPELL = SynchedEntityData.m_135353_(SpellCastingCultist.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected int spellTicks;
    private SpellType activeSpell = SpellType.NONE;

    protected SpellCastingCultist(EntityType<? extends SpellCastingCultist> type, Level p_i48551_2_) {
        super(type, p_i48551_2_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.spellTicks = compound.m_128451_("SpellTicks");
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("SpellTicks", this.spellTicks);
    }

    public boolean isSpellcasting() {
        if (this.f_19853_.f_46443_) {
            return (Byte)this.f_19804_.m_135370_(SPELL) > 0;
        }
        return this.spellTicks > 0;
    }

    public void setSpellType(SpellType spellType) {
        this.activeSpell = spellType;
        this.f_19804_.m_135381_(SPELL, (Object)((byte)spellType.id));
    }

    protected SpellType getSpellType() {
        return !this.f_19853_.f_46443_ ? this.activeSpell : SpellType.getFromId(((Byte)this.f_19804_.m_135370_(SPELL)).byteValue());
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.spellTicks > 0) {
            --this.spellTicks;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.isSpellcasting() && this.m_6084_()) {
            SpellType SpellcastingCultistEntity$spelltype = this.getSpellType();
            double d0 = SpellcastingCultistEntity$spelltype.particleSpeed[0];
            double d1 = SpellcastingCultistEntity$spelltype.particleSpeed[1];
            double d2 = SpellcastingCultistEntity$spelltype.particleSpeed[2];
            if (this instanceof Apostle) {
                float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
                float f1 = Mth.m_14089_((float)f);
                float f2 = Mth.m_14031_((float)f);
                if (this.m_5737_() == HumanoidArm.RIGHT) {
                    this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.CULT_SPELL.get(), this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, d0, d1, d2);
                } else {
                    this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.CULT_SPELL.get(), this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, d0, d1, d2);
                }
            } else {
                for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
                    double d = this.f_19853_.f_46441_.m_188583_() * 0.2;
                    this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.CULT_SPELL.get(), this.m_20185_(), this.m_20188_(), this.m_20189_(), d0, d1, d2);
                }
            }
        }
    }

    protected int getSpellTicks() {
        return this.spellTicks;
    }

    protected abstract SoundEvent getCastingSoundEvent();

    public static enum SpellType {
        NONE(0, 0.0, 0.0, 0.0),
        FIRE(1, 1.0, 0.6, 0.0),
        ZOMBIE(2, 0.1, 0.1, 0.8),
        ROAR(3, 0.8, 0.3, 0.8),
        TORNADO(4, 1.0, 0.1, 0.1),
        RANGED(5, 0.5, 0.5, 0.5),
        CLOUD(6, 0.3, 0.0, 0.0),
        SACRIFICE(7, 0.1, 0.1, 0.1);

        private final int id;
        private final double[] particleSpeed;

        private SpellType(int idIn, double xParticleSpeed, double yParticleSpeed, double zParticleSpeed) {
            this.id = idIn;
            this.particleSpeed = new double[]{xParticleSpeed, yParticleSpeed, zParticleSpeed};
        }

        public static SpellType getFromId(int idIn) {
            for (SpellType SpellcastingCultistEntity$spelltype : SpellType.values()) {
                if (idIn != SpellcastingCultistEntity$spelltype.id) continue;
                return SpellcastingCultistEntity$spelltype;
            }
            return NONE;
        }
    }

    public abstract class UseSpellGoal
    extends Goal {
        protected int spellWarmup;
        protected int spellCooldown;

        protected UseSpellGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = SpellCastingCultist.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                if (SpellCastingCultist.this.isSpellcasting()) {
                    return false;
                }
                return SpellCastingCultist.this.f_19797_ >= this.spellCooldown;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = SpellCastingCultist.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.spellWarmup > 0;
        }

        public void m_8056_() {
            this.spellWarmup = this.getCastWarmupTime();
            SpellCastingCultist.this.spellTicks = this.getCastingTime();
            this.spellCooldown = SpellCastingCultist.this.f_19797_ + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                SpellCastingCultist.this.m_5496_(soundevent, this.castingVolume(), 1.0f);
            }
            SpellCastingCultist.this.setSpellType(this.getSpellType());
        }

        public void m_8037_() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                this.castSpell();
                SpellCastingCultist.this.setSpellType(SpellType.NONE);
                SpellCastingCultist.this.m_5496_(SpellCastingCultist.this.getCastingSoundEvent(), 1.0f, 1.0f);
            }
        }

        protected float castingVolume() {
            return 1.0f;
        }

        protected abstract void castSpell();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract SpellType getSpellType();
    }

    public class CastingASpellGoal
    extends Goal {
        public CastingASpellGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return SpellCastingCultist.this.getSpellTicks() > 0;
        }

        public void m_8056_() {
            super.m_8056_();
            SpellCastingCultist.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            super.m_8041_();
            SpellCastingCultist.this.setSpellType(SpellType.NONE);
        }

        public void m_8037_() {
            if (SpellCastingCultist.this.m_5448_() != null) {
                SpellCastingCultist.this.m_21563_().m_24960_((Entity)SpellCastingCultist.this.m_5448_(), (float)SpellCastingCultist.this.m_8085_(), (float)SpellCastingCultist.this.m_8132_());
            }
        }
    }
}

