/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.servants;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.DustCloudParticleOption;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.Hellfire;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.Vec3Util;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Damned
extends Owned
implements Enemy {
    private static final EntityDataAccessor<Boolean> DATA_CHARGING_STATE = SynchedEntityData.m_135353_(Damned.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_HUMAN = SynchedEntityData.m_135353_(Damned.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Vec3 chargePos;
    private int chargeTime;

    public Damned(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.f_19794_ = true;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CHARGING_STATE, (Object)false);
        this.f_19804_.m_135372_(DATA_HUMAN, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Human")) {
            this.setHuman(compound.m_128471_("Human"));
        }
        if (compound.m_128441_("ChargePos")) {
            this.setCharge(Vec3Util.readVec3(compound.m_128469_("ChargePos")));
        }
        if (compound.m_128441_("ChargeTime")) {
            this.chargeTime = compound.m_128451_("ChargeTime");
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Human", this.isHuman());
        if (this.chargePos != null) {
            compound.m_128365_("ChargePos", (Tag)Vec3Util.writeVec3(this.chargePos));
        }
        compound.m_128405_("ChargeTime", this.chargeTime);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.m_20334_(0.0, 0.3, 0.0);
        if (pLevel.m_213780_().m_188499_()) {
            this.setHuman(true);
            pLevel.m_6018_().m_7605_((Entity)this, (byte)101);
        }
        return pSpawnData;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_146922_(this.m_6080_());
        this.f_20883_ = this.m_146908_();
        this.m_20242_(true);
        if (this.isCharging()) {
            HitResult hitresult;
            if (this.chargePos != null) {
                this.m_20256_(this.chargePos);
            }
            if (!this.m_9236_().f_46443_ && this.m_9236_().m_46749_(this.m_20183_()) && (hitresult = ProjectileUtil.m_278158_((Entity)this, this::canHitEntity)).m_6662_() != HitResult.Type.MISS) {
                this.onHit(hitresult);
            }
        }
        if (this.m_5448_() != null) {
            MobUtil.instaLook((Mob)this, (Entity)this.m_5448_());
            ++this.chargeTime;
            if (this.chargeTime == 50) {
                LivingEntity target = this.m_5448_();
                double dx = this.m_20185_() - target.m_20185_();
                double dy = this.m_20186_() - target.m_20186_();
                double dz = this.m_20189_() - target.m_20189_();
                double d0 = Math.sqrt(dx * dx + dy * dy + dz * dz);
                double velocity = 5.0;
                double xPower = -(dx / d0 * velocity * 0.2);
                double yPower = -(dy / d0 * velocity * 0.2);
                double zPower = -(dz / d0 * velocity * 0.2);
                this.m_5496_((SoundEvent)ModSounds.DAMNED_SCREAM.get(), 3.0f, this.m_6100_());
                this.setCharge(xPower, yPower, zPower);
                if (!this.f_19853_.f_46443_) {
                    this.setCharging(true);
                    this.f_19853_.m_7605_((Entity)this, (byte)100);
                    Vec3 vec3 = this.m_20184_();
                    double mX = this.m_20185_() - vec3.f_82479_;
                    double mY = this.m_20186_() - vec3.f_82480_;
                    double mZ = this.m_20189_() - vec3.f_82481_;
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_FIRE.get()), mX, mY + 0.15, mZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    @Override
    public void lifeSpanDamage() {
        this.m_146870_();
    }

    public boolean m_6060_() {
        return this.isCharging();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!pSource.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void setCharge(Vec3 vec3) {
        this.chargePos = vec3;
    }

    public void setCharge(double x, double y, double z) {
        this.chargePos = new Vec3(x, y, z);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGING_STATE);
    }

    public void setCharging(boolean charge) {
        this.f_19804_.m_135381_(DATA_CHARGING_STATE, (Object)charge);
    }

    public boolean isHuman() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HUMAN);
    }

    public void setHuman(boolean human) {
        this.f_19804_.m_135381_(DATA_HUMAN, (Object)human);
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 100) {
            this.setCharging(true);
        } else if (p_21375_ == 101) {
            this.setHuman(true);
        }
        super.m_7822_(p_21375_);
    }

    protected void onHitEntity(EntityHitResult pResult) {
        if (!this.f_19853_.f_46443_) {
            Entity entity = pResult.m_82443_();
            LivingEntity entity1 = this.m_269323_();
            float damage = (float)this.m_21133_(Attributes.f_22281_);
            entity.m_6469_(ModDamageSource.hellfire((Entity)this, (Entity)entity1), damage);
            if (entity1 instanceof LivingEntity) {
                LivingEntity living = entity1;
                this.m_19970_(living, entity);
            }
        }
    }

    protected void onHit(HitResult pResult) {
        if (pResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)pResult;
            this.onHitEntity(entityHitResult);
        }
        if (!this.f_19853_.f_46443_) {
            Damned damned;
            LivingEntity entity = this.m_269323_();
            Vec3 vec3 = Vec3.m_82512_((Vec3i)this.m_20183_());
            if (pResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)pResult;
                BlockPos blockpos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
                if (BlockFinder.canBeReplaced(this.f_19853_, blockpos)) {
                    vec3 = Vec3.m_82512_((Vec3i)blockpos);
                }
            } else if (pResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)pResult;
                Direction[] entity1 = entityHitResult.m_82443_();
                vec3 = Vec3.m_82512_((Vec3i)entity1.m_20183_());
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = entity;
                damned = living;
            } else {
                damned = this;
            }
            Damned livingEntity = damned;
            Hellfire hellfire = new Hellfire(this.f_19853_, vec3, (LivingEntity)livingEntity);
            if (this.f_19853_.m_7967_((Entity)hellfire)) {
                for (Direction direction : Direction.values()) {
                    if (!direction.m_122434_().m_122479_()) continue;
                    Hellfire hellfire1 = new Hellfire(this.f_19853_, Vec3.m_82512_((Vec3i)hellfire.m_20183_().m_121945_(direction)), (LivingEntity)livingEntity);
                    this.f_19853_.m_7967_((Entity)hellfire1);
                }
            }
            MobUtil.explosionDamage(this.f_19853_, (Entity)(this.m_269323_() != null ? this.m_269323_() : this), ModDamageSource.hellfire((Entity)this, (Entity)this.m_269323_()), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.5f, 0.0f);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ModParticleTypes.BIG_FIRE.get(), (Entity)this);
                ColorUtil colorUtil = new ColorUtil(14523414);
                serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 4.0f, 1), vec3.f_82479_, BlockFinder.moveDownToGround((Entity)this), vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 5.0f, 1), vec3.f_82479_, BlockFinder.moveDownToGround((Entity)this), vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                DustCloudParticleOption cloudParticleOptions = new DustCloudParticleOption(new Vector3f((Vector3fc)Vec3.m_82501_((int)8021604).m_252839_()), 1.0f);
                DustCloudParticleOption cloudParticleOptions2 = new DustCloudParticleOption(new Vector3f((Vector3fc)Vec3.m_82501_((int)15508116).m_252839_()), 1.0f);
                for (int i = 0; i < 2; ++i) {
                    ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)cloudParticleOptions, vec3.f_82479_, this.m_20186_() + 0.25, vec3.f_82481_, 0.0, 0.14, 0.0, 3.0f);
                }
                ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)cloudParticleOptions2, vec3.f_82479_, this.m_20186_() + 0.25, vec3.f_82481_, 0.0, 0.14, 0.0, 3.0f);
            }
            this.m_5496_(SoundEvents.f_11913_, 4.0f, 1.0f);
            this.m_5496_((SoundEvent)ModSounds.HELL_BLAST_IMPACT.get(), 4.0f, 1.0f);
            this.m_146870_();
        }
    }

    protected boolean canHitEntity(Entity pEntity) {
        if (this.m_269323_() != null) {
            Mob mob;
            if (pEntity == this.m_269323_()) {
                return false;
            }
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() == pEntity) {
                return true;
            }
            if (MobUtil.areAllies((Entity)this.m_269323_(), pEntity)) {
                return false;
            }
            if (MobUtil.areAllies((Entity)this, pEntity)) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                LivingEntity livingEntity2 = this.m_269323_();
                if (livingEntity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)livingEntity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return true;
    }
}

