/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.servants;

import com.Polarice3.Goety.common.entities.boss.Vizier;
import com.Polarice3.Goety.common.entities.projectiles.SwordProjectile;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VizierClone
extends SpellcasterIllager {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(VizierClone.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> OWNER_CLIENT_ID = SynchedEntityData.m_135353_(VizierClone.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> POSITION = SynchedEntityData.m_135353_(VizierClone.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> VIZIER_FLAGS = SynchedEntityData.m_135353_(VizierClone.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public int spellCool = 200;

    public VizierClone(EntityType<? extends SpellcasterIllager> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.f_21342_ = new MobUtil.MinionMoveControl((Mob)this);
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, pos);
        this.m_20101_();
    }

    public void m_8119_() {
        if (this.m_21515_()) {
            if (this.getOwner() == null || this.getOwner().m_21224_()) {
                if (!this.f_19853_.f_46443_) {
                    for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
                        ServerParticleUtil.smokeParticles((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20188_(), this.m_20189_(), this.f_19853_);
                    }
                }
                this.m_146870_();
            } else {
                if (this.m_20270_((Entity)this.getOwner()) > 32.0f) {
                    if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) > 8.0f) {
                        this.m_20219_(Vec3.m_82512_((Vec3i)BlockFinder.SummonPosition((Entity)this, this.getOwner().m_20183_())));
                    } else if (this.m_5448_() == null) {
                        this.m_20219_(Vec3.m_82512_((Vec3i)BlockFinder.SummonPosition((Entity)this, this.getOwner().m_20183_())));
                    }
                }
                if (this.isSpellcasting()) {
                    double z;
                    double x;
                    if (this.getPositionType() == 0) {
                        x = MobUtil.getHorizontalLeftLookAngle((Entity)this.getOwner()).f_82479_ * 4.0;
                        z = MobUtil.getHorizontalLeftLookAngle((Entity)this.getOwner()).f_82481_ * 4.0;
                    } else {
                        x = MobUtil.getHorizontalRightLookAngle((Entity)this.getOwner()).f_82479_ * 4.0;
                        z = MobUtil.getHorizontalRightLookAngle((Entity)this.getOwner()).f_82481_ * 4.0;
                    }
                    Vec3 vector3d = this.m_20184_().m_82542_(1.0, 0.6, 1.0);
                    if (!this.f_19853_.f_46443_) {
                        double d0 = vector3d.f_82480_;
                        if (this.m_20186_() < this.getOwner().m_20186_() + 1.0) {
                            d0 = Math.max(0.0, d0);
                            d0 += 0.3 - d0 * (double)0.6f;
                        }
                        vector3d = new Vec3(vector3d.f_82479_, d0, vector3d.f_82481_);
                        Vec3 vector3d1 = new Vec3(this.getOwner().m_20185_() + x - this.m_20185_(), 0.0, this.getOwner().m_20189_() + z - this.m_20189_());
                        if (VizierClone.getHorizontalDistanceSqr(vector3d1) > 9.0) {
                            Vec3 vector3d2 = vector3d1.m_82541_();
                            vector3d = vector3d.m_82520_(vector3d2.f_82479_ * 0.3 - vector3d.f_82479_ * 0.6, 0.0, vector3d2.f_82481_ * 0.3 - vector3d.f_82481_ * 0.6);
                        }
                    }
                    this.m_20256_(vector3d);
                    if (this.m_5448_() != null) {
                        MobUtil.instaLook((Mob)this, (Entity)this.m_5448_());
                    }
                }
            }
        }
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
        if (this.spellCool > 0) {
            --this.spellCool;
        }
    }

    public static double getHorizontalDistanceSqr(Vec3 pVector) {
        return pVector.f_82479_ * pVector.f_82479_ + pVector.f_82481_ * pVector.f_82481_;
    }

    protected SoundEvent m_7894_() {
        return SoundEvents.f_11862_;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new ShootSpellGoal());
        this.f_21345_.m_25352_(1, (Goal)new MoveRandomGoal());
        this.f_21345_.m_25352_(4, (Goal)new ChargeAttackGoal());
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f){

            public boolean m_8036_() {
                return super.m_8036_() && VizierClone.this.m_5448_() == null;
            }
        });
        this.f_21346_.m_25352_(0, (Goal)new CopyOwnerTargetGoal((PathfinderMob)this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.VizierHealth.get()).doubleValue()).m_22268_(Attributes.f_22281_, 5.0);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.VizierHealth.get());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(OWNER_CLIENT_ID, (Object)-1);
        this.f_19804_.m_135372_(POSITION, (Object)0);
        this.f_19804_.m_135372_(VIZIER_FLAGS, (Object)0);
    }

    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (compound.m_128441_("OwnerClient")) {
            this.setOwnerClientId(compound.m_128451_("OwnerClient"));
        }
        if (compound.m_128441_("Position")) {
            this.setPositionType(compound.m_128451_("Position"));
        }
        if (compound.m_128441_("SpellCool")) {
            this.spellCool = compound.m_128451_("SpellCool");
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getOwnerId() != null) {
            compound.m_128362_("Owner", this.getOwnerId());
        }
        if (this.getOwnerClientId() > -1) {
            compound.m_128405_("OwnerClient", this.getOwnerClientId());
        }
        if (this.getPositionType() > -1 && this.getPositionType() < 2) {
            compound.m_128405_("Position", this.getPositionType());
        }
        compound.m_128405_("SpellCool", this.spellCool);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.VIZIER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.VIZIER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.VIZIER_HURT.get();
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_21515_()) {
            return super.m_6469_(source, amount);
        }
        return source.m_269533_(DamageTypeTags.f_268738_);
    }

    public boolean m_7307_(Entity pEntity) {
        return MobUtil.illagerAllies((Entity)this, pEntity);
    }

    @Nullable
    public Vizier getOwner() {
        Vizier vizier;
        Entity entity;
        if (!this.f_19853_.f_46443_) {
            Vizier vizier2;
            LivingEntity livingEntity;
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : ((livingEntity = EntityFinder.getLivingEntityByUuiD(uuid)) instanceof Vizier ? (vizier2 = (Vizier)livingEntity) : null);
        }
        int id = this.getOwnerClientId();
        return id <= -1 ? null : ((entity = this.f_19853_.m_6815_(this.getOwnerClientId())) instanceof Vizier ? (vizier = (Vizier)entity) : null);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.getOwnerId();
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public int getOwnerClientId() {
        return (Integer)this.f_19804_.m_135370_(OWNER_CLIENT_ID);
    }

    public void setOwnerClientId(int id) {
        this.f_19804_.m_135381_(OWNER_CLIENT_ID, (Object)id);
    }

    public void setOwner(LivingEntity livingEntity) {
        this.setOwnerId(livingEntity.m_20148_());
        this.setOwnerClientId(livingEntity.m_19879_());
    }

    public int getPositionType() {
        return (Integer)this.f_19804_.m_135370_(POSITION);
    }

    public void setPositionType(int type) {
        this.f_19804_.m_135381_(POSITION, (Object)type);
    }

    private boolean getVizierFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(VIZIER_FLAGS);
        return (i & mask) != 0;
    }

    private void setVizierFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(VIZIER_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(VIZIER_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getVizierFlag(1);
    }

    public void setCharging(boolean charging) {
        this.setVizierFlag(1, charging);
    }

    public boolean isSpellcasting() {
        return this.getVizierFlag(2);
    }

    public void setSpellcasting(boolean spellcasting) {
        this.setVizierFlag(2, spellcasting);
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.isCharging()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        if (this.isSpellcasting()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        this.m_213945_(p_37856_.m_213780_(), p_37857_);
        this.m_213946_(p_37856_.m_213780_(), p_37857_);
        return super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    public void m_7895_(int wave, boolean p_213660_2_) {
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.VIZIER_CELEBRATE.get();
    }

    public boolean m_6072_() {
        return false;
    }

    class ShootSpellGoal
    extends Goal {
        int duration;
        int duration2;

        private ShootSpellGoal() {
        }

        public boolean m_8036_() {
            return VizierClone.this.getOwner() != null && VizierClone.this.m_5448_() != null && VizierClone.this.spellCool <= 0 && !VizierClone.this.isCharging();
        }

        public void m_8056_() {
            VizierClone.this.m_5496_(SoundEvents.f_11867_, 1.0f, 1.0f);
            VizierClone.this.setSpellcasting(true);
        }

        public void m_8041_() {
            VizierClone.this.setSpellcasting(false);
            VizierClone.this.spellCool = 100 + VizierClone.this.f_19796_.m_188503_(100);
            this.duration2 = 0;
            this.duration = 0;
        }

        public void m_8037_() {
            LivingEntity livingentity = VizierClone.this.m_5448_();
            if (livingentity != null) {
                int time;
                ++this.duration;
                ++this.duration2;
                if (!VizierClone.this.f_19853_.f_46443_) {
                    ServerLevel serverWorld = (ServerLevel)VizierClone.this.f_19853_;
                    for (int i = 0; i < 5; ++i) {
                        double d0 = serverWorld.f_46441_.m_188583_() * 0.02;
                        double d1 = serverWorld.f_46441_.m_188583_() * 0.02;
                        double d2 = serverWorld.f_46441_.m_188583_() * 0.02;
                        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123809_, VizierClone.this.m_20208_(1.0), VizierClone.this.m_20187_() + 1.0, VizierClone.this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                if (this.duration >= (time = 20)) {
                    this.duration = 0;
                    this.attack(livingentity);
                }
                if (this.duration2 >= 160) {
                    VizierClone.this.setSpellcasting(false);
                    VizierClone.this.spellCool = 100 + VizierClone.this.f_19796_.m_188503_(100);
                    this.duration2 = 0;
                    this.duration = 0;
                }
            } else {
                this.m_8041_();
            }
        }

        private void attack(LivingEntity livingEntity) {
            SwordProjectile swordProjectile = new SwordProjectile((LivingEntity)VizierClone.this, VizierClone.this.f_19853_, VizierClone.this.m_21205_());
            double d0 = livingEntity.m_20185_() - VizierClone.this.m_20185_();
            double d1 = livingEntity.m_20227_(0.3333333333333333) - swordProjectile.m_20186_();
            double d2 = livingEntity.m_20189_() - VizierClone.this.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            swordProjectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            swordProjectile.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - VizierClone.this.f_19853_.m_46791_().m_19028_() * 4);
            if (!VizierClone.this.m_21574_().m_148306_((Entity)livingEntity)) {
                swordProjectile.m_36790_(true);
            }
            VizierClone.this.f_19853_.m_7967_((Entity)swordProjectile);
            if (!VizierClone.this.m_20067_()) {
                VizierClone.this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f);
            }
        }

        private void spawnFangs(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = BlockPos.m_274561_((double)p_190876_1_, (double)p_190876_7_, (double)p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = VizierClone.this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)VizierClone.this.f_19853_, blockpos1, Direction.UP)) continue;
                if (!VizierClone.this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = VizierClone.this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)VizierClone.this.f_19853_, blockpos)).m_83281_()) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_190876_5_) - 1);
            if (flag) {
                VizierClone.this.f_19853_.m_7967_((Entity)new EvokerFangs(VizierClone.this.f_19853_, p_190876_1_, (double)blockpos.m_123342_() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (LivingEntity)VizierClone.this));
            }
        }
    }

    class MoveRandomGoal
    extends Goal {
        public MoveRandomGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !VizierClone.this.m_21566_().m_24995_() && VizierClone.this.f_19796_.m_188503_(7) == 0 && !VizierClone.this.isCharging();
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            double speed = 0.25;
            BlockPos blockpos = VizierClone.this.m_20183_();
            if (VizierClone.this.m_5448_() != null) {
                speed = 1.0;
                blockpos = VizierClone.this.m_5448_().m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(VizierClone.this.f_19796_.m_188503_(8) - 4, VizierClone.this.f_19796_.m_188503_(6) - 2, VizierClone.this.f_19796_.m_188503_(8) - 4);
                if (!VizierClone.this.f_19853_.m_46859_(blockpos1)) continue;
                VizierClone.this.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, speed);
                if (VizierClone.this.m_5448_() != null) break;
                VizierClone.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (VizierClone.this.m_5448_() != null && !VizierClone.this.m_21566_().m_24995_() && !VizierClone.this.isSpellcasting()) {
                return VizierClone.this.m_20280_((Entity)VizierClone.this.m_5448_()) > 8.0 || VizierClone.this.f_19796_.m_188503_(ChargeAttackGoal.m_186073_((int)100)) == 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return VizierClone.this.m_21566_().m_24995_() && VizierClone.this.isCharging() && !VizierClone.this.isSpellcasting() && VizierClone.this.m_5448_() != null && VizierClone.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingentity = VizierClone.this.m_5448_();
            if (livingentity != null) {
                Vec3 vector3d = livingentity.m_20182_();
                VizierClone.this.f_21342_.m_6849_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 1.0);
                VizierClone.this.setCharging(true);
                VizierClone.this.m_5496_((SoundEvent)ModSounds.VIZIER_CELEBRATE.get(), 1.0f, 1.0f);
            }
        }

        public void m_8041_() {
            VizierClone.this.setCharging(false);
        }

        public void m_8037_() {
            LivingEntity livingentity = VizierClone.this.m_5448_();
            if (livingentity != null) {
                VizierClone.this.m_21563_().m_24964_(livingentity.m_20182_());
                if (VizierClone.this.m_20191_().m_82400_(1.0).m_82381_(livingentity.m_20191_())) {
                    VizierClone.this.m_7327_((Entity)livingentity);
                    VizierClone.this.setCharging(false);
                } else {
                    double d0 = VizierClone.this.m_20280_((Entity)livingentity);
                    if (d0 < 9.0) {
                        Vec3 vector3d = livingentity.m_146892_();
                        VizierClone.this.f_21342_.m_6849_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 1.0);
                    }
                }
            }
        }
    }

    class CopyOwnerTargetGoal
    extends TargetGoal {
        private final TargetingConditions copyOwnerTargeting;

        public CopyOwnerTargetGoal(PathfinderMob p_34056_) {
            super((Mob)p_34056_, false);
            this.copyOwnerTargeting = TargetingConditions.m_148353_().m_148355_().m_26893_();
        }

        public boolean m_8036_() {
            return VizierClone.this.getOwner() != null && VizierClone.this.getOwner().m_5448_() != null && this.m_26150_(VizierClone.this.getOwner().m_5448_(), this.copyOwnerTargeting);
        }

        public void m_8056_() {
            if (VizierClone.this.getOwner() != null && VizierClone.this.getOwner().m_5448_() != null && this.m_26150_(VizierClone.this.getOwner().m_5448_(), this.copyOwnerTargeting)) {
                VizierClone.this.m_6710_(VizierClone.this.getOwner().m_5448_());
            }
            super.m_8056_();
        }
    }
}

