/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.ai.ModLeaveWaterGoal;
import com.Polarice3.Goety.common.entities.ai.path.GroundPathNavigatorFat;
import com.Polarice3.Goety.common.entities.ai.path.ModWaterPathNavigation;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.ReaperServant;
import com.Polarice3.Goety.common.entities.ally.undead.WraithServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.AbstractSkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.SunkenSkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.VanguardServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.BlackguardServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.DrownedServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieServant;
import com.Polarice3.Goety.common.entities.neutral.AbstractNecromancer;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.SteamMissile;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.revive.SoulJar;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class DrownedNecromancer
extends AbstractNecromancer {
    private boolean searchingForLand;
    protected int stormSpellCool;
    protected int rapidShotCool;
    protected final ModWaterPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    public static String STORM = "storm";
    public static String RAPID = "rapid";
    public AnimationState stormAnimationState = new AnimationState();
    public AnimationState rapidAnimationState = new AnimationState();

    public DrownedNecromancer(EntityType<? extends AbstractNecromancer> type, Level level) {
        super((EntityType<? extends AbstractSkeletonServant>)type, level);
        this.m_274367_(1.25f);
        this.f_21342_ = new MoveHelperController(this, 2.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.waterNavigation = new ModWaterPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigatorFat((Mob)this, level);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new Summoned.GoToWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(4, new ModLeaveWaterGoal<DrownedNecromancer>(this));
        this.f_21345_.m_25352_(5, (Goal)new GoToBeachGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new SwimUpGoal(this, 1.0, this.f_19853_.m_5736_()));
        this.f_21345_.m_25352_(7, (Goal)new Summoned.WaterWanderGoal((Summoned)this, (PathfinderMob)this));
        this.f_21345_.m_25352_(8, (Goal)new MoveToTarget());
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(5, (Goal)new Summoned.FollowOwnerWaterGoal(this, 1.0, 10.0f, 2.0f));
    }

    @Override
    public void projectileGoal(int priority) {
        this.f_21345_.m_25352_(priority, (Goal)new RapidShotGoal());
    }

    @Override
    public void avoidGoal(int priority) {
        this.f_21345_.m_25352_(priority, AvoidTargetGoal.AvoidRadiusGoal.newGoalTwo(this, 2.0f, 5, 1.0, 1.2));
    }

    @Override
    public void summonSpells(int priority) {
        this.f_21345_.m_25352_(priority, (Goal)new TridentStormGoal());
        this.f_21345_.m_25352_(priority + 1, (Goal)new SummonServantSpell());
        this.f_21345_.m_25352_(priority + 2, (Goal)new DrownedSummonUndeadGoal());
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.DrownedNecromancerHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.DrownedNecromancerArmor.get()).doubleValue()).m_22268_(Attributes.f_22277_, ((Double)AttributesConfig.DrownedNecromancerFollowRange.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 0.6).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.DrownedNecromancerDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.DrownedNecromancerHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.DrownedNecromancerArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22277_), (Double)AttributesConfig.DrownedNecromancerFollowRange.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.DrownedNecromancerDamage.get());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("StormCoolDown")) {
            this.stormSpellCool = pCompound.m_128451_("StormCoolDown");
        }
        if (pCompound.m_128441_("RapidCoolDown")) {
            this.rapidShotCool = pCompound.m_128451_("RapidCoolDown");
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("StormCoolDown", this.stormSpellCool);
        pCompound.m_128405_("RapidCoolDown", this.rapidShotCool);
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof DrownedNecromancer;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.DrownedNecromancerLimit.get();
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> p_33609_) {
        if (ANIM_STATE.equals(p_33609_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 6: {
                    this.stormAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.stormAnimationState);
                    break;
                }
                case 7: {
                    this.rapidAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.rapidAnimationState);
                }
            }
        }
        super.m_7350_(p_33609_);
    }

    @Override
    public int getAnimationState(String animation) {
        if (Objects.equals(animation, STORM)) {
            return 6;
        }
        if (Objects.equals(animation, RAPID)) {
            return 7;
        }
        return super.getAnimationState(animation);
    }

    @Override
    public List<AnimationState> getAnimations() {
        List<AnimationState> animationStates = super.getAnimations();
        animationStates.add(this.stormAnimationState);
        animationStates.add(this.rapidAnimationState);
        return animationStates;
    }

    @Override
    public int xpReward() {
        return 40;
    }

    @Override
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.DROWNED_NECROMANCER_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.DROWNED_NECROMANCER_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.DROWNED_NECROMANCER_DEATH.get();
    }

    @NotNull
    protected SoundEvent m_5501_() {
        return (SoundEvent)ModSounds.DROWNED_NECROMANCER_SWIM.get();
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundEvents.f_11875_;
    }

    public boolean isPushedByFluid(FluidType type) {
        return !this.m_6069_();
    }

    public boolean m_6914_(LevelReader pLevel) {
        return pLevel.m_45784_((Entity)this);
    }

    private boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        if (this.m_5448_() != null && this.m_5448_().m_20069_()) {
            return true;
        }
        return this.getTrueOwner() != null && this.isFollowing() && (this.getTrueOwner().m_20069_() || this.m_20069_() && this.getTrueOwner().m_20186_() > this.m_20186_());
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        float f1 = this.getNecroLevel();
        float size = 1.0f + Math.max(f1 * 0.15f, 0.0f);
        return 2.5f * size;
    }

    @Override
    public void setNecroLevel(int shot) {
        int i = Mth.m_14045_((int)shot, (int)0, (int)2);
        this.f_19804_.m_135381_(LEVEL, (Object)i);
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22276_);
        if (attributeInstance != null) {
            attributeInstance.m_22100_((Double)AttributesConfig.DrownedNecromancerHealth.get() * (double)Math.max((float)i * 1.25f, 1.0f));
        }
        this.m_20090_();
        this.m_6210_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.stormSpellCool > 0) {
            --this.stormSpellCool;
        }
        if (this.rapidShotCool > 0) {
            --this.rapidShotCool;
        }
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.01f, pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_5844_() {
        if (!this.f_19853_.f_46443_) {
            if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.m_20282_(false);
            }
        }
    }

    protected boolean closeToNextPos() {
        BlockPos blockpos;
        Path path = this.m_21573_().m_26570_();
        if (path != null && (blockpos = path.m_77406_()) != null) {
            double d0 = this.m_20275_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
            return d0 < 4.0;
        }
        return false;
    }

    public void setSearchingForLand(boolean p_204713_1_) {
        this.searchingForLand = p_204713_1_;
    }

    @Override
    public Summoned getDefaultSummon() {
        return new DrownedServant((EntityType<? extends ZombieServant>)((EntityType)ModEntityType.DROWNED_SERVANT.get()), this.f_19853_);
    }

    @Override
    public Summoned getSummon() {
        Summoned summoned = this.getDefaultSummon();
        if (this.getSummonList().stream().anyMatch(entityType -> entityType.m_204039_(ModTags.EntityTypes.ZOMBIE_SERVANTS)) && this.f_19853_.f_46441_.m_188499_()) {
            summoned = new DrownedServant((EntityType<? extends ZombieServant>)((EntityType)ModEntityType.DROWNED_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().stream().anyMatch(entityType -> entityType.m_204039_(ModTags.EntityTypes.SKELETON_SERVANTS)) && this.f_19853_.f_46441_.m_188499_()) {
            summoned = new SunkenSkeletonServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.SUNKEN_SKELETON_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.WRAITH_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
            summoned = new WraithServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.WRAITH_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.REAPER_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
            summoned = new ReaperServant((EntityType<? extends Owned>)((EntityType)ModEntityType.REAPER_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.VANGUARD_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.15f) {
            summoned = new VanguardServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.VANGUARD_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.BLACKGUARD_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
            summoned = new BlackguardServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.BLACKGUARD_SERVANT.get()), this.f_19853_);
        }
        return summoned;
    }

    @Override
    public boolean summonVariants() {
        return false;
    }

    @Override
    public void spellCastParticles() {
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            Item item = itemstack.m_41720_();
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
                if (!this.spawnUndeadIdle() && pHand == InteractionHand.MAIN_HAND && itemstack.m_41619_()) {
                    if (this.idleSpellCool <= 0 && this.getSpellCooldown() <= 0) {
                        this.setUndeadIdle(true);
                    } else {
                        this.m_216990_((SoundEvent)ModSounds.DROWNED_NECROMANCER_HURT.get());
                        this.f_19853_.m_7605_((Entity)this, (byte)9);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (item == Items.f_42583_ && this.m_21223_() < this.m_21233_()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_5496_(SoundEvents.f_11875_, 1.0f, 1.25f);
                    this.m_5634_(2.0f);
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (this.getSummonList().stream().noneMatch(entityType -> entityType.m_204039_(ModTags.EntityTypes.ZOMBIE_SERVANTS)) && item == ModItems.ROTTING_FOCUS.get()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.addSummon((EntityType)ModEntityType.ZOMBIE_SERVANT.get());
                    this.m_5496_((SoundEvent)ModSounds.DROWNED_NECROMANCER_AMBIENT.get(), 1.0f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                if (this.getSummonList().stream().noneMatch(entityType -> entityType.m_204039_(ModTags.EntityTypes.SKELETON_SERVANTS)) && item == ModItems.OSSEOUS_FOCUS.get()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.addSummon((EntityType)ModEntityType.SKELETON_SERVANT.get());
                    this.m_5496_((SoundEvent)ModSounds.DROWNED_NECROMANCER_AMBIENT.get(), 1.0f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                if (!this.getSummonList().contains(ModEntityType.WRAITH_SERVANT.get()) && item == ModItems.SPOOKY_FOCUS.get()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.addSummon((EntityType)ModEntityType.WRAITH_SERVANT.get());
                    this.m_5496_((SoundEvent)ModSounds.DROWNED_NECROMANCER_AMBIENT.get(), 1.0f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                if (!this.getSummonList().contains(ModEntityType.REAPER_SERVANT.get()) && item == ModItems.REAPING_FOCUS.get()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.addSummon((EntityType)ModEntityType.REAPER_SERVANT.get());
                    this.m_5496_((SoundEvent)ModSounds.DROWNED_NECROMANCER_AMBIENT.get(), 1.0f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                if (!this.getSummonList().contains(ModEntityType.VANGUARD_SERVANT.get()) && item == ModItems.VANGUARD_FOCUS.get()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.addSummon((EntityType)ModEntityType.VANGUARD_SERVANT.get());
                    this.m_5496_((SoundEvent)ModSounds.DROWNED_NECROMANCER_AMBIENT.get(), 1.0f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                if (!this.getSummonList().contains(ModEntityType.BLACKGUARD_SERVANT.get()) && item == ModItems.BLACKGUARD_FOCUS.get()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.addSummon((EntityType)ModEntityType.BLACKGUARD_SERVANT.get());
                    this.m_5496_((SoundEvent)ModSounds.DROWNED_NECROMANCER_AMBIENT.get(), 1.0f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                if (SoulJar.isDrowned(itemstack)) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    if (this.getNecroLevel() < 2) {
                        this.setNecroLevel(this.getNecroLevel() + 1);
                    }
                    this.m_5634_(((Double)AttributesConfig.DrownedNecromancerHealth.get()).floatValue());
                    Level i = this.f_19853_;
                    if (i instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)i;
                        for (int i2 = 0; i2 < 7; ++i2) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235898_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    this.m_5496_((SoundEvent)ModSounds.DROWNED_NECROMANCER_AMBIENT.get(), 1.0f, 0.5f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    static class MoveHelperController
    extends MoveControl {
        private final DrownedNecromancer drowned;
        private final float speedModifier2;

        public MoveHelperController(DrownedNecromancer p_i48909_1_, float speedModifier) {
            super((Mob)p_i48909_1_);
            this.drowned = p_i48909_1_;
            this.speedModifier2 = speedModifier;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.drowned.m_5448_();
            LivingEntity owner = this.drowned.getTrueOwner();
            if (this.drowned.wantsToSwim() && this.drowned.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.drowned.m_20186_() || this.drowned.searchingForLand || owner != null && owner.m_20186_() > this.drowned.m_20186_() && this.drowned.isFollowing()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.drowned.m_21573_().m_26571_()) {
                    this.drowned.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.drowned.m_20185_();
                double d1 = this.f_24976_ - this.drowned.m_20186_();
                double d2 = this.f_24977_ - this.drowned.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.m_146922_(this.m_24991_(this.drowned.m_146908_(), f, 90.0f));
                this.drowned.f_20883_ = this.drowned.m_146908_();
                float f1 = (float)(this.f_24978_ * (double)this.speedModifier2 * this.drowned.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.drowned.m_6113_(), (float)f1);
                this.drowned.m_7910_(f2);
                this.drowned.m_20256_(this.drowned.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.drowned.m_20096_()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }

    static class GoToBeachGoal
    extends MoveToBlockGoal {
        private final DrownedNecromancer drowned;

        public GoToBeachGoal(DrownedNecromancer p_i48911_1_, double p_i48911_2_) {
            super((PathfinderMob)p_i48911_1_, p_i48911_2_, 8, 2);
            this.drowned = p_i48911_1_;
        }

        public boolean m_8036_() {
            if (this.drowned.getTrueOwner() != null && this.drowned.isFollowing()) {
                return false;
            }
            return super.m_8036_() && !this.drowned.m_9236_().m_46461_() && this.drowned.m_20069_() && this.drowned.m_20186_() >= (double)(this.drowned.m_9236_().m_5736_() - 3);
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            BlockPos blockpos = pPos.m_7494_();
            return pLevel.m_46859_(blockpos) && pLevel.m_46859_(blockpos.m_7494_()) && pLevel.m_8055_(pPos).m_60634_((BlockGetter)pLevel, pPos, (Entity)this.drowned);
        }

        public void m_8056_() {
            this.drowned.setSearchingForLand(false);
            this.drowned.f_21344_ = (PathNavigation)this.drowned.groundNavigation;
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class SwimUpGoal
    extends Goal {
        private final DrownedNecromancer drowned;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public SwimUpGoal(DrownedNecromancer p_i48908_1_, double p_i48908_2_, int p_i48908_4_) {
            this.drowned = p_i48908_1_;
            this.speedModifier = p_i48908_2_;
            this.seaLevel = p_i48908_4_;
        }

        public boolean m_8036_() {
            if (this.drowned.getTrueOwner() != null && this.drowned.isFollowing()) {
                return false;
            }
            return !this.drowned.m_9236_().m_46461_() && this.drowned.m_20069_() && this.drowned.m_20186_() < (double)(this.seaLevel - 2);
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.stuck;
        }

        public void m_8037_() {
            if (this.drowned.m_20186_() < (double)(this.seaLevel - 1) && (this.drowned.m_21573_().m_26571_() || this.drowned.closeToNextPos())) {
                Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.drowned, (int)4, (int)8, (Vec3)new Vec3(this.drowned.m_20185_(), (double)(this.seaLevel - 1), this.drowned.m_20189_()), (double)1.5707963705062866);
                if (vec3 == null) {
                    this.stuck = true;
                    return;
                }
                this.drowned.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
            }
        }

        public void m_8056_() {
            this.drowned.setSearchingForLand(true);
            this.stuck = false;
        }

        public void m_8041_() {
            this.drowned.setSearchingForLand(false);
        }
    }

    public class MoveToTarget
    extends Goal {
        @Nullable
        private LivingEntity target;

        public boolean m_8036_() {
            LivingEntity livingentity = DrownedNecromancer.this.m_5448_();
            if (DrownedNecromancer.this.isSpellCasting() || DrownedNecromancer.this.isShooting()) {
                return false;
            }
            if (livingentity != null && livingentity.m_6084_()) {
                this.target = livingentity;
                return (double)this.target.m_20270_((Entity)DrownedNecromancer.this) > 12.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && (double)this.target.m_20270_((Entity)DrownedNecromancer.this) > 6.0 && !DrownedNecromancer.this.isSpellCasting() && !DrownedNecromancer.this.isShooting();
        }

        public void m_8041_() {
            DrownedNecromancer.this.m_21573_().m_26573_();
            DrownedNecromancer.this.setAnimationState(AbstractNecromancer.IDLE);
        }

        public void m_8037_() {
            if (this.target != null) {
                DrownedNecromancer.this.m_21573_().m_5624_((Entity)this.target, 1.0);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public class RapidShotGoal
    extends Goal {
        protected int spellTime;
        protected int shots;
        protected int totalShots;
        @Nullable
        private LivingEntity target;

        public boolean m_8036_() {
            LivingEntity livingentity = DrownedNecromancer.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && DrownedNecromancer.this.rapidShotCool <= 0 && DrownedNecromancer.this.stormSpellCool > 0) {
                this.target = livingentity;
                return !DrownedNecromancer.this.isSpellCasting();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && this.totalShots < 4 && !DrownedNecromancer.this.isSpellCasting() && DrownedNecromancer.this.stormSpellCool > 0;
        }

        public void m_8056_() {
            this.spellTime = 0;
            this.shots = 0;
            this.totalShots = 0;
            DrownedNecromancer.this.m_21573_().m_26573_();
            DrownedNecromancer.this.setShooting(true);
            DrownedNecromancer.this.setAnimationState(RAPID);
        }

        public void m_8041_() {
            this.spellTime = 0;
            this.shots = 0;
            this.totalShots = 0;
            DrownedNecromancer.this.setShooting(false);
            if (DrownedNecromancer.this.getCurrentAnimation() == DrownedNecromancer.this.getAnimationState(RAPID)) {
                DrownedNecromancer.this.setAnimationState(AbstractNecromancer.IDLE);
            }
            DrownedNecromancer.this.rapidShotCool = MathHelper.secondsToTicks(5);
        }

        public void m_8037_() {
            ++this.spellTime;
            Level worldIn = DrownedNecromancer.this.f_19853_;
            MobUtil.instaLook((Mob)DrownedNecromancer.this, (Entity)this.target);
            if (this.spellTime % 2 == 0 && this.shots < 5) {
                Vec3 vector3d = DrownedNecromancer.this.m_20252_(1.0f);
                double accuracy = 8.0;
                Vec3 vec3 = new Vec3(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_).m_82541_().m_82520_(worldIn.f_46441_.m_216328_(0.0, 0.0172275 * accuracy), 0.0, worldIn.f_46441_.m_216328_(0.0, 0.0172275 * accuracy));
                SteamMissile steamMissile = new SteamMissile(DrownedNecromancer.this.m_20185_() + vector3d.f_82479_ / 2.0, DrownedNecromancer.this.m_20188_() - 0.2, DrownedNecromancer.this.m_20189_() + vector3d.f_82481_ / 2.0, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, worldIn);
                steamMissile.m_5602_((Entity)DrownedNecromancer.this);
                steamMissile.setExtraDamage(DrownedNecromancer.this.getNecroLevel());
                if (worldIn.m_7967_((Entity)steamMissile)) {
                    ++this.shots;
                }
            }
            if (this.spellTime % 18 == 0) {
                DrownedNecromancer.this.m_5496_((SoundEvent)ModSounds.CAST_STEAM.get(), 1.5f, 1.0f);
                if (this.shots >= 5) {
                    this.shots = 0;
                    ++this.totalShots;
                }
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public class TridentStormGoal
    extends Goal {
        protected int spellTime;

        public boolean m_8036_() {
            LivingEntity target = DrownedNecromancer.this.m_5448_();
            if (DrownedNecromancer.this.isSpellCasting()) {
                return false;
            }
            return target != null && target.m_6084_() && DrownedNecromancer.this.stormSpellCool <= 0;
        }

        public boolean m_8045_() {
            return this.spellTime > 0;
        }

        public void m_8056_() {
            this.spellTime = MathHelper.secondsToTicks(5);
            DrownedNecromancer.this.m_21573_().m_26573_();
            DrownedNecromancer.this.setSpellCooldown(DrownedNecromancer.this.getSpellCooldown() + 60);
            DrownedNecromancer.this.m_5496_((SoundEvent)ModSounds.TRIDENT_STORM_PRE.get(), 2.0f, 1.1f);
            DrownedNecromancer.this.setSpellCasting(true);
            DrownedNecromancer.this.setNecromancerSpellType(AbstractNecromancer.NecromancerSpellType.CLOUD);
            DrownedNecromancer.this.setAnimationState(STORM);
            int warmUp = MathHelper.secondsToTicks(2);
            int i = DrownedNecromancer.this.m_217043_().m_188503_(4);
            if (i == 0) {
                WandUtil.summonTridentSurround((LivingEntity)DrownedNecromancer.this, warmUp, DrownedNecromancer.this.getNecroLevel());
            } else if (i == 1) {
                WandUtil.summonTridentSquare((LivingEntity)DrownedNecromancer.this, warmUp, DrownedNecromancer.this.getNecroLevel());
            } else if (i == 2) {
                WandUtil.summonTridentWideCircle((LivingEntity)DrownedNecromancer.this, warmUp, DrownedNecromancer.this.getNecroLevel());
            } else {
                WandUtil.summonTridentCross((LivingEntity)DrownedNecromancer.this, warmUp, DrownedNecromancer.this.getNecroLevel());
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.spellTime = 0;
            DrownedNecromancer.this.setSpellCasting(false);
            if (DrownedNecromancer.this.getCurrentAnimation() == DrownedNecromancer.this.getAnimationState(STORM)) {
                DrownedNecromancer.this.setAnimationState(AbstractNecromancer.IDLE);
            }
        }

        public void m_8037_() {
            --this.spellTime;
            if (this.spellTime <= MathHelper.secondsToTicks(2.5f)) {
                DrownedNecromancer.this.setAnimationState(AbstractNecromancer.IDLE);
            }
            if (this.spellTime == 0) {
                DrownedNecromancer.this.setNecromancerSpellType(AbstractNecromancer.NecromancerSpellType.NONE);
                DrownedNecromancer.this.stormSpellCool = MathHelper.secondsToTicks(10);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public class SummonServantSpell
    extends AbstractNecromancer.SummoningSpellGoal {
        @Override
        public boolean m_8036_() {
            Predicate<Entity> predicate = entity -> {
                IOwned owned;
                return entity.m_6084_() && entity instanceof IOwned && (owned = (IOwned)entity).getTrueOwner() instanceof AbstractNecromancer;
            };
            int i = DrownedNecromancer.this.f_19853_.m_6443_(LivingEntity.class, DrownedNecromancer.this.m_20191_().m_82377_(64.0, 16.0, 64.0), predicate).size();
            return super.m_8036_() && i < 10 && DrownedNecromancer.this.stormSpellCool > 0;
        }

        @Override
        protected void castSpell() {
            Level level = DrownedNecromancer.this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i1 = 0; i1 < 2; ++i1) {
                    Summoned summonedentity = DrownedNecromancer.this.getSummon();
                    BlockPos blockPos = BlockFinder.SummonRadius(DrownedNecromancer.this.m_20183_(), (Entity)summonedentity, (Level)serverLevel);
                    if (DrownedNecromancer.this.m_5842_()) {
                        blockPos = BlockFinder.SummonWaterRadius((LivingEntity)DrownedNecromancer.this, (Level)serverLevel);
                    }
                    summonedentity.setTrueOwner((LivingEntity)DrownedNecromancer.this);
                    summonedentity.m_20035_(blockPos, 0.0f, 0.0f);
                    if (!DrownedNecromancer.this.m_5842_()) {
                        MobUtil.moveDownToGround((Entity)summonedentity);
                    }
                    if (((Boolean)MobsConfig.NecromancerSummonsLife.get()).booleanValue()) {
                        summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)serverLevel));
                    }
                    summonedentity.m_21530_();
                    summonedentity.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(DrownedNecromancer.this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    if (summonedentity instanceof DrownedServant && serverLevel.f_46441_.m_188503_(16) == 0) {
                        summonedentity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42713_));
                        summonedentity.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                    }
                    summonedentity.m_6863_(false);
                    if (!serverLevel.m_7967_((Entity)summonedentity)) continue;
                    if (!DrownedNecromancer.this.m_20067_()) {
                        DrownedNecromancer.this.f_19853_.m_6263_(null, DrownedNecromancer.this.m_20185_(), DrownedNecromancer.this.m_20186_(), DrownedNecromancer.this.m_20189_(), (SoundEvent)ModSounds.DROWNED_NECROMANCER_SUMMON.get(), DrownedNecromancer.this.m_5720_(), 1.4f, 1.0f);
                    }
                    ColorUtil colorUtil = new ColorUtil(2804175);
                    ServerParticleUtil.windShockwaveParticle(serverLevel, colorUtil, 0.1f, 0.1f, 0.05f, -1, summonedentity.m_20182_());
                }
            }
        }

        @Override
        protected int getCastingTime() {
            return MathHelper.secondsToTicks(1.8f);
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.DROWNED_NECROMANCER_PREPARE.get();
        }

        @Override
        protected void playLaughSound() {
        }

        @Override
        protected AbstractNecromancer.NecromancerSpellType getNecromancerSpellType() {
            return AbstractNecromancer.NecromancerSpellType.ZOMBIE;
        }
    }

    public class DrownedSummonUndeadGoal
    extends Goal {
        protected int spellTime;

        public boolean m_8036_() {
            if (DrownedNecromancer.this.m_5448_() != null && DrownedNecromancer.this.m_5448_().m_6084_()) {
                return false;
            }
            if (DrownedNecromancer.this.isShooting()) {
                return false;
            }
            if (DrownedNecromancer.this.isSpellCasting()) {
                return false;
            }
            if (!DrownedNecromancer.this.spawnUndeadIdle()) {
                return false;
            }
            return DrownedNecromancer.this.getSpellCooldown() <= 0 && DrownedNecromancer.this.idleSpellCool <= 0;
        }

        public boolean m_8045_() {
            return this.spellTime > 0 && DrownedNecromancer.this.f_20916_ <= 0;
        }

        public void m_8056_() {
            this.spellTime = 29;
            DrownedNecromancer.this.setSpellCooldown(100);
            DrownedNecromancer.this.m_5496_((SoundEvent)ModSounds.PREPARE_SUMMON.get(), 1.0f, 1.0f);
            DrownedNecromancer.this.setSpellCasting(true);
            DrownedNecromancer.this.setNecromancerSpellType(AbstractNecromancer.NecromancerSpellType.ZOMBIE);
            DrownedNecromancer.this.setAnimationState(AbstractNecromancer.SPELL_ANIM);
        }

        public void m_8041_() {
            super.m_8041_();
            DrownedNecromancer.this.setSpellCasting(false);
            DrownedNecromancer.this.setAnimationState(AbstractNecromancer.IDLE);
        }

        public void m_8037_() {
            --this.spellTime;
            if (this.spellTime == 0) {
                DrownedNecromancer.this.m_5496_((SoundEvent)ModSounds.DROWNED_NECROMANCER_AMBIENT.get(), 2.0f, DrownedNecromancer.this.m_6100_());
                DrownedNecromancer.this.setNecromancerSpellType(AbstractNecromancer.NecromancerSpellType.NONE);
                int i = 2 + DrownedNecromancer.this.f_19853_.f_46441_.m_188503_(4);
                for (int i1 = 0; i1 < i; ++i1) {
                    Entity entity;
                    EntityType entityType;
                    Level level = DrownedNecromancer.this.f_19853_;
                    if (!(level instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    Summoned summonedentity = DrownedNecromancer.this.getSummon();
                    if (DrownedNecromancer.this.summonVariants() && (entityType = summonedentity.getVariant(null, (Level)serverLevel, DrownedNecromancer.this.m_20183_())) != null && (entity = entityType.m_20615_((Level)serverLevel)) instanceof Summoned) {
                        Summoned summoned;
                        summonedentity = summoned = (Summoned)entity;
                    }
                    BlockPos blockPos = BlockFinder.SummonRadius(DrownedNecromancer.this.m_20183_(), (Entity)summonedentity, (Level)serverLevel);
                    DrownedNecromancer owner = DrownedNecromancer.this.getTrueOwner() != null ? DrownedNecromancer.this.getTrueOwner() : DrownedNecromancer.this;
                    summonedentity.setTrueOwner((LivingEntity)owner);
                    summonedentity.m_20035_(blockPos, DrownedNecromancer.this.m_146908_(), DrownedNecromancer.this.m_146909_());
                    if (((Boolean)MobsConfig.NecromancerSummonsLife.get()).booleanValue()) {
                        summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)serverLevel));
                    }
                    summonedentity.m_21530_();
                    summonedentity.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(DrownedNecromancer.this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    this.populateDefaultEquipmentSlots((LivingEntity)summonedentity, serverLevel.f_46441_);
                    if (!serverLevel.m_7967_((Entity)summonedentity)) continue;
                    if (!DrownedNecromancer.this.m_20067_()) {
                        DrownedNecromancer.this.f_19853_.m_6263_(null, DrownedNecromancer.this.m_20185_(), DrownedNecromancer.this.m_20186_(), DrownedNecromancer.this.m_20189_(), (SoundEvent)ModSounds.DROWNED_NECROMANCER_SUMMON.get(), DrownedNecromancer.this.m_5720_(), 1.4f, 1.0f);
                    }
                    ColorUtil colorUtil = new ColorUtil(2804175);
                    ServerParticleUtil.windShockwaveParticle(serverLevel, colorUtil, 0.1f, 0.1f, 0.05f, -1, summonedentity.m_20182_());
                }
                DrownedNecromancer.this.setUndeadIdle(false);
                DrownedNecromancer.this.idleSpellCool = MathHelper.secondsToTicks(20);
            }
        }

        protected void populateDefaultEquipmentSlots(LivingEntity livingEntity, RandomSource p_217055_) {
            if (p_217055_.m_188501_() <= 0.15f) {
                int i = p_217055_.m_188503_(2) + 2;
                if (p_217055_.m_188501_() < 0.095f) {
                    ++i;
                }
                boolean flag = true;
                for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                    Item item;
                    if (equipmentslot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                    ItemStack itemstack = livingEntity.m_6844_(equipmentslot);
                    if (!flag && p_217055_.m_188501_() < 0.1f) break;
                    flag = false;
                    if (!itemstack.m_41619_() || (item = Mob.m_21412_((EquipmentSlot)equipmentslot, (int)i)) == null) continue;
                    livingEntity.m_8061_(equipmentslot, new ItemStack((ItemLike)item));
                }
            }
        }
    }
}

