/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.IceChunk;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GlacialWall
extends AbstractMonolith {
    public GlacialWall(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (this.canSpawn((Level)pLevel.m_6018_())) {
            this.m_5496_((SoundEvent)ModSounds.WALL_SPAWN.get(), 1.0f, 2.0f);
            this.m_5496_((SoundEvent)ModSounds.WALL_ERUPT.get(), 1.0f, 2.0f);
            ServerLevel serverLevel = pLevel.m_6018_();
            for (int i = 0; i < serverLevel.f_46441_.m_188503_(35) + 10; ++i) {
                ServerParticleUtil.smokeParticles((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Level)serverLevel);
            }
        }
        return pSpawnData;
    }

    @Override
    public BlockState getState() {
        return Blocks.f_50568_.m_49966_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        int particles = 5;
        int efficiency = 0;
        boolean damage = false;
        if (!this.f_19853_.f_46443_ && !this.isEmerging()) {
            LivingEntity living;
            Entity entity;
            if (ModDamageSource.physicalAttacks(pSource) && (entity = pSource.m_7640_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().m_41735_(this.getState())) {
                damage = true;
                efficiency += EnchantmentHelper.m_44926_((LivingEntity)living);
            }
            if (damage) {
                pAmount *= 2.0f + (float)efficiency / 2.0f;
                particles = 20;
            }
            if (pSource.m_269533_(DamageTypeTags.f_268745_)) {
                pAmount *= 2.0f;
            }
            if (!pSource.m_276093_(DamageTypes.f_268441_) && (entity = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)entity;
                for (int i = 0; i < particles; ++i) {
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, this.getParticles(), (Entity)this);
                }
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected SoundEvent m_7975_(DamageSource p_34154_) {
        if (p_34154_.m_276093_(DamageTypes.f_268441_)) {
            return SoundEvents.f_144200_;
        }
        return SoundEvents.f_144242_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12442_;
    }

    public void m_6667_(DamageSource cause) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerParticleUtil.blockBreakParticles(this.getParticles(), BlockPos.m_274446_((Position)this.m_20182_()), Blocks.f_50127_.m_49966_(), serverLevel);
            ServerParticleUtil.blockBreakParticles(this.getParticles(), BlockPos.m_274446_((Position)this.m_20182_()).m_7494_(), this.getState(), serverLevel);
            ServerParticleUtil.blockBreakParticles(this.getParticles(), BlockPos.m_274446_((Position)this.m_20182_()).m_7494_().m_7494_(), Blocks.f_50127_.m_49966_(), serverLevel);
        }
        this.m_5496_((SoundEvent)ModSounds.ICE_SPIKE_HIT.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.5f);
        if (cause.m_276093_(DamageTypes.f_268441_) && this.f_19853_.f_46441_.m_188501_() <= 0.15f) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19724_((ParticleOptions)ParticleTypes.f_123759_);
            areaeffectcloud.m_19712_(2.0f);
            areaeffectcloud.m_19734_(200);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            areaeffectcloud.m_19716_(new MobEffectInstance(MobEffects.f_19597_, 600));
            this.f_19853_.m_7967_((Entity)areaeffectcloud);
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (!cause.m_276093_(DamageTypes.f_268441_)) {
            super.m_6667_(cause);
        }
    }

    @Override
    public int getAgeSpeed() {
        return 5;
    }

    @Override
    public boolean m_7337_(Entity p_20303_) {
        return super.m_7337_(p_20303_) && !(p_20303_ instanceof IceChunk);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.isEmerging()) {
            if (!this.isActivate()) {
                this.setActivate(true);
            } else if (this.f_19796_.m_188501_() <= 0.25f) {
                float damage = 2.0f;
                if (this.m_9236_().m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_263828_)) {
                    damage *= 2.0f;
                }
                this.m_6469_(this.m_269291_().m_269064_(), this.f_19853_.f_46441_.m_188503_((int)damage));
            }
            if (!this.f_19853_.f_46443_ && this.f_19797_ >= MathHelper.secondsToTicks(this.getLifeSpan()) && this.f_19796_.m_188501_() <= 0.25f) {
                this.m_6667_(this.m_269291_().m_269064_());
            }
        }
    }
}

