/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.spider.SpiderServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SpiderEgg
extends Owned {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(SpiderEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_HATCHING = SynchedEntityData.m_135353_(SpiderEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;

    public SpiderEgg(EntityType<? extends Owned> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_HATCHING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag p_32304_) {
        super.m_7380_(p_32304_);
        p_32304_.m_128376_("Fuse", (short)this.maxSwell);
        p_32304_.m_128379_("hatch", this.isHatching());
    }

    @Override
    public void m_7378_(CompoundTag p_32296_) {
        super.m_7378_(p_32296_);
        if (p_32296_.m_128425_("Fuse", 99)) {
            this.maxSwell = p_32296_.m_128448_("Fuse");
        }
        if (p_32296_.m_128471_("hatch")) {
            this.hatch();
        }
    }

    @Override
    public void lifeSpanDamage() {
        this.hatch();
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int p_32284_) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)p_32284_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.SPIDER_NEST_START.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SPIDER_NEST_START.get();
    }

    public void m_6667_(DamageSource p_21014_) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 8; ++i) {
                ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50033_.m_49966_()), (Entity)this);
            }
        }
        this.m_146870_();
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    public void m_7334_(Entity entityIn) {
    }

    public void m_7601_(BlockState p_20006_, Vec3 p_20007_) {
        super.m_7601_(p_20006_, Vec3.f_82478_);
    }

    @Override
    public void m_8119_() {
        Level level;
        int i;
        super.m_8119_();
        this.oldSwell = this.swell;
        if (this.isHatching()) {
            this.setSwellDir(1);
        }
        if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
            this.m_5496_((SoundEvent)ModSounds.SPIDER_NEST_START.get(), 0.5f, 0.75f);
        }
        this.swell += i;
        if (this.swell < 0) {
            this.swell = 0;
        }
        if (this.swell >= this.maxSwell) {
            this.swell = this.maxSwell;
            this.hatchEgg();
        }
        if ((level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.f_46441_.m_188503_(10) == 0) {
                ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50033_.m_49966_()), (Entity)this);
            }
        }
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    private void hatchEgg() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SpiderServant spiderServant = (SpiderServant)((EntityType)ModEntityType.SPIDER_SERVANT.get()).m_20615_((Level)serverLevel);
            if (spiderServant != null) {
                Player player;
                LivingEntity livingEntity = this.m_269323_();
                EntityType entityType = spiderServant.getVariant(livingEntity instanceof Player ? (player = (Player)livingEntity) : null, (Level)serverLevel, this.m_20183_());
                if (entityType != null) {
                    spiderServant = (SpiderServant)entityType.m_20615_((Level)serverLevel);
                }
                if (spiderServant != null) {
                    spiderServant.m_146884_(this.m_20182_());
                    if (this.getTrueOwner() != null) {
                        spiderServant.setTrueOwner(this.getTrueOwner());
                    }
                    spiderServant.setHostile(this.isHostile());
                    spiderServant.m_21530_();
                    spiderServant.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    if (serverLevel.m_7967_((Entity)spiderServant)) {
                        this.m_216990_((SoundEvent)ModSounds.SPIDER_NEST_SPAWN.get());
                        this.m_6667_(this.m_269291_().m_269064_());
                    }
                }
            }
        }
    }

    public boolean isHatching() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_HATCHING);
    }

    public void hatch() {
        this.f_19804_.m_135381_(DATA_IS_HATCHING, (Object)true);
    }
}

