/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral.ender;

import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.neutral.ender.AbstractEnderling;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class AbstractWatchling
extends AbstractEnderling {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(AbstractWatchling.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(AbstractWatchling.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UUID SMASH_ATTACK_MODIFIER_UUID = UUID.fromString("b872b3d4-b0f4-4d1d-a0f4-80706dc0d252");
    private static final AttributeModifier SMASH_ATTACK_MODIFIER = new AttributeModifier(SMASH_ATTACK_MODIFIER_UUID, "Smash Attack Bonus", 1.65, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static String IDLE = "idle";
    public static String ATTACK = "attack";
    public static String SMASH = "smash";
    public static String TELEPORT_OUT = "teleport_out";
    public static String TELEPORT_IN = "teleport_in";
    public int attackTick;
    public AnimationState blinkAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState smashAnimationState = new AnimationState();
    public AnimationState teleportOutAnimationState = new AnimationState();
    public AnimationState teleportInAnimationState = new AnimationState();

    public AbstractWatchling(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new AttackGoal(1.2f));
        this.f_21345_.m_25352_(5, new Summoned.WanderGoal<AbstractWatchling>(this, 1.0));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.WatchlingHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.WatchlingArmor.get()).doubleValue()).m_22268_(Attributes.f_22277_, 15.0).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.WatchlingDamage.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.3);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.WatchlingHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.WatchlingArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.WatchlingDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> p_33609_) {
        if (ANIM_STATE.equals(p_33609_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimations();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 2: {
                    this.smashAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.smashAnimationState);
                    break;
                }
                case 3: {
                    this.teleportOutAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.teleportOutAnimationState);
                    break;
                }
                case 4: {
                    this.teleportInAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.teleportInAnimationState);
                }
            }
        }
        super.m_7350_(p_33609_);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, ATTACK)) {
            return 1;
        }
        if (Objects.equals(animation, SMASH)) {
            return 2;
        }
        if (Objects.equals(animation, TELEPORT_OUT)) {
            return 3;
        }
        if (Objects.equals(animation, TELEPORT_IN)) {
            return 4;
        }
        return 0;
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.smashAnimationState);
        animationStates.add(this.teleportOutAnimationState);
        animationStates.add(this.teleportInAnimationState);
        return animationStates;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void stopAllAnimations() {
        for (AnimationState animationState : this.getAnimations()) {
            animationState.m_216973_();
        }
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isMeleeAttacking() {
        return this.getFlag(1);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.setFlags(1, attacking);
        this.attackTick = 0;
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof AbstractWatchling;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.WatchlingLimit.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.WATCHLING_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.WATCHLING_HURT.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_((SoundEvent)ModSounds.WATCHLING_STEP.get(), 0.15f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WATCHLING_DEATH.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.blinkAnimationState.m_216982_(this.f_19797_);
            this.idleAnimationState.m_246184_(!this.f_267362_.m_267780_() && this.getCurrentAnimation() == 0, this.f_19797_);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.postTeleportTick <= 0) {
            if (this.getCurrentAnimation() == this.getAnimationState(TELEPORT_IN)) {
                this.setAnimationState(IDLE);
            }
        } else if (this.postTeleportTick == 13) {
            this.setAnimationState(TELEPORT_IN);
        }
        if (!this.f_19853_.f_46443_ && !this.m_21224_()) {
            this.m_21561_(this.m_5448_() != null);
            if (this.isMeleeAttacking()) {
                ++this.attackTick;
            } else {
                this.setAnimationState(IDLE);
            }
            AttributeInstance instance = this.m_21051_(Attributes.f_22281_);
            if (instance != null) {
                if (this.getCurrentAnimation() == this.getAnimationState(SMASH)) {
                    if (this.m_21051_(Attributes.f_22281_) != null) {
                        instance.m_22130_(SMASH_ATTACK_MODIFIER);
                        instance.m_22118_(SMASH_ATTACK_MODIFIER);
                    }
                } else if (instance.m_22109_(SMASH_ATTACK_MODIFIER)) {
                    instance.m_22130_(SMASH_ATTACK_MODIFIER);
                }
            }
            if (this.teleportCool <= 0 && !this.isHiding() && this.m_5448_() != null) {
                this.startHide();
            }
        }
    }

    @Override
    public int getHidingDuration() {
        return MathHelper.secondsToTicks(1);
    }

    @Override
    public void startHide() {
        ++this.preHidingTime;
        this.setAnimationState(TELEPORT_OUT);
        if (this.preHidingTime >= 10) {
            super.startHide();
            this.preHidingTime = 0;
        }
    }

    @Override
    public void teleportAfterHiding() {
        if (this.m_5448_() != null && this.teleportCool <= 0) {
            this.teleportTowards((Entity)this.m_5448_(), 8.0);
            this.teleportCool = MathHelper.secondsToTicks(12);
        }
    }

    @Override
    public void teleportIn() {
        super.teleportIn();
        this.postTeleportTick = 15;
    }

    class AttackGoal
    extends MeleeAttackGoal {
        private final double moveSpeed;
        private int delayCounter;

        public AttackGoal(double moveSpeed) {
            super((PathfinderMob)AbstractWatchling.this, moveSpeed, true);
            this.moveSpeed = moveSpeed;
        }

        public boolean m_8036_() {
            return AbstractWatchling.this.m_5448_() != null && AbstractWatchling.this.m_5448_().m_6084_() && !AbstractWatchling.this.isHiding() && AbstractWatchling.this.postTeleportTick <= 0;
        }

        public boolean m_8045_() {
            return super.m_8045_() && !AbstractWatchling.this.isHiding() && AbstractWatchling.this.postTeleportTick <= 0;
        }

        public void m_8056_() {
            this.delayCounter = 0;
        }

        public void m_8041_() {
            AbstractWatchling.this.setMeleeAttacking(false);
            AbstractWatchling.this.attackTick = 0;
        }

        public void m_8037_() {
            LivingEntity livingentity = AbstractWatchling.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            AbstractWatchling.this.m_21563_().m_24960_((Entity)livingentity, (float)AbstractWatchling.this.m_8085_(), (float)AbstractWatchling.this.m_8132_());
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                AbstractWatchling.this.m_21573_().m_5624_((Entity)livingentity, this.moveSpeed);
            }
            this.m_6739_(livingentity, AbstractWatchling.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_()));
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            boolean smash = AbstractWatchling.this.f_19796_.m_188499_();
            if (!AbstractWatchling.this.isMeleeAttacking() && distToEnemySqr <= d0) {
                AbstractWatchling.this.setMeleeAttacking(true);
                if (smash) {
                    AbstractWatchling.this.setAnimationState(SMASH);
                } else {
                    AbstractWatchling.this.setAnimationState(ATTACK);
                }
            }
            if (AbstractWatchling.this.isMeleeAttacking()) {
                float seconds;
                float f = seconds = AbstractWatchling.this.getCurrentAnimation() == AbstractWatchling.this.getAnimationState(ATTACK) ? 1.7f : 1.9f;
                if (AbstractWatchling.this.attackTick < MathHelper.secondsToTicks(seconds)) {
                    MobUtil.instaLook((Mob)AbstractWatchling.this, (Entity)enemy);
                    if (AbstractWatchling.this.getCurrentAnimation() == AbstractWatchling.this.getAnimationState(ATTACK)) {
                        if (AbstractWatchling.this.attackTick == 12) {
                            AbstractWatchling.this.m_5496_((SoundEvent)ModSounds.WATCHLING_ATTACK.get(), AbstractWatchling.this.m_6121_(), AbstractWatchling.this.m_6100_());
                            this.massiveSweep((LivingEntity)AbstractWatchling.this, 4.0, 30.0);
                        }
                    } else if (AbstractWatchling.this.getCurrentAnimation() == AbstractWatchling.this.getAnimationState(SMASH) && AbstractWatchling.this.attackTick == 18) {
                        AbstractWatchling.this.m_5496_((SoundEvent)ModSounds.WATCHLING_SMASH.get(), AbstractWatchling.this.m_6121_(), AbstractWatchling.this.m_6100_());
                        if (distToEnemySqr <= d0) {
                            AbstractWatchling.this.m_7327_((Entity)enemy);
                        }
                    }
                } else {
                    AbstractWatchling.this.setMeleeAttacking(false);
                }
            }
        }

        public void massiveSweep(LivingEntity source, double range, double arc) {
            List<LivingEntity> hits = MobUtil.getAttackableLivingEntitiesNearby(source, range, 1.0, range, range);
            for (LivingEntity target : hits) {
                float targetAngle = (float)((Math.atan2(target.m_20189_() - source.m_20189_(), target.m_20185_() - source.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float attackAngle = source.f_20883_ % 360.0f;
                if (targetAngle < 0.0f) {
                    targetAngle += 360.0f;
                }
                if (attackAngle < 0.0f) {
                    attackAngle += 360.0f;
                }
                float relativeAngle = targetAngle - attackAngle;
                float hitDistance = (float)Math.sqrt((target.m_20189_() - source.m_20189_()) * (target.m_20189_() - source.m_20189_()) + (target.m_20185_() - source.m_20185_()) * (target.m_20185_() - source.m_20185_())) - target.m_20205_() / 2.0f;
                if (!((double)hitDistance <= range && (double)relativeAngle <= arc / 2.0 && (double)relativeAngle >= -arc / 2.0 || (double)relativeAngle >= 360.0 - arc / 2.0) && !((double)relativeAngle <= -360.0 + arc / 2.0)) continue;
                AbstractWatchling.this.m_7327_((Entity)target);
            }
        }

        protected double m_6639_(LivingEntity livingEntity) {
            return this.f_25540_.m_20205_() * 4.0f * this.f_25540_.m_20205_() * 4.0f + livingEntity.m_20205_();
        }
    }
}

