/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.client.particles.GatherTrailParticle;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.SpellHurtingProjectile;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SpellExplosion;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class BouncyBubble
extends SpellHurtingProjectile {
    private static final EntityDataAccessor<Integer> BOUNCE_TIMES = SynchedEntityData.m_135353_(BouncyBubble.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(BouncyBubble.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public float damage = ((Double)SpellConfig.BouncyBubbleDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();

    public BouncyBubble(EntityType<? extends AbstractHurtingProjectile> p_36833_, Level p_36834_) {
        super(p_36833_, p_36834_);
    }

    public BouncyBubble(double pX, double pY, double pZ, double pXPower, double pYPower, double pZPower, Level pLevel) {
        super((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ModEntityType.BOUNCY_BUBBLE.get()), pX, pY, pZ, pXPower, pYPower, pZPower, pLevel);
    }

    public BouncyBubble(LivingEntity pShooter, double pXPower, double pYPower, double pZPower, Level pLevel) {
        super((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ModEntityType.BOUNCY_BUBBLE.get()), pShooter, pXPower, pYPower, pZPower, pLevel);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOUNCE_TIMES, (Object)0);
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("BounceTimes", this.getBounceTimes());
        compound.m_128350_("Size", this.getSize());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBounceTimes(compound.m_128451_("BounceTimes"));
        this.setSize(compound.m_128457_("Size"));
    }

    public void m_7350_(EntityDataAccessor<?> p_33134_) {
        if (SIZE.equals(p_33134_)) {
            this.m_6210_();
        }
        super.m_7350_(p_33134_);
    }

    public EntityDimensions m_6972_(Pose p_33113_) {
        float i = this.getSize();
        EntityDimensions entitydimensions = super.m_6972_(p_33113_);
        return entitydimensions.m_20388_(i);
    }

    public int getBounceTimes() {
        return (Integer)this.f_19804_.m_135370_(BOUNCE_TIMES);
    }

    public void setBounceTimes(int bounce) {
        this.f_19804_.m_135381_(BOUNCE_TIMES, (Object)bounce);
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public void setSize(float size) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(size));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_46749_(this.m_20183_())) {
            this.m_146870_();
        }
        if (this.f_19797_ >= 100) {
            this.explode();
        }
    }

    @Override
    public void trailParticle() {
        for (int j = 0; j < 3 + this.f_19796_.m_188503_(2); ++j) {
            this.f_19853_.m_7106_((ParticleOptions)(this.m_20072_() ? ParticleTypes.f_123774_ : ParticleTypes.f_123804_), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, (double)-0.1f, 0.0);
        }
    }

    @Override
    public void travel() {
        this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
        ProjectileUtil.m_37284_((Entity)this, (float)1.0f);
        if (!this.m_20068_()) {
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_, vec3.f_82480_ - (double)this.getGravity(), vec3.f_82481_);
        }
    }

    protected void m_6532_(HitResult result) {
        HitResult.Type raytraceresult$type = result.m_6662_();
        Vec3 vec3 = this.m_20184_();
        double motionX = vec3.m_7096_();
        double motionY = vec3.m_7098_();
        double motionZ = vec3.m_7094_();
        if (raytraceresult$type == HitResult.Type.BLOCK) {
            BlockHitResult hitResult = (BlockHitResult)result;
            BlockState blockstate = this.f_19853_.m_8055_(hitResult.m_82425_());
            if (!blockstate.m_60812_((BlockGetter)this.f_19853_, hitResult.m_82425_()).m_83281_()) {
                Direction face = hitResult.m_82434_();
                blockstate.m_60669_(this.f_19853_, blockstate, hitResult, (Projectile)this);
                if (face.m_122434_() == Direction.Axis.X) {
                    motionX = -motionX;
                } else if (face.m_122434_() == Direction.Axis.Z) {
                    motionZ = -motionZ;
                } else if (face.m_122434_().m_122478_()) {
                    motionY = -motionY;
                }
                Vec3 vec31 = new Vec3(motionX, motionY, motionZ);
                this.m_20256_(vec31);
                if (this.getBounceTimes() >= 6) {
                    this.explode();
                } else {
                    this.m_5496_(SoundEvents.f_11917_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    this.setBounceTimes(this.getBounceTimes() + 1);
                }
            }
        } else if (raytraceresult$type == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).m_82443_();
            if (!this.f_19853_.f_46443_ && this.m_5603_(entity)) {
                if (this.getBounceTimes() >= 6) {
                    this.explode();
                } else if (entity.m_6469_(ModDamageSource.indirectDrench((Entity)this, (Entity)(this.m_19749_() == null ? this : this.m_19749_())), this.damage + this.getExtraDamage())) {
                    this.setBounceTimes(this.getBounceTimes() + 1);
                }
            }
        }
    }

    public void explode() {
        if (!this.f_19853_.f_46443_) {
            Entity owner = this.m_19749_();
            float radius = 1.0f + this.getSize();
            int radius2 = Mth.m_14143_((float)radius);
            new SpellExplosion(this.f_19853_, (Entity)this, ModDamageSource.indirectDrench((Entity)this, (Entity)(owner == null ? this : owner)), this.m_20185_(), this.m_20186_(), this.m_20189_(), radius, this.damage + this.getExtraDamage());
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                int i;
                ServerLevel serverLevel = (ServerLevel)level;
                for (i = -radius2; i < radius2; ++i) {
                    for (int j = -radius2; j < radius2; ++j) {
                        for (int k = -radius2; k < radius2; ++k) {
                            Vec3 vec3 = this.m_20182_().m_82520_((double)i, (double)j, (double)k);
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, vec3.m_7096_(), vec3.m_7098_() + 0.5, vec3.m_7094_(), 0, 0.0, 0.04, 0.0, 0.5);
                        }
                    }
                }
                for (i = 0; i < 8; ++i) {
                    ColorUtil colorUtil = new ColorUtil(ChatFormatting.BLUE);
                    if (this.m_20069_()) {
                        colorUtil = new ColorUtil(ChatFormatting.AQUA);
                    }
                    Vec3 vector3d1 = this.m_20182_().m_272010_(serverLevel.m_213780_(), radius * 2.0f);
                    serverLevel.m_8767_((ParticleOptions)new GatherTrailParticle.Option(colorUtil, vector3d1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.5);
                }
            }
            this.m_5496_(SoundEvents.f_11773_, 64.0f, 1.0f);
            this.m_5496_(SoundEvents.f_11917_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        }
        this.m_146870_();
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!ModDamageSource.waterAttacks(source) && !(source.m_7640_() instanceof BouncyBubble)) {
            this.explode();
        }
        return true;
    }

    protected boolean m_5931_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

