/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.boss.Apostle;
import com.Polarice3.Goety.common.entities.projectiles.AbstractCyclone;
import com.Polarice3.Goety.common.entities.projectiles.SpellHurtingProjectile;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;

public class FireTornado
extends AbstractCyclone {
    public FireTornado(EntityType<? extends AbstractCyclone> p_i50173_1_, Level p_i50173_2_) {
        super((EntityType<? extends SpellHurtingProjectile>)p_i50173_1_, p_i50173_2_);
        this.setSize(2.0f);
    }

    public FireTornado(Level level, LivingEntity shooter, double xPower, double yPower, double zPower) {
        super((EntityType<? extends SpellHurtingProjectile>)((EntityType)ModEntityType.FIRE_TORNADO.get()), shooter, xPower, yPower, zPower, level);
        this.setSize(2.0f);
    }

    public FireTornado(Level p_i1795_1_, double p_i1795_2_, double p_i1795_4_, double p_i1795_6_, double p_i1795_8_, double p_i1795_10_, double p_i1795_12_) {
        super((EntityType<? extends SpellHurtingProjectile>)((EntityType)ModEntityType.FIRE_TORNADO.get()), p_i1795_2_, p_i1795_4_, p_i1795_6_, p_i1795_8_, p_i1795_10_, p_i1795_12_, p_i1795_1_);
        this.setSize(2.0f);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_146808_) {
            this.lifespan += 10;
        }
        if (this.f_19797_ % 20 == 0) {
            this.m_5496_((SoundEvent)ModSounds.FIRE_TORNADO_AMBIENT.get(), 1.0f, 0.5f);
        }
        if (this.getTrueOwner() != null && this.getTrueOwner().m_6095_().m_204039_(Tags.EntityTypes.BOSSES) && this.getTrueOwner().m_21224_()) {
            this.m_146870_();
        }
    }

    @Override
    public void fakeRemove(double x, double y, double z) {
        FireTornado cyclone = new FireTornado(this.f_19853_, this.getTrueOwner(), x, y, z);
        cyclone.setOwner(this.getTrueOwner());
        cyclone.setTarget(this.getTarget());
        cyclone.setLifespan(this.getLifespan());
        cyclone.setTotalLife(this.getTotalLife());
        cyclone.setSpun(this.getSpun());
        cyclone.setSize(this.getSize());
        cyclone.setDamage(this.getDamage());
        cyclone.setExtraDamage(this.getExtraDamage());
        cyclone.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.f_19853_.m_7967_((Entity)cyclone);
        this.remove();
    }

    @Override
    public void remove() {
        if (!this.f_19853_.f_46443_ && this.getLifespan() >= this.getTotalLife()) {
            ServerLevel serverWorld = (ServerLevel)this.f_19853_;
            for (int k = 0; k < 200; ++k) {
                float f2 = this.f_19796_.m_188501_() * 4.0f;
                float f1 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                double d1 = Mth.m_14089_((float)f1) * f2;
                double d2 = 0.01 + this.f_19796_.m_188500_() * 0.5;
                double d3 = Mth.m_14031_((float)f1) * f2;
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + d1 * 0.1, this.m_20186_() + 0.3, this.m_20189_() + d3 * 0.1, 0, d1, d2, d3, 0.5);
            }
            LivingEntity livingEntity = this.getTrueOwner();
            if (livingEntity instanceof Apostle) {
                Apostle apostle = (Apostle)livingEntity;
                apostle.setTornadoCoolDown(apostle.getTornadoCoolDown() + MathHelper.secondsToTicks(45));
            }
        }
        this.m_146870_();
    }

    @Override
    public void hurtMobs(LivingEntity living) {
        if (this.getTrueOwner() != null) {
            if (CuriosFinder.hasUnholySet(this.getTrueOwner())) {
                if (living.m_6469_(ModDamageSource.hellfire((Entity)this, (Entity)this.getTrueOwner()), ((Double)AttributesConfig.ApostleMagicDamage.get()).floatValue() / 1.5f)) {
                    living.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BURN_HEX.get(), 1200));
                }
            } else {
                living.m_6469_(ModDamageSource.magicFireBreath((Entity)this, (Entity)this.getTrueOwner()), 4.0f);
            }
        } else if (!living.m_5825_()) {
            living.m_6469_(this.m_269291_().m_269387_(), 4.0f);
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            if (player.m_21254_()) {
                player.m_36384_(true);
            }
        } else {
            MobUtil.disableShield((Entity)living);
        }
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123744_;
    }
}

