/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public abstract class GroundProjectile
extends Entity {
    public int warmupDelayTicks;
    public boolean sentTrapEvent;
    public boolean playSound;
    public int lifeTicks = 200;
    public int animationTicks = 22;
    public LivingEntity owner;
    public UUID ownerUUID;

    public GroundProjectile(EntityType<? extends Entity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public void setOwner(@Nullable LivingEntity p_190549_1_) {
        this.owner = p_190549_1_;
        this.ownerUUID = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128441_("LifeTicks")) {
            this.lifeTicks = pCompound.m_128451_("LifeTicks");
        }
        this.warmupDelayTicks = pCompound.m_128451_("Warmup");
        this.playSound = pCompound.m_128471_("PlaySound");
        if (pCompound.m_128441_("sentEvent")) {
            this.sentTrapEvent = pCompound.m_128471_("sentEvent");
        }
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("LifeTicks", this.lifeTicks);
        pCompound.m_128405_("Warmup", this.warmupDelayTicks);
        pCompound.m_128379_("PlaySound", this.playSound);
        pCompound.m_128379_("sentEvent", this.sentTrapEvent);
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.sentTrapEvent) {
            this.f_19853_.m_7605_((Entity)this, (byte)4);
        }
    }

    public float getAnimationProgress(float pPartialTicks) {
        if (!this.sentTrapEvent) {
            return 0.0f;
        }
        if (this.lifeTicks <= 12) {
            int i = this.lifeTicks - 2;
            return i <= 0 ? 1.0f : 1.0f - ((float)i - pPartialTicks) / 20.0f;
        }
        return 1.0f - (float)this.animationTicks / 20.0f;
    }

    public void m_7822_(byte pId) {
        super.m_7822_(pId);
        if (pId == 4) {
            this.sentTrapEvent = true;
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

