/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.events;

import com.Polarice3.Goety.common.entities.ai.HuntDownPlayerGoal;
import com.Polarice3.Goety.common.entities.hostile.illagers.HuntingIllagerEntity;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.listeners.IllagerAssaultListener;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.SEHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class IllagerSpawner {
    private int nextTick;

    public int tick(ServerLevel pLevel) {
        if (!((Boolean)MobsConfig.IllagerAssault.get()).booleanValue()) {
            return 0;
        }
        RandomSource random = pLevel.f_46441_;
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick += ((Integer)MobsConfig.IllagerAssaultSpawnFreq.get()).intValue();
        if (random.m_188503_(((Integer)MobsConfig.IllagerAssaultSpawnChance.get()).intValue()) != 0) {
            return 0;
        }
        int j = pLevel.m_6907_().size();
        if (j < 1) {
            return 0;
        }
        ServerPlayer pPlayer = (ServerPlayer)pLevel.m_6907_().get(random.m_188503_(j));
        int soulEnergy = Mth.m_14045_((int)SEHelper.getSoulAmountInt((Player)pPlayer), (int)0, (int)((Integer)MobsConfig.IllagerAssaultSELimit.get()));
        if (pPlayer.m_5833_() || pPlayer.m_7500_()) {
            return 0;
        }
        if (SEHelper.getRestPeriod((Player)pPlayer) > 0) {
            return 0;
        }
        if (pLevel.m_8736_(pPlayer.m_20183_(), 2) && soulEnergy < (Integer)MobsConfig.IllagerAssaultSELimit.get()) {
            return 0;
        }
        if (soulEnergy >= (Integer)MobsConfig.IllagerAssaultSEThreshold.get()) {
            int k = (24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
            int l = (24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
            BlockPos.MutableBlockPos blockpos$mutable = pPlayer.m_20183_().m_122032_().m_122184_(k, 0, l);
            if (!pLevel.m_46749_((BlockPos)blockpos$mutable)) {
                return 0;
            }
            if (!pLevel.m_6042_().m_63963_()) {
                return 0;
            }
            Holder holder = pLevel.m_204166_((BlockPos)blockpos$mutable);
            if (holder.m_203656_(BiomeTags.f_215806_)) {
                return 0;
            }
            if (pPlayer.m_20183_().m_123342_() < pLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)blockpos$mutable).m_123342_() - 32 && !pLevel.m_45527_(pPlayer.m_20183_())) {
                return 0;
            }
            if (BlockFinder.findIllagerWard(pLevel, (Player)pPlayer, soulEnergy)) {
                return 0;
            }
            if (!pLevel.m_6443_(LivingEntity.class, pPlayer.m_20191_().m_82400_(64.0), entity -> entity.m_6095_().m_204039_(Tags.EntityTypes.BOSSES) || entity.m_6095_().m_204039_(ModTags.EntityTypes.MINI_BOSSES)).isEmpty()) {
                return 0;
            }
            if (!IllagerAssaultListener.ILLAGER_LIST.isEmpty()) {
                int i1 = 0;
                block0: for (IllagerDataType data : IllagerAssaultListener.ILLAGER_LIST.values()) {
                    EntityType entityType;
                    if (data == null || (entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(data.raider)) == null || entityType == EntityType.f_20510_ || !((float)soulEnergy >= (float)((Integer)MobsConfig.IllagerAssaultSEThreshold.get()).intValue() * data.thresholdTimes) || !(pLevel.f_46441_.m_188501_() <= data.chance)) continue;
                    ++i1;
                    int cost = (int)((float)soulEnergy / data.thresholdTimes);
                    int total = Mth.m_14045_((int)(cost / (Integer)MobsConfig.IllagerAssaultSEThreshold.get()), (int)1, (int)data.maxExtraAmount) + 1;
                    int randomTotal = pLevel.f_46441_.m_188503_(total) + data.initExtraAmount;
                    for (int k1 = 0; k1 < randomTotal; ++k1) {
                        blockpos$mutable.m_142448_(pLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)blockpos$mutable).m_123342_());
                        if (k1 == 0) {
                            if (!this.spawnRaider(data, entityType, pLevel, (BlockPos)blockpos$mutable, random, soulEnergy, pPlayer)) {
                                continue block0;
                            }
                        } else {
                            this.spawnRaider(data, entityType, pLevel, (BlockPos)blockpos$mutable, random, soulEnergy, pPlayer);
                        }
                        blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + random.m_188503_(5) - random.m_188503_(5));
                        blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + random.m_188503_(5) - random.m_188503_(5));
                    }
                }
                if (soulEnergy >= (Integer)MobsConfig.IllagerAssaultSELimit.get() && ((Boolean)MobsConfig.SoulEnergyBadOmen.get()).booleanValue() && !pPlayer.m_21023_(MobEffects.f_19594_)) {
                    pPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19594_, 120000, 0, false, false));
                }
                if (CuriosFinder.hasCurio((LivingEntity)pPlayer, (Item)ModItems.ALARMING_CHARM.get())) {
                    ModNetwork.sendToClient(pPlayer, new SPlayPlayerSoundPacket((SoundEvent)SoundEvents.f_12355_.get(), 64.0f, 1.0f));
                }
                return i1;
            }
            return 0;
        }
        return 0;
    }

    public boolean spawnRaider(IllagerDataType dataType, EntityType<?> entityType, ServerLevel worldIn, BlockPos pos, RandomSource random, int soulAmount, ServerPlayer player) {
        Entity entity1;
        EntityType entityType1;
        BlockState blockstate = worldIn.m_8055_(pos);
        if (entityType == null) {
            return false;
        }
        Entity entity = entityType.m_20615_((Level)worldIn);
        if (!(entity instanceof PathfinderMob)) {
            return false;
        }
        PathfinderMob illager = (PathfinderMob)entity;
        if (!NaturalSpawner.m_47056_((BlockGetter)worldIn, (BlockPos)pos, (BlockState)blockstate, (FluidState)blockstate.m_60819_(), entityType)) {
            return false;
        }
        if (!PatrollingMonster.m_219025_((EntityType)EntityType.f_20518_, (LevelAccessor)worldIn, (MobSpawnType)MobSpawnType.PATROL, (BlockPos)pos, (RandomSource)random)) {
            return false;
        }
        illager.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        ForgeEventFactory.onFinalizeSpawn((Mob)illager, (ServerLevelAccessor)worldIn, (DifficultyInstance)worldIn.m_6436_(pos), (MobSpawnType)MobSpawnType.PATROL, null, null);
        illager.f_21345_.m_25352_(0, new HuntDownPlayerGoal<PathfinderMob>(illager));
        if (illager instanceof HuntingIllagerEntity) {
            HuntingIllagerEntity huntingIllager = (HuntingIllagerEntity)illager;
            float rawPercent = (float)SEHelper.getSoulAmountInt((Player)player) / (float)((Integer)MainConfig.MaxArcaSouls.get()).intValue();
            int sePercent = (int)(rawPercent * 100.0f);
            huntingIllager.upgradeAssault(sePercent);
            if (random.m_188503_(4) == 0) {
                huntingIllager.setRider(true);
            }
        }
        if (EntitySelector.f_20406_.test(player)) {
            illager.m_6710_((LivingEntity)player);
        }
        this.upgradeIllagers((LivingEntity)illager, soulAmount);
        if (dataType.riding != null && worldIn.f_46441_.m_188501_() <= dataType.rideChance && (entityType1 = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(dataType.riding)) != null && (entity1 = entityType1.m_20615_((Level)worldIn)) instanceof PathfinderMob) {
            PathfinderMob mount = (PathfinderMob)entity1;
            mount.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            ForgeEventFactory.onFinalizeSpawn((Mob)mount, (ServerLevelAccessor)worldIn, (DifficultyInstance)worldIn.m_6436_(pos), (MobSpawnType)MobSpawnType.PATROL, null, null);
            illager.m_20329_((Entity)mount);
            if (CuriosFinder.hasCurio((LivingEntity)player, (Item)ModItems.ALARMING_CHARM.get())) {
                mount.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 60));
            }
            worldIn.m_47205_((Entity)mount);
        }
        if (CuriosFinder.hasCurio((LivingEntity)player, (Item)ModItems.ALARMING_CHARM.get())) {
            illager.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 60));
        }
        worldIn.m_47205_((Entity)illager);
        return true;
    }

    public void upgradeIllagers(LivingEntity raider, int soulAmount) {
        Level world = raider.f_19853_;
        if (soulAmount >= (Integer)MobsConfig.IllagerAssaultSEThreshold.get() * 5) {
            HashMap map;
            ItemStack itemstack = raider.m_21205_().m_41777_();
            if (itemstack.m_41720_() instanceof CrossbowItem) {
                map = Maps.newHashMap();
                if (world.m_46791_() == Difficulty.HARD) {
                    map.put(Enchantments.f_44960_, 2);
                } else {
                    map.put(Enchantments.f_44960_, 1);
                }
                map.put(Enchantments.f_44959_, 1);
                EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
                raider.m_8061_(EquipmentSlot.MAINHAND, itemstack);
            }
            if (itemstack.m_41720_() instanceof AxeItem) {
                map = Maps.newHashMap();
                int i = 1;
                if (world.m_46791_() == Difficulty.HARD) {
                    i = 2;
                }
                map.put(Enchantments.f_44977_, i);
                EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
                raider.m_8061_(EquipmentSlot.MAINHAND, itemstack);
            }
            if (itemstack.m_41720_() instanceof SwordItem) {
                SwordItem swordItem;
                Item i;
                if (world.f_46441_.m_188501_() <= 0.25f && (!itemstack.m_150930_(Items.f_42388_) || (i = itemstack.m_41720_()) instanceof SwordItem && (swordItem = (SwordItem)i).m_43299_() < 7.0f)) {
                    itemstack = new ItemStack((ItemLike)Items.f_42388_);
                }
                map = Maps.newHashMap();
                int i2 = 2;
                if (world.m_46791_() == Difficulty.HARD) {
                    i2 = 4;
                }
                map.put(Enchantments.f_44977_, i2);
                map.put(Enchantments.f_44981_, 2);
                EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
                raider.m_8061_(EquipmentSlot.MAINHAND, itemstack);
            }
        }
    }

    public void forceSpawn(ServerLevel pLevel, ServerPlayer pPlayer, CommandSourceStack pSource) {
        RandomSource random = pLevel.f_46441_;
        int soulEnergy = SEHelper.getSoulAmountInt((Player)pPlayer);
        if (soulEnergy > (Integer)MobsConfig.IllagerAssaultSEThreshold.get()) {
            int k = (24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
            int l = (24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
            BlockPos.MutableBlockPos blockpos$mutable = pPlayer.m_20183_().m_122032_().m_122184_(k, 0, l);
            if (pLevel.m_46749_((BlockPos)blockpos$mutable)) {
                if (pPlayer.m_20183_().m_123342_() < pLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)blockpos$mutable).m_123342_() - 32 && !pLevel.m_45527_(pPlayer.m_20183_())) {
                    ModNetwork.sendToClient(pPlayer, new SPlayPlayerSoundPacket(SoundEvents.f_11937_, 1.0f, 1.0f));
                    pSource.m_81352_((Component)Component.m_237110_((String)"commands.goety.illager.spawn.failure_location", (Object[])new Object[]{pPlayer.m_5446_()}));
                } else if (BlockFinder.findIllagerWard(pLevel, (Player)pPlayer, soulEnergy)) {
                    ModNetwork.sendToClient(pPlayer, new SPlayPlayerSoundPacket(SoundEvents.f_11937_, 1.0f, 1.0f));
                    pSource.m_81352_((Component)Component.m_237110_((String)"commands.goety.illager.spawn.failure_location", (Object[])new Object[]{pPlayer.m_5446_()}));
                } else if (!IllagerAssaultListener.ILLAGER_LIST.isEmpty()) {
                    block0: for (IllagerDataType data : IllagerAssaultListener.ILLAGER_LIST.values()) {
                        EntityType entityType;
                        if (data == null || (entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(data.raider)) == null || entityType == EntityType.f_20510_ || !((float)soulEnergy >= (float)((Integer)MobsConfig.IllagerAssaultSEThreshold.get()).intValue() * data.thresholdTimes) || !(pLevel.f_46441_.m_188501_() <= data.chance)) continue;
                        int cost = (int)((float)soulEnergy / data.thresholdTimes);
                        int total = Mth.m_14045_((int)(cost / (Integer)MobsConfig.IllagerAssaultSEThreshold.get()), (int)1, (int)data.maxExtraAmount) + 1;
                        int randomTotal = pLevel.f_46441_.m_188503_(total) + data.initExtraAmount;
                        for (int k1 = 0; k1 < randomTotal; ++k1) {
                            blockpos$mutable.m_142448_(pLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)blockpos$mutable).m_123342_());
                            if (k1 == 0) {
                                if (!this.spawnRaider(data, entityType, pLevel, (BlockPos)blockpos$mutable, random, soulEnergy, pPlayer)) {
                                    continue block0;
                                }
                            } else {
                                this.spawnRaider(data, entityType, pLevel, (BlockPos)blockpos$mutable, random, soulEnergy, pPlayer);
                            }
                            blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + random.m_188503_(5) - random.m_188503_(5));
                            blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + random.m_188503_(5) - random.m_188503_(5));
                        }
                    }
                    if (CuriosFinder.hasCurio((LivingEntity)pPlayer, (Item)ModItems.ALARMING_CHARM.get())) {
                        ModNetwork.sendToClient(pPlayer, new SPlayPlayerSoundPacket((SoundEvent)SoundEvents.f_12355_.get(), 64.0f, 1.0f));
                    }
                    this.nextTick += ((Integer)MobsConfig.IllagerAssaultSpawnFreq.get()).intValue();
                    pSource.m_288197_(() -> Component.m_237110_((String)"commands.goety.illager.spawn.success", (Object[])new Object[]{pPlayer.m_5446_()}), false);
                } else {
                    ModNetwork.sendToClient(pPlayer, new SPlayPlayerSoundPacket(SoundEvents.f_11937_, 1.0f, 1.0f));
                    pSource.m_81352_((Component)Component.m_237115_((String)"commands.goety.illager.spawn.empty"));
                }
            } else {
                ModNetwork.sendToClient(pPlayer, new SPlayPlayerSoundPacket(SoundEvents.f_11937_, 1.0f, 1.0f));
                pSource.m_81352_((Component)Component.m_237110_((String)"commands.goety.illager.spawn.failure_location", (Object[])new Object[]{pPlayer.m_5446_()}));
            }
        }
    }

    public static class IllagerDataType {
        public ResourceLocation raider;
        public float thresholdTimes;
        public int maxExtraAmount;
        public int initExtraAmount;
        public float chance;
        public ResourceLocation riding;
        public float rideChance;

        public IllagerDataType(ResourceLocation raider, float thresholdTimes, int maxExtraAmount, int initExtraAmount, float chance, ResourceLocation riding, float rideChance) {
            this.raider = raider;
            this.thresholdTimes = thresholdTimes;
            this.maxExtraAmount = maxExtraAmount;
            this.initExtraAmount = initExtraAmount;
            this.chance = chance;
            this.riding = riding;
            this.rideChance = rideChance;
        }
    }
}

