/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.events;

import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.client.particles.FollowFireParticle;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.effects.brew.BrewEffectInstance;
import com.Polarice3.Goety.common.entities.util.DragonBreathCloud;
import com.Polarice3.Goety.common.events.spell.CastMagicEvent;
import com.Polarice3.Goety.common.events.spell.CastingMagicEvent;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.spells.void_spells.EndWalkSpell;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayEffectLoopSoundPacket;
import com.Polarice3.Goety.common.network.server.SPlayEntitySoundPacket;
import com.Polarice3.Goety.common.network.server.SPlayWorldSoundPacket;
import com.Polarice3.Goety.config.ItemConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BrewUtils;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.ConstantPaths;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MiscCapHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="goety", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PotionEvents {
    @SubscribeEvent
    public static void LivingEffects(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity != null) {
            MobEffectInstance mobEffectInstance;
            MobEffectInstance mobEffectInstance2;
            MobEffectInstance mobEffectInstance3;
            int j;
            int i;
            Level level = livingEntity.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (livingEntity.m_21023_((MobEffect)GoetyEffects.ILLAGUE.get())) {
                    EffectsUtil.Illague(serverLevel, livingEntity);
                }
                if (livingEntity.m_21023_((MobEffect)GoetyEffects.VOID_TOUCHED.get()) && livingEntity.f_19797_ % 10 == 0) {
                    ColorUtil colorUtil = new ColorUtil(8323189);
                    serverLevel.m_8767_((ParticleOptions)new FollowFireParticle.Option(livingEntity.m_19879_()), livingEntity.m_20185_(), livingEntity.m_20186_() + (double)(livingEntity.m_20206_() / 2.0f), livingEntity.m_20189_(), 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 1.0);
                }
            }
            AttributeInstance armor = livingEntity.m_21051_(Attributes.f_22284_);
            AttributeModifier soulArmorBuff = new AttributeModifier(UUID.fromString("3e4b414b-466c-4b90-8a92-a878e2542bb8"), "Increase Armor", 2.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
            if (armor != null) {
                if (livingEntity.m_21023_((MobEffect)GoetyEffects.SOUL_ARMOR.get())) {
                    if (ItemHelper.noArmor(livingEntity)) {
                        if (!armor.m_22109_(soulArmorBuff)) {
                            armor.m_22125_(soulArmorBuff);
                        }
                    } else if (armor.m_22109_(soulArmorBuff)) {
                        armor.m_22130_(soulArmorBuff);
                    }
                } else if (armor.m_22109_(soulArmorBuff)) {
                    armor.m_22130_(soulArmorBuff);
                }
            }
            if (livingEntity.m_19880_().contains(ConstantPaths.gassed()) && livingEntity.f_19797_ % 20 == 0) {
                livingEntity.m_19880_().remove(ConstantPaths.gassed());
            }
            if (livingEntity.m_21023_((MobEffect)GoetyEffects.BURN_HEX.get()) && livingEntity.m_21023_(MobEffects.f_19607_)) {
                livingEntity.m_6234_(MobEffects.f_19607_);
            }
            if (livingEntity.m_21023_((MobEffect)GoetyEffects.CLIMBING.get())) {
                MobUtil.ClimbAnyWall(livingEntity);
            }
            if (livingEntity instanceof Bee) {
                Bee bee = (Bee)livingEntity;
                if (!bee.f_19853_.f_46443_ && bee.m_19880_().contains(ConstantPaths.conjuredBee()) && (bee.m_5448_() == null && bee.m_6120_() == null || bee.m_27857_()) && bee.f_19797_ % MathHelper.secondsToTicks(10) == 0) {
                    bee.m_21373_();
                    bee.m_146870_();
                }
            }
            if (livingEntity instanceof Bat) {
                Bat bat = (Bat)livingEntity;
                if (!bat.f_19853_.f_46443_ && bat.m_19880_().contains(ConstantPaths.conjuredBat()) && bat.f_19797_ % MathHelper.secondsToTicks(20) == 0) {
                    bat.m_21373_();
                    bat.m_146870_();
                }
            }
            if (livingEntity.m_21023_((MobEffect)GoetyEffects.FREEZING.get())) {
                if (!livingEntity.f_19853_.f_46443_) {
                    livingEntity.m_146924_(true);
                    if (livingEntity.m_142079_()) {
                        int h = Objects.requireNonNull(livingEntity.m_21124_((MobEffect)GoetyEffects.FREEZING.get())).m_19564_() + 1;
                        MiscCapHelper.setFreezing(livingEntity, h);
                        Level level2 = livingEntity.f_19853_;
                        if (level2 instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level2;
                            if (serverLevel.f_46441_.m_188501_() <= 0.25f) {
                                for (int h1 = 0; h1 < h; ++h1) {
                                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ParticleTypes.f_175821_, (Entity)livingEntity);
                                }
                            }
                        }
                        i = livingEntity.m_146888_();
                        j = h * 4;
                        livingEntity.m_146917_(Math.min(livingEntity.m_146891_() + 5, i + j));
                    }
                }
            } else if (!livingEntity.f_19853_.f_46443_ && MiscCapHelper.isFreezing(livingEntity)) {
                MiscCapHelper.setFreezing(livingEntity, 0);
            }
            if (livingEntity instanceof Player && livingEntity.m_21023_((MobEffect)GoetyEffects.SENSE_LOSS.get()) && (mobEffectInstance3 = livingEntity.m_21124_((MobEffect)GoetyEffects.SENSE_LOSS.get())) != null && livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, mobEffectInstance3.m_19557_(), mobEffectInstance3.m_19564_(), mobEffectInstance3.m_19571_(), mobEffectInstance3.m_19572_()))) {
                livingEntity.m_21195_((MobEffect)GoetyEffects.SENSE_LOSS.get());
            }
            if (livingEntity.m_21023_((MobEffect)GoetyEffects.EXPLOSIVE.get()) && (mobEffectInstance2 = livingEntity.m_21124_((MobEffect)GoetyEffects.EXPLOSIVE.get())) != null) {
                int a = mobEffectInstance2.m_19564_() + 1;
                if (MobUtil.isPushed(livingEntity)) {
                    int max = Math.max(1, 100 - a * 10);
                    if (livingEntity.m_217043_().m_188503_(max) == 0 && !livingEntity.f_19853_.f_46443_) {
                        livingEntity.f_19853_.m_254849_((Entity)livingEntity, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), 3.0f + (float)a / 2.0f, Level.ExplosionInteraction.BLOCK);
                        livingEntity.m_21195_((MobEffect)GoetyEffects.EXPLOSIVE.get());
                    }
                }
            }
            if (livingEntity.m_21023_((MobEffect)GoetyEffects.SNOW_SKIN.get()) && (mobEffectInstance = livingEntity.m_21124_((MobEffect)GoetyEffects.SNOW_SKIN.get())) != null && !livingEntity.f_19853_.f_46443_) {
                int k;
                i = Mth.m_14107_((double)livingEntity.m_20185_());
                BlockPos blockpos = new BlockPos(i, j = Mth.m_14107_((double)livingEntity.m_20186_()), k = Mth.m_14107_((double)livingEntity.m_20189_()));
                Holder biome = livingEntity.f_19853_.m_204166_(blockpos);
                if (biome.m_203656_(BiomeTags.f_263828_)) {
                    livingEntity.m_6469_(livingEntity.m_269291_().m_269549_(), 1.0f);
                }
                livingEntity.m_146924_(false);
                livingEntity.m_146917_(0);
                BlockState blockstate = Blocks.f_50125_.m_49966_();
                for (int l = 0; l < 4; ++l) {
                    i = Mth.m_14107_((double)(livingEntity.m_20185_() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                    BlockPos blockpos1 = new BlockPos(i, j = Mth.m_14107_((double)livingEntity.m_20186_()), k = Mth.m_14107_((double)(livingEntity.m_20189_() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))));
                    if (!livingEntity.f_19853_.m_46859_(blockpos1) || !blockstate.m_60710_((LevelReader)livingEntity.f_19853_, blockpos1)) continue;
                    livingEntity.f_19853_.m_46597_(blockpos1, blockstate);
                    livingEntity.f_19853_.m_220407_(GameEvent.f_157797_, blockpos1, GameEvent.Context.m_223719_((Entity)livingEntity, (BlockState)blockstate));
                }
            }
        }
    }

    @SubscribeEvent
    public static void HurtEvent(LivingHurtEvent event) {
        MobEffectInstance mobEffectInstance;
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof LivingEntity) {
            int a;
            MobEffectInstance mobEffectInstance2;
            LivingEntity living = (LivingEntity)attacker;
            if (ModDamageSource.physicalAttacks(event.getSource())) {
                if (living.m_21023_((MobEffect)GoetyEffects.FLAME_HANDS.get()) && (mobEffectInstance2 = living.m_21124_((MobEffect)GoetyEffects.FLAME_HANDS.get())) != null) {
                    a = mobEffectInstance2.m_19564_() + 1;
                    victim.m_20254_(a * 4);
                }
                if (living.m_21023_((MobEffect)GoetyEffects.VENOMOUS_HANDS.get())) {
                    MobEffectInstance mobEffectInstance3;
                    MobEffect effect = MobEffects.f_19614_;
                    if (CuriosFinder.hasWildRobe(living)) {
                        effect = (MobEffect)GoetyEffects.ACID_VENOM.get();
                    }
                    if ((mobEffectInstance3 = living.m_21124_((MobEffect)GoetyEffects.VENOMOUS_HANDS.get())) != null) {
                        int a2 = mobEffectInstance3.m_19564_();
                        victim.m_147207_(new MobEffectInstance(effect, 200, a2), (Entity)living);
                    }
                }
            }
            if (victim.m_21023_((MobEffect)GoetyEffects.REPULSIVE.get()) && (mobEffectInstance2 = victim.m_21124_((MobEffect)GoetyEffects.REPULSIVE.get())) != null) {
                a = mobEffectInstance2.m_19564_();
                living.m_216990_(SoundEvents.f_12057_);
                if (!living.f_19853_.f_46443_) {
                    ModNetwork.sendToALL(new SPlayWorldSoundPacket(living.m_20183_(), SoundEvents.f_12057_, 1.0f, 1.0f));
                    MobUtil.knockBack((Entity)living, (Entity)victim, 1.0 + (double)a / 2.0, 0.4 + (double)a * 0.2, 1.0 + (double)a / 2.0);
                }
            }
        }
        if (victim.m_21023_((MobEffect)GoetyEffects.SOUL_ARMOR.get()) && (mobEffectInstance = victim.m_21124_((MobEffect)GoetyEffects.SOUL_ARMOR.get())) != null) {
            if (mobEffectInstance.m_19557_() > MathHelper.secondsToTicks(event.getAmount())) {
                EffectsUtil.decreaseDuration(victim, (MobEffect)GoetyEffects.SOUL_ARMOR.get(), MathHelper.secondsToTicks(event.getAmount()), mobEffectInstance.m_19571_(), mobEffectInstance.m_19572_());
            }
            if (victim instanceof Player) {
                Player player = (Player)victim;
                SEHelper.decreaseSouls(player, (int)event.getAmount());
            }
        }
        if (victim.m_21023_((MobEffect)GoetyEffects.EXPLOSIVE.get()) && (mobEffectInstance = victim.m_21124_((MobEffect)GoetyEffects.EXPLOSIVE.get())) != null) {
            int a = mobEffectInstance.m_19564_() + 1;
            int max = Math.max(1, 5 - a);
            if (victim.m_217043_().m_188503_(max) == 0 && !victim.f_19853_.f_46443_) {
                victim.f_19853_.m_254849_((Entity)victim, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), 3.0f + (float)a / 2.0f, Level.ExplosionInteraction.BLOCK);
                victim.m_21195_((MobEffect)GoetyEffects.EXPLOSIVE.get());
            }
        }
        if (victim.m_21023_((MobEffect)GoetyEffects.FLAMMABLE.get()) && (mobEffectInstance = victim.m_21124_((MobEffect)GoetyEffects.FLAMMABLE.get())) != null) {
            int a = mobEffectInstance.m_19564_() + 2;
            if (event.getSource().m_269533_(DamageTypeTags.f_268745_)) {
                event.setAmount(event.getAmount() * (float)a);
            }
        }
        if (victim.m_21023_((MobEffect)GoetyEffects.ENDER_FLUX.get()) && (mobEffectInstance = victim.m_21124_((MobEffect)GoetyEffects.ENDER_FLUX.get())) != null) {
            int a = mobEffectInstance.m_19564_();
            for (int i = 0; i < 64; ++i) {
                Endermite endermite;
                if (!MobUtil.teleport(victim, 16, a)) continue;
                if (!(victim.m_217043_().m_188501_() < 0.05f) || !victim.f_19853_.m_46469_().m_46207_(GameRules.f_46134_) || (endermite = (Endermite)EntityType.f_20567_.m_20615_(victim.f_19853_)) == null) break;
                endermite.m_7678_(victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), victim.m_146908_(), victim.m_146909_());
                victim.f_19853_.m_7967_((Entity)endermite);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void DamageEvents(LivingDamageEvent event) {
        int i;
        float original;
        MobEffectInstance effectInstance;
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        if (target.m_21023_((MobEffect)GoetyEffects.SAPPED.get())) {
            effectInstance = target.m_21124_((MobEffect)GoetyEffects.SAPPED.get());
            original = event.getAmount();
            if (effectInstance != null) {
                i = effectInstance.m_19564_() + 1;
                event.setAmount(original += event.getAmount() * (0.2f * (float)i));
            }
        }
        if (target.m_21023_((MobEffect)GoetyEffects.VOID_TOUCHED.get()) && !event.getSource().m_276093_(ModDamageSource.VOIDED)) {
            effectInstance = target.m_21124_((MobEffect)GoetyEffects.VOID_TOUCHED.get());
            original = event.getAmount();
            if (effectInstance != null) {
                i = effectInstance.m_19564_() + 2;
                target.m_21195_((MobEffect)GoetyEffects.VOID_TOUCHED.get());
                event.setAmount(original *= (float)i);
            }
        }
        if (attacker instanceof LivingEntity) {
            MobEffectInstance effectInstance2;
            LivingEntity living = (LivingEntity)attacker;
            if (living.m_21023_((MobEffect)GoetyEffects.SHADOW_WALK.get())) {
                float multiply = 1.25f + (float)EffectsUtil.getAmplifier(living, (MobEffect)GoetyEffects.SHADOW_WALK.get()) / 4.0f;
                event.setAmount(event.getAmount() * multiply);
                living.m_21195_((MobEffect)GoetyEffects.SHADOW_WALK.get());
            }
            if (target.m_21023_((MobEffect)GoetyEffects.CHILL_HIDE.get()) && ModDamageSource.physicalAttacks(event.getSource()) && (effectInstance2 = target.m_21124_((MobEffect)GoetyEffects.CHILL_HIDE.get())) != null) {
                i = effectInstance2.m_19564_() * 2;
                living.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), MathHelper.secondsToTicks(3 + i), 1));
            }
        }
    }

    @SubscribeEvent
    public static void ExperienceEvents(LivingExperienceDropEvent event) {
        MobEffectInstance mobEffectInstance;
        Player player = event.getAttackingPlayer();
        LivingEntity living = event.getEntity();
        if (player != null && living != null && player.m_21023_((MobEffect)GoetyEffects.INSIGHT.get()) && (mobEffectInstance = player.m_21124_((MobEffect)GoetyEffects.INSIGHT.get())) != null) {
            int a = mobEffectInstance.m_19564_() + 2;
            event.setDroppedExperience(event.getOriginalExperience() * a);
        }
    }

    @SubscribeEvent
    public static void DeathEvents(LivingDeathEvent event) {
        MobEffectInstance mobEffectInstance;
        Object instanceList;
        Player player;
        LivingEntity effected = event.getEntity();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            if (player.m_21023_((MobEffect)GoetyEffects.SAVE_EFFECTS.get()) && !player.m_21220_().isEmpty() && !(instanceList = new ArrayList(player.m_21220_())).isEmpty()) {
                ListTag listtag = new ListTag();
                CompoundTag playerData = event.getEntity().getPersistentData();
                CompoundTag data = !playerData.m_128441_("PlayerPersisted") ? new CompoundTag() : playerData.m_128469_("PlayerPersisted");
                Iterator iterator = instanceList.iterator();
                while (iterator.hasNext()) {
                    MobEffectInstance mobeffectinstance = (MobEffectInstance)iterator.next();
                    listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
                }
                data.m_128365_(ConstantPaths.keepEffects(), (Tag)listtag);
                playerData.m_128365_("PlayerPersisted", (Tag)data);
            }
            if (SEHelper.hasEndWalk(player)) {
                SEHelper.removeEndWalk(player);
            }
        }
        if ((instanceList = event.getSource().m_7639_()) instanceof Player && (player = (Player)instanceList).m_21023_((MobEffect)GoetyEffects.CORPSE_EATER.get()) && (mobEffectInstance = player.m_21124_((MobEffect)GoetyEffects.CORPSE_EATER.get())) != null) {
            int amp = mobEffectInstance.m_19564_() + 1;
            int amount = Mth.m_14143_((float)(event.getEntity().m_21233_() / 5.0f));
            if ((amount = (player.f_19853_.f_46441_.m_188503_(amount + 1) + 2) * amp) > 0) {
                player.m_36324_().m_38707_(amount, 0.1f);
            }
        }
        if (event.getSource().m_276093_(ModDamageSource.DOOM) && (livingEntity = effected.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)livingEntity;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.DOOM_DEATH.get()), effected.m_20185_(), (double)effected.m_278726_(), effected.m_20189_(), 0, 0.0, 0.07, 0.0, 0.5);
            effected.m_5496_((SoundEvent)ModSounds.DOOM.get(), 1.0f, 1.0f);
            ModNetwork.sendToALL(new SPlayWorldSoundPacket(effected.m_20183_(), (SoundEvent)ModSounds.DOOM.get(), 1.0f, 1.0f));
        }
    }

    @SubscribeEvent
    public static void RespawnEvents(PlayerEvent.PlayerRespawnEvent event) {
        CompoundTag data;
        CompoundTag playerData = event.getEntity().getPersistentData();
        if (playerData.m_128441_("PlayerPersisted") && (data = playerData.m_128469_("PlayerPersisted")).m_128425_(ConstantPaths.keepEffects(), 9)) {
            ListTag listtag = data.m_128437_(ConstantPaths.keepEffects(), 10);
            for (int i = 0; i < listtag.size(); ++i) {
                MobEffectInstance mobeffectinstance = MobEffectInstance.m_19560_((CompoundTag)listtag.m_128728_(i));
                if (mobeffectinstance == null || event.getEntity().m_21023_(mobeffectinstance.m_19544_()) || mobeffectinstance.m_19544_() == GoetyEffects.SAVE_EFFECTS.get()) continue;
                event.getEntity().m_7292_(mobeffectinstance);
            }
            data.m_128473_(ConstantPaths.keepEffects());
        }
    }

    @SubscribeEvent
    public static void ChargeEffect(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity != null) {
            boolean flag2;
            AttributeInstance speed = livingEntity.m_21051_(Attributes.f_22279_);
            AttributeInstance attack = livingEntity.m_21051_(Attributes.f_22281_);
            AttributeModifier addSpeed = new AttributeModifier(UUID.fromString("d4818bbc-54ed-4ecf-95a3-a15fbf71b31d"), "Charged Speed I", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
            AttributeModifier addAttack = new AttributeModifier(UUID.fromString("4bf0a8e3-a8f8-4bf6-95d2-f0ddbadd793e"), "Charged Attack I", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
            AttributeModifier addMoreSpeed = new AttributeModifier(UUID.fromString("e8ea9f21-c671-4a61-a297-db8fa50f3d13"), "Charged Speed II", 0.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
            AttributeModifier reduceAttack = new AttributeModifier(UUID.fromString("a55e53d6-dd6a-41e8-8c1f-8f548887ed30"), "Charged Attack II", -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL);
            MobEffectInstance chargeInstance = livingEntity.m_21124_((MobEffect)GoetyEffects.CHARGED.get());
            boolean notNull = chargeInstance != null;
            boolean flag = notNull && chargeInstance.m_19564_() < 1;
            boolean bl = flag2 = notNull && chargeInstance.m_19564_() >= 1;
            if (attack != null && speed != null) {
                if (notNull) {
                    if (flag) {
                        if (speed.m_22109_(addMoreSpeed)) {
                            speed.m_22130_(addMoreSpeed);
                        }
                        if (attack.m_22109_(reduceAttack)) {
                            attack.m_22130_(reduceAttack);
                        }
                        if (!speed.m_22109_(addSpeed)) {
                            speed.m_22125_(addSpeed);
                        }
                        if (!attack.m_22109_(addAttack)) {
                            attack.m_22125_(addAttack);
                        }
                    } else if (flag2) {
                        if (speed.m_22109_(addSpeed)) {
                            speed.m_22130_(addSpeed);
                        }
                        if (attack.m_22109_(addAttack)) {
                            attack.m_22130_(addAttack);
                        }
                        if (!speed.m_22109_(addMoreSpeed)) {
                            speed.m_22125_(addMoreSpeed);
                        }
                        if (!attack.m_22109_(reduceAttack)) {
                            attack.m_22125_(reduceAttack);
                        }
                    }
                } else {
                    if (speed.m_22109_(addSpeed)) {
                        speed.m_22130_(addSpeed);
                    }
                    if (attack.m_22109_(addAttack)) {
                        attack.m_22130_(addAttack);
                    }
                    if (speed.m_22109_(addMoreSpeed)) {
                        speed.m_22130_(addMoreSpeed);
                    }
                    if (attack.m_22109_(reduceAttack)) {
                        attack.m_22130_(reduceAttack);
                    }
                }
            }
            if (notNull) {
                Level level;
                if (chargeInstance.m_19564_() >= 2 && livingEntity.f_20916_ > 0) {
                    livingEntity.m_21195_(chargeInstance.m_19544_());
                } else if (livingEntity.f_19797_ % 20 == 0 && (level = livingEntity.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ModParticleTypes.ELECTRIC.get(), (Entity)livingEntity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void EffectVisibilityEvents(LivingEvent.LivingVisibilityEvent event) {
        Entity entity = event.getLookingEntity();
        if (entity instanceof LivingEntity) {
            MobEffectInstance mobEffectInstance;
            LivingEntity living = (LivingEntity)entity;
            if (living.m_21023_((MobEffect)GoetyEffects.SENSE_LOSS.get()) && (mobEffectInstance = living.m_21124_((MobEffect)GoetyEffects.SENSE_LOSS.get())) != null) {
                int a = mobEffectInstance.m_19564_();
                event.modifyVisibility(0.5 - (double)a / 10.0);
            }
            if (event.getEntity().m_21023_((MobEffect)GoetyEffects.SHADOW_WALK.get())) {
                if (event.getLookingEntity().m_6095_().m_204039_(Tags.EntityTypes.BOSSES)) {
                    event.modifyVisibility(0.5);
                } else {
                    event.modifyVisibility(0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void changeTarget(LivingChangeTargetEvent event) {
        LivingEntity target = event.getOriginalTarget();
        if (target != null) {
            LivingEntity owner = MobUtil.getOwner((Entity)event.getEntity());
            if (!(!target.m_21023_((MobEffect)GoetyEffects.SHADOW_WALK.get()) || event.getEntity().m_6095_().m_204039_(Tags.EntityTypes.BOSSES) || owner != null && owner.m_6095_().m_204039_(Tags.EntityTypes.BOSSES))) {
                if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                    event.setNewTarget(null);
                } else {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void enderTeleport(EntityTeleportEvent event) {
        LivingEntity living;
        Entity entity;
        if (!(event instanceof EntityTeleportEvent.TeleportCommand) && !(event instanceof EntityTeleportEvent.SpreadPlayersCommand) && (entity = event.getEntity()) instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)GoetyEffects.ENDER_GROUND.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void finishItemEvents(LivingEntityUseItemEvent.Finish event) {
        if (event.getItem().m_41720_() == Items.f_42455_ && event.getEntity().m_21023_((MobEffect)GoetyEffects.SOUL_ARMOR.get())) {
            event.getEntity().m_21195_((MobEffect)GoetyEffects.SOUL_ARMOR.get());
        }
        if (event.getItem().m_204117_(ModTags.Items.BREWABLE_FOOD)) {
            for (MobEffectInstance mobeffectinstance : PotionUtils.m_43547_((ItemStack)event.getItem())) {
                if (mobeffectinstance.m_19544_().m_8093_()) {
                    mobeffectinstance.m_19544_().m_19461_((Entity)event.getEntity(), (Entity)event.getEntity(), event.getEntity(), mobeffectinstance.m_19564_(), 1.0);
                    continue;
                }
                event.getEntity().m_7292_(new MobEffectInstance(mobeffectinstance));
            }
            for (BrewEffectInstance brewEffectInstance : BrewUtils.getBrewEffects(event.getItem())) {
                brewEffectInstance.getEffect().drinkBlockEffect((Entity)event.getEntity(), (Entity)event.getEntity(), event.getEntity(), brewEffectInstance.getAmplifier(), BrewUtils.getAreaOfEffect(event.getItem()));
            }
        }
        if (!(event.getItem().m_41720_() instanceof IWand) && event.getEntity().m_21023_((MobEffect)GoetyEffects.SHADOW_WALK.get())) {
            event.getEntity().m_21195_((MobEffect)GoetyEffects.SHADOW_WALK.get());
        }
    }

    @SubscribeEvent
    public static void onCastingSpell(CastingMagicEvent event) {
        if (!(event.getSpell() instanceof EndWalkSpell) && (event.castingTime() > 20 || event.castingTime() >= event.getSpell().castDuration(event.getEntity(), event.getUseItem())) && event.getEntity().m_21023_((MobEffect)GoetyEffects.SHADOW_WALK.get())) {
            event.getEntity().m_21195_((MobEffect)GoetyEffects.SHADOW_WALK.get());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCastSpell(CastMagicEvent event) {
        if (!(event.getSpell() instanceof EndWalkSpell) && event.getEntity().m_21023_((MobEffect)GoetyEffects.SHADOW_WALK.get())) {
            event.getEntity().m_21195_((MobEffect)GoetyEffects.SHADOW_WALK.get());
        }
    }

    @SubscribeEvent
    public static void ProjectileAddEvents(EntityJoinLevelEvent event) {
        LivingEntity livingEntity;
        Projectile projectile;
        Entity entity;
        Entity entity2;
        if (!event.getLevel().f_46443_ && (entity2 = event.getEntity()) instanceof Projectile && (entity = (projectile = (Projectile)entity2).m_19749_()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)GoetyEffects.SHADOW_WALK.get())) {
            livingEntity.m_21195_((MobEffect)GoetyEffects.SHADOW_WALK.get());
        }
    }

    @SubscribeEvent
    public static void KnockbackEvents(LivingKnockBackEvent event) {
        MobEffectInstance mobEffectInstance;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity != null && livingEntity.m_21023_((MobEffect)GoetyEffects.FLIMSY.get()) && (mobEffectInstance = livingEntity.m_21124_((MobEffect)GoetyEffects.FLIMSY.get())) != null) {
            int a = mobEffectInstance.m_19564_() + 2;
            float strength = event.getOriginalStrength();
            event.setStrength(strength * (float)a);
        }
    }

    @SubscribeEvent
    public static void PlayerInteractItemEvents(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        Item item = event.getItemStack().m_41720_();
        if (item instanceof BottleItem) {
            BottleItem bottleItem = (BottleItem)item;
            List list = level.m_6443_(DragonBreathCloud.class, player.m_20191_().m_82400_(2.0), p_289499_ -> p_289499_ != null && p_289499_.m_6084_() && p_289499_.getOwner() instanceof EnderDragon);
            if (!list.isEmpty()) {
                DragonBreathCloud breathCloud = (DragonBreathCloud)((Object)list.get(0));
                breathCloud.setRadius(breathCloud.getRadius() - 0.5f);
                level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11771_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                level.m_220400_((Entity)player, GameEvent.f_157816_, player.m_20182_());
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10565_.m_61494_(serverplayer, event.getItemStack(), (Entity)breathCloud);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)bottleItem));
                ItemUtils.m_41813_((ItemStack)event.getItemStack(), (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42735_));
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            }
        }
    }

    @SubscribeEvent
    public static void PlayerInteractEntityEvents(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if (player.m_21023_((MobEffect)GoetyEffects.SHADOW_WALK.get())) {
            Entity entity;
            if (SEHelper.hasEndWalk(player) && (entity = event.getTarget()) instanceof Merchant) {
                Merchant merchant = (Merchant)entity;
                merchant.m_7189_(null);
            }
            player.m_21195_((MobEffect)GoetyEffects.SHADOW_WALK.get());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void PlayerInteractBlockEvents(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockHitResult blockHitResult = event.getHitVec();
        BlockPos blockPos = blockHitResult.m_82425_();
        BlockState blockState = level.m_8055_(blockPos);
        if (player.m_21023_((MobEffect)GoetyEffects.SHADOW_WALK.get()) && blockState.m_60664_(level, player, player.m_7655_(), blockHitResult).m_19077_()) {
            player.m_21195_((MobEffect)GoetyEffects.SHADOW_WALK.get());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void BreakingBlockEvents(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!event.getState().m_60795_() && player.m_21023_((MobEffect)GoetyEffects.SHADOW_WALK.get())) {
            player.m_21195_((MobEffect)GoetyEffects.SHADOW_WALK.get());
        }
    }

    @SubscribeEvent
    public static void PlacingBlockEvents(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!event.getState().m_60795_() && living.m_21023_((MobEffect)GoetyEffects.SHADOW_WALK.get())) {
                living.m_21195_((MobEffect)GoetyEffects.SHADOW_WALK.get());
            }
        }
    }

    @SubscribeEvent
    public static void DimensionChangeEvents(EntityTravelToDimensionEvent event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)GoetyEffects.SHADOW_WALK.get())) {
            Player player;
            if (living instanceof Player && SEHelper.hasEndWalk(player = (Player)living)) {
                SEHelper.removeEndWalk(player);
            }
            living.m_21195_((MobEffect)GoetyEffects.SHADOW_WALK.get());
        }
    }

    @SubscribeEvent
    public static void PotionApplicationEvents(MobEffectEvent.Applicable event) {
        Player player;
        LivingEntity livingEntity;
        if (event.getEffectInstance().m_19544_() == MobEffects.f_19607_ && event.getEntity().m_21023_((MobEffect)GoetyEffects.BURN_HEX.get())) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEffectInstance().m_19544_() == MobEffects.f_19610_ && (livingEntity = event.getEntity()) instanceof Player) {
            player = (Player)livingEntity;
            if (((Boolean)ItemConfig.DarkHelmetBlindness.get()).booleanValue() && ItemHelper.findHelmet(player, (Item)ModItems.DARK_HELMET.get())) {
                event.setResult(Event.Result.DENY);
            }
        }
        if (event.getEffectInstance().m_19544_() == MobEffects.f_216964_ && (livingEntity = event.getEntity()) instanceof Player) {
            player = (Player)livingEntity;
            if (((Boolean)ItemConfig.DarkHelmetDarkness.get()).booleanValue() && ItemHelper.findHelmet(player, (Item)ModItems.DARK_HELMET.get())) {
                event.setResult(Event.Result.DENY);
            }
        }
        if (event.getEffectInstance().m_19544_() == MobEffects.f_19591_ && CuriosFinder.hasWindyRobes(event.getEntity())) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEffectInstance().m_19544_() == GoetyEffects.ILLAGUE.get() && (event.getEntity().m_6095_().m_204039_(EntityTypeTags.f_13121_) || event.getEntity() instanceof PatrollingMonster)) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEffectInstance().m_19544_() == GoetyEffects.FREEZING.get() && (event.getEntity().m_21023_((MobEffect)GoetyEffects.SNOW_SKIN.get()) || event.getEntity().m_6095_().m_204039_(EntityTypeTags.f_144294_))) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEffectInstance().m_19544_() == GoetyEffects.BUSTED.get() && (event.getEntity().m_21051_(Attributes.f_22284_) == null || event.getEntity().m_21133_(Attributes.f_22284_) <= 0.0)) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEffectInstance().m_19544_() == GoetyEffects.VOID_TOUCHED.get() && event.getEntity().m_6095_().m_204039_(ModTags.EntityTypes.VOID_TOUCHED_IMMUNE)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void PotionAddedEvents(MobEffectEvent.Added event) {
        LivingEntity effected = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        MobEffect effect = instance.m_19544_();
        if (effect == GoetyEffects.BURN_HEX.get() && effected.m_21023_(MobEffects.f_19607_)) {
            effected.m_21195_(MobEffects.f_19607_);
        }
        if (effect == GoetyEffects.SNOW_SKIN.get() && effected.m_21023_((MobEffect)GoetyEffects.FREEZING.get())) {
            effected.m_21195_((MobEffect)GoetyEffects.FREEZING.get());
        }
        if (effect == GoetyEffects.ENDER_GROUND.get() && effected.m_21023_((MobEffect)GoetyEffects.SHADOW_WALK.get())) {
            effected.m_21195_((MobEffect)GoetyEffects.SHADOW_WALK.get());
        }
        if (effect == GoetyEffects.VOID_TOUCHED.get() && !effected.m_21023_((MobEffect)GoetyEffects.VOID_TOUCHED.get()) && effected.f_19853_ instanceof ServerLevel) {
            ModNetwork.sentToTrackingEntityAndPlayer((Entity)effected, new SPlayWorldSoundPacket(effected.m_20183_(), (SoundEvent)ModSounds.VOID_TOUCHED_ACTIVATE.get(), 1.0f, 1.0f));
            ModNetwork.sentToTrackingEntityAndPlayer((Entity)effected, new SPlayEffectLoopSoundPacket((Entity)effected, (SoundEvent)ModSounds.VOID_TOUCHED_LOOP.get(), effect, 1.0f, 1.0f));
        }
        if (effect == GoetyEffects.SENSE_LOSS.get() && effected instanceof Mob) {
            Mob mob = (Mob)effected;
            mob.m_6710_(null);
        }
    }

    @SubscribeEvent
    public static void PotionRemoveEvents(MobEffectEvent.Remove event) {
        LivingEntity effected = event.getEntity();
        if (effected != null && event.getEffect() != null) {
            Player player;
            if (effected.m_21023_((MobEffect)GoetyEffects.SAVE_EFFECTS.get())) {
                event.setCanceled(event.getEffect() != GoetyEffects.SAVE_EFFECTS.get() && effected instanceof Player && SEHelper.hasEndWalk(player = (Player)effected) && event.getEffect() != GoetyEffects.SHADOW_WALK.get());
            }
            if (event.getEffect() != null && event.getEffect() == GoetyEffects.SHADOW_WALK.get() && effected instanceof Player) {
                player = (Player)effected;
                PotionEvents.teleportShadowWalk(player);
            }
            if (event.getEffect() == GoetyEffects.WILD_RAGE.get() && effected instanceof Mob) {
                Mob mob = (Mob)effected;
                mob.m_6710_(null);
                mob.m_6703_(null);
                mob.m_6274_().m_21936_(MemoryModuleType.f_26334_);
                mob.m_6274_().m_21936_(MemoryModuleType.f_26372_);
            }
            if (event.getEffect() == GoetyEffects.VOID_TOUCHED.get() && effected.f_19853_ instanceof ServerLevel) {
                ModNetwork.sentToTrackingEntityAndPlayer((Entity)effected, new SPlayWorldSoundPacket(effected.m_20183_(), (SoundEvent)ModSounds.VOID_TOUCHED_DEACTIVATE.get(), 1.0f, 1.0f));
            }
        }
    }

    @SubscribeEvent
    public static void PotionExpiredEvents(MobEffectEvent.Expired event) {
        LivingEntity effected = event.getEntity();
        MobEffectInstance mobEffectInstance = event.getEffectInstance();
        if (mobEffectInstance != null) {
            if (mobEffectInstance.m_19544_() == GoetyEffects.SHADOW_WALK.get() && effected instanceof Player) {
                Player player = (Player)effected;
                PotionEvents.teleportShadowWalk(player);
            }
            if (mobEffectInstance.m_19544_() == GoetyEffects.DOOM.get() && effected.m_6072_() && !effected.m_6095_().m_204039_(Tags.EntityTypes.BOSSES)) {
                int a = mobEffectInstance.m_19564_() + 1;
                float doom = 0.05f * (float)a;
                if (effected.m_21223_() <= effected.m_21233_() * doom) {
                    effected.m_6469_(ModDamageSource.getDamageSource(effected.f_19853_, ModDamageSource.DOOM, new EntityType[0]), effected.m_21233_() * 20.0f);
                }
            }
            if (mobEffectInstance.m_19544_() == GoetyEffects.VOID_TOUCHED.get() && effected.f_19853_ instanceof ServerLevel) {
                ModNetwork.sentToTrackingEntityAndPlayer((Entity)effected, new SPlayWorldSoundPacket(effected.m_20183_(), (SoundEvent)ModSounds.VOID_TOUCHED_DEACTIVATE.get(), 1.0f, 1.0f));
            }
        }
    }

    public static void teleportShadowWalk(Player player) {
        BlockPos blockPos = SEHelper.getEndWalkPos(player);
        if (blockPos != null) {
            if (SEHelper.getEndWalkDimension(player) != null && player.f_19853_.m_46472_() == SEHelper.getEndWalkDimension(player)) {
                player.m_6915_();
                player.m_6021_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
                if (!player.f_19853_.f_46443_) {
                    player.f_19853_.m_7605_((Entity)player, (byte)46);
                    ModNetwork.sendToALL(new SPlayWorldSoundPacket(player.m_20183_(), SoundEvents.f_11852_, 1.0f, 1.0f));
                    ModNetwork.sendToALL(new SPlayEntitySoundPacket(player.m_20148_(), SoundEvents.f_11852_, 1.0f, 1.0f));
                }
                Vec3 vec3 = player.m_20182_();
                player.f_19853_.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)player));
            }
            SEHelper.removeEndWalk(player);
        }
    }
}

