/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.magic;

import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.common.items.magic.MagicFocus;
import com.Polarice3.Goety.common.magic.spells.utility.CommandSpell;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.utils.EntityFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class OrderFocus
extends MagicFocus {
    public static String SERVANT_LIST = "servantList";
    public static String SERVANT_CLIENT_LIST = "servantClientList";

    public OrderFocus() {
        super(new CommandSpell());
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.f_46443_) {
            ListTag listTag = OrderFocus.getServantList(stack, worldIn);
            if (listTag != null && stack.m_41783_() != null && listTag.isEmpty()) {
                stack.m_41783_().m_128473_(SERVANT_LIST);
                stack.m_41783_().m_128473_(SERVANT_CLIENT_LIST);
            }
            List<LivingEntity> list = OrderFocus.getServants(stack);
            List<LivingEntity> list2 = OrderFocus.getServantsClient(worldIn, stack);
            List<Integer> integerList = OrderFocus.getServantIds(stack);
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    int id;
                    Entity entity;
                    LivingEntity livingEntity = list.get(i);
                    if (livingEntity == null) continue;
                    if (livingEntity.m_213877_() || livingEntity.m_21224_()) {
                        OrderFocus.removeServant(stack, livingEntity, worldIn);
                        OrderFocus.removeServantClient(stack, livingEntity.m_19879_(), worldIn);
                    } else if (!list2.contains(livingEntity)) {
                        OrderFocus.setServantsClient(stack, worldIn, livingEntity);
                    }
                    if (integerList.isEmpty() || integerList.size() < list.size() || (entity = worldIn.m_6815_(id = integerList.get(i).intValue())) instanceof LivingEntity && !entity.m_213877_() && entity.m_6084_() && livingEntity.m_19879_() == id) continue;
                    OrderFocus.removeServantClient(stack, id, worldIn);
                }
            } else if (listTag != null && stack.m_41783_() != null) {
                stack.m_41783_().m_128473_(SERVANT_LIST);
                stack.m_41783_().m_128473_(SERVANT_CLIENT_LIST);
            }
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.f_19853_.f_46443_ && entity instanceof LivingEntity) {
            List<LivingEntity> list;
            IServant owned;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (stack.m_41720_() instanceof OrderFocus && livingEntity instanceof IServant && (owned = (IServant)livingEntity).canBeCommanded() && owned.getTrueOwner() == player && ((list = OrderFocus.getServants(stack)).isEmpty() || list.size() < 8) && !list.contains(livingEntity)) {
                OrderFocus.setServants(stack, player, livingEntity);
                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
            }
        }
        return true;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6144_() || player.m_6047_()) {
            if (itemstack.m_41720_() instanceof OrderFocus && itemstack.m_41783_() != null) {
                itemstack.m_41783_().m_128473_(SERVANT_LIST);
                itemstack.m_41783_().m_128473_(SERVANT_CLIENT_LIST);
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public boolean m_5812_(ItemStack p_41453_) {
        return p_41453_.m_41783_() != null && p_41453_.m_41783_().m_128441_(SERVANT_LIST);
    }

    public static ListTag getServantList(ItemStack stack, Level level) {
        if (!level.f_46443_) {
            CompoundTag compound = new CompoundTag();
            if (stack.m_41782_()) {
                compound = stack.m_41783_();
            }
            if (compound != null && compound.m_128441_(SERVANT_LIST)) {
                return compound.m_128437_(SERVANT_LIST, 8);
            }
        }
        return null;
    }

    public static void removeServant(ItemStack stack, LivingEntity livingEntity, Level level) {
        if (!level.f_46443_) {
            CompoundTag compound = new CompoundTag();
            if (stack.m_41782_()) {
                compound = stack.m_41783_();
            }
            ArrayList<String> list = new ArrayList<String>();
            if (compound != null) {
                if (compound.m_128441_(SERVANT_LIST)) {
                    for (int i = 0; i < compound.m_128437_(SERVANT_LIST, 8).size(); ++i) {
                        list.add(compound.m_128437_(SERVANT_LIST, 8).m_128778_(i));
                    }
                }
                if (list.contains(livingEntity.m_20149_())) {
                    ListTag nbttaglist = new ListTag();
                    if (compound.m_128441_(SERVANT_LIST)) {
                        nbttaglist = compound.m_128437_(SERVANT_LIST, 8);
                    }
                    nbttaglist.remove((Object)StringTag.m_129297_((String)livingEntity.m_20149_()));
                    compound.m_128365_(SERVANT_LIST, (Tag)nbttaglist);
                    stack.m_41751_(compound);
                }
            }
        }
    }

    public static void removeServantClient(ItemStack stack, int id, Level level) {
        if (!level.f_46443_) {
            CompoundTag compound = new CompoundTag();
            if (stack.m_41782_()) {
                compound = stack.m_41783_();
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            if (compound != null) {
                if (compound.m_128441_(SERVANT_CLIENT_LIST)) {
                    for (int i = 0; i < compound.m_128437_(SERVANT_CLIENT_LIST, 3).size(); ++i) {
                        list.add(compound.m_128437_(SERVANT_CLIENT_LIST, 3).m_128763_(i));
                    }
                }
                if (list.contains(id)) {
                    ListTag nbttaglist = new ListTag();
                    if (compound.m_128441_(SERVANT_CLIENT_LIST)) {
                        nbttaglist = compound.m_128437_(SERVANT_CLIENT_LIST, 3);
                    }
                    nbttaglist.remove((Object)IntTag.m_128679_((int)id));
                    compound.m_128365_(SERVANT_CLIENT_LIST, (Tag)nbttaglist);
                    stack.m_41751_(compound);
                }
            }
        }
    }

    public static List<LivingEntity> getServants(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag != null) {
            return OrderFocus.getServants(compoundtag);
        }
        return new ArrayList<LivingEntity>();
    }

    public static List<LivingEntity> getServants(@Nullable CompoundTag compoundTag) {
        ArrayList<LivingEntity> servants = new ArrayList<LivingEntity>();
        if (compoundTag != null && compoundTag.m_128441_(SERVANT_LIST)) {
            ListTag list = compoundTag.m_128437_(SERVANT_LIST, 8);
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = EntityFinder.getEntityByUuiD(UUID.fromString(list.m_128778_(i)));
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                servants.add(livingEntity);
            }
        }
        return servants;
    }

    public static List<Integer> getServantIds(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag != null) {
            return OrderFocus.getServantIds(compoundtag);
        }
        return new ArrayList<Integer>();
    }

    public static List<Integer> getServantIds(@Nullable CompoundTag compoundTag) {
        ArrayList<Integer> integers = new ArrayList<Integer>();
        if (compoundTag != null && compoundTag.m_128441_(SERVANT_CLIENT_LIST)) {
            ListTag list = compoundTag.m_128437_(SERVANT_CLIENT_LIST, 3);
            for (int i = 0; i < list.size(); ++i) {
                integers.add(list.m_128763_(i));
            }
        }
        return integers;
    }

    public static List<LivingEntity> getServantsClient(Level level, ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag != null) {
            return OrderFocus.getServantsClient(level, compoundtag);
        }
        return new ArrayList<LivingEntity>();
    }

    public static List<LivingEntity> getServantsClient(Level level, @Nullable CompoundTag compoundTag) {
        ArrayList<LivingEntity> servants = new ArrayList<LivingEntity>();
        if (compoundTag != null && compoundTag.m_128441_(SERVANT_CLIENT_LIST)) {
            ListTag list = compoundTag.m_128437_(SERVANT_CLIENT_LIST, 3);
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = level.m_6815_(list.m_128763_(i));
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                servants.add(livingEntity);
            }
        }
        return servants;
    }

    public static void setServants(ItemStack stack, Player player, LivingEntity livingEntity) {
        if (!player.f_19853_.f_46443_) {
            CompoundTag compound = new CompoundTag();
            if (stack.m_41782_()) {
                compound = stack.m_41783_();
            }
            ArrayList<String> list = new ArrayList<String>();
            if (compound != null) {
                if (compound.m_128441_(SERVANT_LIST)) {
                    for (int i = 0; i < compound.m_128437_(SERVANT_LIST, 8).size(); ++i) {
                        list.add(compound.m_128437_(SERVANT_LIST, 8).m_128778_(i));
                    }
                }
                if (!list.contains(livingEntity.m_20149_())) {
                    ListTag nbttaglist = new ListTag();
                    if (compound.m_128441_(SERVANT_LIST)) {
                        nbttaglist = compound.m_128437_(SERVANT_LIST, 8);
                    }
                    nbttaglist.add((Object)StringTag.m_129297_((String)livingEntity.m_20149_()));
                    compound.m_128365_(SERVANT_LIST, (Tag)nbttaglist);
                    stack.m_41751_(compound);
                }
            }
        }
    }

    public static void setServantsClient(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (!level.f_46443_) {
            CompoundTag compound = new CompoundTag();
            if (stack.m_41782_()) {
                compound = stack.m_41783_();
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            if (compound != null) {
                if (compound.m_128441_(SERVANT_CLIENT_LIST)) {
                    for (int i = 0; i < compound.m_128437_(SERVANT_CLIENT_LIST, 3).size(); ++i) {
                        list.add(compound.m_128437_(SERVANT_CLIENT_LIST, 3).m_128763_(i));
                    }
                }
                if (!list.contains(livingEntity.m_19879_())) {
                    ListTag nbttaglist = new ListTag();
                    if (compound.m_128441_(SERVANT_CLIENT_LIST)) {
                        nbttaglist = compound.m_128437_(SERVANT_CLIENT_LIST, 3);
                    }
                    nbttaglist.add((Object)IntTag.m_128679_((int)livingEntity.m_19879_()));
                    compound.m_128365_(SERVANT_CLIENT_LIST, (Tag)nbttaglist);
                    stack.m_41751_(compound);
                }
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        OrderFocus.addCommandText(worldIn, stack, tooltip);
    }

    public static void addCommandText(Level level, ItemStack stack, List<Component> tooltip) {
        if (stack.m_41783_() != null) {
            if (!stack.m_41783_().m_128441_(SERVANT_LIST)) {
                tooltip.add((Component)Component.m_237115_((String)"info.goety.focus.noServant"));
            } else if (level != null) {
                for (LivingEntity livingEntity : OrderFocus.getServantsClient(level, stack.m_41783_())) {
                    if (livingEntity == null) continue;
                    tooltip.add((Component)Component.m_237115_((String)"info.goety.focus.servant").m_130946_(" ").m_7220_(livingEntity.m_7770_() != null ? livingEntity.m_7770_() : livingEntity.m_5446_()).m_130940_(ChatFormatting.GREEN));
                }
            }
        }
    }
}

