/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AddItemLootModifier
implements IGlobalLootModifier {
    public static final Supplier<Codec<AddItemLootModifier>> CODEC = () -> RecordCodecBuilder.create(inst -> inst.group((App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("chance").forGetter(lm -> Float.valueOf(lm.chance)), (App)Codec.BOOL.fieldOf("replace").forGetter(configuration -> configuration.replace), (App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(lm -> lm.conditions), (App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(lm -> lm.addedItem), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("count").forGetter(lm -> lm.count)).apply((Applicative)inst, AddItemLootModifier::new));
    private final float chance;
    private final boolean replace;
    private final Item addedItem;
    private final int count;
    private final LootItemCondition[] conditions;
    private final Predicate<LootContext> orConditions;

    protected AddItemLootModifier(float chance, boolean replace, LootItemCondition[] conditionsIn, Item addedItemIn, int count) {
        this.conditions = conditionsIn;
        this.orConditions = LootItemConditions.m_81841_((Predicate[])conditionsIn);
        this.addedItem = addedItemIn;
        this.replace = replace;
        this.count = count;
        this.chance = chance;
    }

    @NotNull
    public ObjectArrayList<ItemStack> apply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        return this.orConditions.test(context) ? this.doApply(generatedLoot, context) : generatedLoot;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.m_230907_().m_188501_() < this.chance) {
            if (this.replace) {
                generatedLoot.clear();
            }
            generatedLoot.add((Object)new ItemStack((ItemLike)this.addedItem, this.count));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

