/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.construct;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.SlimeServant;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.world.structures.ModStructures;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.BlockFinder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SpawnFromBlock {
    public static boolean surroundedWater(Level level, BlockPos blockPos) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos blockpos;
                    if (i == 0 || j == 0 || k == 0 || level.m_46801_(blockpos = blockPos.m_7918_(i, j, k))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean conditionsMet(Level worldIn, LivingEntity entityLiving) {
        int count = 0;
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            for (Entity entity : serverLevel.m_8583_()) {
                SlimeServant servant;
                if (!(entity instanceof SlimeServant) || (servant = (SlimeServant)entity).getTrueOwner() != entityLiving || !servant.m_6084_()) continue;
                ++count;
            }
        }
        return count < (Integer)SpellConfig.SlimyLimit.get();
    }

    public static boolean spawnServant(Player player, ItemStack stack, Level level, BlockPos blockPos) {
        BlockState blockState = level.m_8055_(blockPos);
        if (!level.f_46443_) {
            Summoned summoned = null;
            if (blockState.m_60713_(Blocks.f_50374_)) {
                summoned = (Summoned)((EntityType)ModEntityType.SLIME_SERVANT.get()).m_20615_(level);
                if (SpawnFromBlock.surroundedWater(level, blockPos)) {
                    summoned = (Summoned)((EntityType)ModEntityType.TROPICAL_SLIME_SERVANT.get()).m_20615_(level);
                } else if (BlockFinder.findStructure(level, blockPos, ModStructures.CRYPT_KEY)) {
                    summoned = (Summoned)((EntityType)ModEntityType.CRYPT_SLIME_SERVANT.get()).m_20615_(level);
                }
            } else if (blockState.m_60713_(Blocks.f_50450_)) {
                summoned = (Summoned)((EntityType)ModEntityType.MAGMA_CUBE_SERVANT.get()).m_20615_(level);
            }
            if (summoned != null) {
                if (SpawnFromBlock.conditionsMet(level, (LivingEntity)player)) {
                    summoned.setTrueOwner((LivingEntity)player);
                    summoned.m_6518_((ServerLevelAccessor)level, level.m_6436_(summoned.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    summoned.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.05, (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
                    if (summoned instanceof SlimeServant) {
                        SlimeServant slime = (SlimeServant)summoned;
                        slime.setSize(2, true);
                    }
                    if (level.m_7967_((Entity)summoned)) {
                        level.m_46796_(2001, blockPos, Block.m_49956_((BlockState)level.m_8055_(blockPos)));
                        level.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                        stack.m_41774_(1);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)summoned);
                        }
                        return true;
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"info.goety.summon.limit"), true);
                    summoned.m_146870_();
                }
            }
        }
        return false;
    }
}

