/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.abyss;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class TridentStormSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.TridentStormCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return 100;
    }

    @Override
    public int castDuration(LivingEntity caster, ItemStack staff) {
        return this.defaultCastDuration();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.TRIDENT_STORM_PRE.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.TridentStormCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.ABYSS;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        return list;
    }

    @Override
    public void startSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
        }
        int warmUp = MathHelper.secondsToTicks(2);
        if (this.rightStaff(staff)) {
            int i = caster.m_217043_().m_188503_(4);
            if (i == 0) {
                WandUtil.summonTridentSurround(caster, warmUp, potency);
            } else if (i == 1) {
                WandUtil.summonTridentSquare(caster, warmUp, potency);
            } else if (i == 2) {
                WandUtil.summonTridentWideCircle(caster, warmUp, potency);
            } else {
                WandUtil.summonTridentCross(caster, warmUp, potency);
            }
        } else {
            WandUtil.summonTridentMinor(caster, warmUp, potency);
        }
    }
}

