/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.frost;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ChillHideSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.ChillingCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.ChillingDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.FROST_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.ChillingCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.FROST;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
        }
        LivingEntity target = this.getTarget(caster);
        AABB aabb = caster.m_20191_().m_82400_(4.0);
        if (this.isShifting(caster) && target != null) {
            if (MobUtil.areAllies((Entity)target, (Entity)caster)) {
                target.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.CHILL_HIDE.get(), MathHelper.secondsToTicks(45 + duration), potency));
                aabb = target.m_20191_().m_82400_(4.0);
            }
        } else {
            caster.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.CHILL_HIDE.get(), MathHelper.secondsToTicks(45 + duration), potency));
        }
        if (this.rightStaff(staff)) {
            for (LivingEntity livingEntity : worldIn.m_45976_(LivingEntity.class, aabb)) {
                if (!MobUtil.areAllies((Entity)livingEntity, (Entity)caster) || livingEntity == caster) continue;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.CHILL_HIDE.get(), MathHelper.secondsToTicks(45 + duration), potency));
            }
        }
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.ICE_SPIKE_HIT.get(), 1.0f, 0.5f);
    }
}

