/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.frost;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.IceChunk;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class IceChunkSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.IceChunkCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.IceChunkDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.IceChunkCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.FROST;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        double radius = spellStat.getRadius();
        float potency = spellStat.getPotency();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            potency += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
        }
        HitResult rayTraceResult = this.rayTrace((Level)worldIn, caster, range, radius);
        LivingEntity target = this.getTarget(caster, range);
        if (target != null) {
            IceChunk iceChunkEntity = new IceChunk((Level)worldIn, caster, target);
            iceChunkEntity.setExtraDamage(potency);
            iceChunkEntity.setStaff(this.rightStaff(staff));
            worldIn.m_7967_((Entity)iceChunkEntity);
            this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.ICE_CHUNK_SUMMON.get());
        } else if (rayTraceResult instanceof BlockHitResult) {
            BlockPos blockPos = ((BlockHitResult)rayTraceResult).m_82425_();
            IceChunk iceChunkEntity = new IceChunk((Level)worldIn, caster, null);
            iceChunkEntity.setExtraDamage(potency);
            iceChunkEntity.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 4, (float)blockPos.m_123343_() + 0.5f);
            iceChunkEntity.setStaff(this.rightStaff(staff));
            worldIn.m_7967_((Entity)iceChunkEntity);
            this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.ICE_CHUNK_SUMMON.get());
        }
    }
}

