/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.frost;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.golem.IceGolem;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.SummonSpell;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class IceGolemSpell
extends SummonSpell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setDuration(1);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.FrostbornCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.FrostbornDuration.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.FrostbornSummonDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.FROST_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.FrostbornCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.FROST;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public Predicate<LivingEntity> summonPredicate() {
        return livingEntity -> livingEntity instanceof IceGolem;
    }

    @Override
    public int summonLimit() {
        return (Integer)SpellConfig.IceGolemLimit.get();
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        this.commonResult(worldIn, caster);
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster) + 1;
        }
        if (!this.isShifting(caster)) {
            int i = 1;
            if (this.rightStaff(staff)) {
                i += caster.m_217043_().m_188499_() ? 1 : 0;
            }
            for (int i1 = 0; i1 < i; ++i1) {
                IceGolem summonedentity = new IceGolem((EntityType<? extends Owned>)((EntityType)ModEntityType.ICE_GOLEM.get()), (Level)worldIn);
                summonedentity.setTrueOwner(caster);
                summonedentity.m_20035_(BlockFinder.SummonRadius(caster.m_20183_(), (Entity)summonedentity, (Level)worldIn), 0.0f, 0.0f);
                MobUtil.moveDownToGround((Entity)summonedentity);
                summonedentity.m_21530_();
                summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * duration);
                summonedentity.m_6518_((ServerLevelAccessor)worldIn, caster.f_19853_.m_6436_(caster.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                this.buffSummon(caster, (LivingEntity)summonedentity, potency);
                this.SummonSap(caster, (LivingEntity)summonedentity);
                this.setTarget(caster, (Mob)summonedentity);
                worldIn.m_7967_((Entity)summonedentity);
                this.summonAdvancement(caster, (LivingEntity)summonedentity);
            }
            this.SummonDown(caster);
            this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.SUMMON_SPELL.get());
        }
    }
}

