/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.geomancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BarricadeSpell
extends Spell {
    public int trueCooldown = this.defaultSpellCooldown();

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.BarricadeCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.BarricadeDuration.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.GEOMANCY;
    }

    @Override
    public SoundEvent CastingSound() {
        return SoundEvents.f_11867_;
    }

    @Override
    public int spellCooldown() {
        return this.trueCooldown;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.BarricadeCoolDown.get();
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        float chance = 0.05f;
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
        }
        if (this.rightStaff(staff)) {
            chance += 0.2f;
        }
        HitResult rayTraceResult = this.rayTrace((Level)worldIn, caster, range, 3.0);
        LivingEntity target = this.getTarget(caster, range);
        EntityType entityType = (EntityType)ModEntityType.TOTEMIC_WALL.get();
        if (this.typeStaff(staff, SpellType.FROST)) {
            entityType = (EntityType)ModEntityType.GLACIAL_WALL.get();
        }
        if (target != null) {
            if (this.isShifting(caster)) {
                if (worldIn.f_46441_.m_188501_() <= chance) {
                    WandUtil.summonQuadOffensiveTrap(caster, (Entity)target, (EntityType<? extends AbstractMonolith>)((EntityType)ModEntityType.TOTEMIC_BOMB.get()), potency);
                    this.trueCooldown += MathHelper.secondsToTicks(3);
                } else {
                    int xShift = worldIn.m_213780_().m_216339_(-1, 1);
                    int zShift = worldIn.m_213780_().m_216339_(-1, 1);
                    WandUtil.summonMonolith(caster, (Entity)target, (EntityType<? extends AbstractMonolith>)((EntityType)ModEntityType.TOTEMIC_BOMB.get()), (double)xShift, (double)zShift, potency);
                    this.trueCooldown += MathHelper.secondsToTicks(2);
                }
            } else {
                int random = worldIn.f_46441_.m_188503_(3);
                if (random == 0) {
                    int[] rowToRemove = (int[])Util.m_214670_((Object[])WandUtil.CONFIG_1_ROWS, (RandomSource)caster.m_217043_());
                    Direction direction = Direction.m_122364_((double)target.m_6080_());
                    switch (direction) {
                        case NORTH: {
                            rowToRemove = WandUtil.CONFIG_1_NORTH_ROW;
                            break;
                        }
                        case SOUTH: {
                            rowToRemove = WandUtil.CONFIG_1_SOUTH_ROW;
                            break;
                        }
                        case WEST: {
                            rowToRemove = WandUtil.CONFIG_1_WEST_ROW;
                            break;
                        }
                        case EAST: {
                            rowToRemove = WandUtil.CONFIG_1_EAST_ROW;
                        }
                    }
                    WandUtil.summonSquareTrap(caster, (Entity)target, (EntityType<? extends AbstractMonolith>)entityType, rowToRemove, duration);
                } else if (random == 1) {
                    WandUtil.summonWallTrap(caster, (Entity)target, (EntityType<? extends AbstractMonolith>)entityType, duration);
                } else {
                    WandUtil.summonRandomPillarsTrap(caster, (Entity)target, (EntityType<? extends AbstractMonolith>)entityType, duration);
                }
                this.trueCooldown = this.defaultSpellCooldown();
            }
        } else if (rayTraceResult instanceof BlockHitResult) {
            BlockPos blockPos = ((BlockHitResult)rayTraceResult).m_82425_();
            if (this.isShifting(caster)) {
                if (worldIn.f_46441_.m_188501_() <= chance) {
                    WandUtil.summonQuadOffensiveTrap(caster, blockPos, (EntityType<? extends AbstractMonolith>)((EntityType)ModEntityType.TOTEMIC_BOMB.get()), potency);
                    this.trueCooldown += MathHelper.secondsToTicks(3);
                } else {
                    WandUtil.summonMonolith(caster, blockPos, (EntityType<? extends AbstractMonolith>)((EntityType)ModEntityType.TOTEMIC_BOMB.get()), 0.0, 0.0, potency);
                    this.trueCooldown += MathHelper.secondsToTicks(2);
                }
            } else {
                WandUtil.summonWallTrap(caster, blockPos, (EntityType<? extends AbstractMonolith>)entityType, duration);
                this.trueCooldown = this.defaultSpellCooldown();
            }
        }
    }
}

