/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.geomancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.crafting.ModRecipeSerializer;
import com.Polarice3.Goety.common.crafting.PulverizeRecipe;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.BlockSpell;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PulverizeSpell
extends BlockSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.PulverizeCost.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.PulverizeCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.GEOMANCY;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public boolean rightBlock(ServerLevel worldIn, LivingEntity caster, BlockPos target, Direction direction) {
        BlockState blockState = worldIn.m_8055_(target);
        PulverizeRecipe pulverizeRecipe = worldIn.m_7465_().m_44013_((RecipeType)ModRecipeSerializer.PULVERIZE_TYPE.get()).stream().filter(pulverizeRecipe1 -> pulverizeRecipe1.ingredient.test(new ItemStack((ItemLike)blockState.m_60734_()))).findFirst().orElse(null);
        return pulverizeRecipe != null;
    }

    @Override
    public void blockResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, BlockPos target, Direction direction) {
        int radius = 0;
        if (WandUtil.enchantedFocus(caster)) {
            radius += WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
        }
        if (this.rightStaff(staff)) {
            ++radius;
        }
        if (radius > 0) {
            for (BlockPos blockPos : BlockFinder.multiBlockBreak(caster, target, radius, radius, radius)) {
                this.pulverize(worldIn, caster, blockPos);
            }
        } else {
            this.pulverize(worldIn, caster, target);
        }
    }

    public void pulverize(ServerLevel worldIn, LivingEntity caster, BlockPos target) {
        BlockState blockState = worldIn.m_8055_(target);
        PulverizeRecipe pulverizeRecipe = worldIn.m_7465_().m_44013_((RecipeType)ModRecipeSerializer.PULVERIZE_TYPE.get()).stream().filter(pulverizeRecipe1 -> pulverizeRecipe1.ingredient.test(new ItemStack((ItemLike)blockState.m_60734_()))).findFirst().orElse(null);
        if (pulverizeRecipe != null) {
            worldIn.m_46796_(2001, target, Block.m_49956_((BlockState)worldIn.m_8055_(target)));
            BlockState pulverized = Blocks.f_50627_.m_49966_();
            if (pulverizeRecipe.getBlockResult() != Blocks.f_50627_) {
                pulverized = pulverizeRecipe.getBlockResult().m_152465_(blockState);
            }
            if (pulverizeRecipe.m_8043_(worldIn.m_9598_()) != null) {
                for (int i = 0; i < pulverizeRecipe.m_8043_(worldIn.m_9598_()).m_41777_().m_41613_(); ++i) {
                    ItemHelper.addItemEntity((Level)worldIn, target, new ItemStack((ItemLike)pulverizeRecipe.m_8043_(worldIn.m_9598_()).m_41720_()));
                }
            }
            worldIn.m_46597_(target, pulverized);
        }
    }
}

