/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.necromancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.SoundUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class IceBouquetSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.GhostFireCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.GhostFireDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.GhostFireCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NECROMANCY;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
        }
        HitResult rayTraceResult = this.rayTrace((Level)worldIn, caster, range, 3.0);
        LivingEntity target = this.getTarget(caster, range);
        Vec3 vec3 = null;
        if (target != null) {
            vec3 = target.m_20182_();
        } else if (rayTraceResult instanceof BlockHitResult) {
            BlockHitResult result = (BlockHitResult)rayTraceResult;
            vec3 = result.m_82450_();
        }
        if (vec3 != null) {
            if (this.rightStaff(staff)) {
                if (worldIn.f_46441_.m_188501_() <= 0.05f) {
                    WandUtil.spawnCrossIceBouquet((Level)worldIn, vec3, caster, potency, MathHelper.secondsToTicks(duration));
                } else {
                    WandUtil.spawnIceBouquet((Level)worldIn, vec3, caster, potency, MathHelper.secondsToTicks(duration));
                }
            } else {
                WandUtil.spawn4x4IceBouquet((Level)worldIn, vec3, caster, potency, MathHelper.secondsToTicks(duration));
            }
            SoundUtil.playNecromancerSummon((Entity)caster);
        }
    }
}

