/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.necromancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.undead.PhantomServant;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.SummonSpell;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SoundUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class PhantomSpell
extends SummonSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.PhantomCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.PhantomDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.PhantomCoolDown.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.PhantomSummonDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NECROMANCY;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public Predicate<LivingEntity> summonPredicate() {
        return livingEntity -> livingEntity instanceof PhantomServant;
    }

    @Override
    public int summonLimit() {
        return (Integer)SpellConfig.PhantomLimit.get();
    }

    @Override
    public void commonResultHit(ServerLevel worldIn, LivingEntity caster) {
        for (int i = 0; i < caster.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
            worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123759_, caster.m_20185_(), caster.m_20188_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        this.playSound(worldIn, (Entity)caster, SoundEvents.f_11862_);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        this.commonResult(worldIn, caster);
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster) + 1;
        }
        if (!this.isShifting(caster)) {
            SpawnGroupData spawngroupdata = null;
            int l = 1;
            if (this.rightStaff(staff)) {
                l += caster.m_217043_().m_188503_(4);
            }
            for (int i1 = 0; i1 < l; ++i1) {
                PhantomServant phantom = (PhantomServant)((EntityType)ModEntityType.PHANTOM_SERVANT.get()).m_20615_((Level)worldIn);
                if (phantom == null) continue;
                BlockPos.MutableBlockPos blockpos$mutable = BlockFinder.SummonFlyingRadius(caster.m_20183_(), (LivingEntity)phantom, (Level)worldIn, 15).m_122032_();
                while ((double)blockpos$mutable.m_123342_() < caster.m_20186_() + 20.0 + (double)caster.m_217043_().m_188503_(15) && !worldIn.m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
                    blockpos$mutable.m_122173_(Direction.UP);
                }
                DifficultyInstance difficultyinstance = worldIn.m_6436_((BlockPos)blockpos$mutable);
                phantom.setTrueOwner(caster);
                phantom.m_20035_((BlockPos)blockpos$mutable, 0.0f, 0.0f);
                spawngroupdata = phantom.m_6518_((ServerLevelAccessor)worldIn, difficultyinstance, MobSpawnType.MOB_SUMMONED, spawngroupdata, null);
                phantom.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * duration);
                if (potency > 0) {
                    phantom.setPhantomSize(potency);
                }
                this.SummonSap(caster, (LivingEntity)phantom);
                this.setTarget(caster, (Mob)phantom);
                worldIn.m_47205_((Entity)phantom);
                this.summonAdvancement(caster, (LivingEntity)phantom);
            }
            this.SummonDown(caster);
            SoundUtil.playNecromancerSummon((Entity)caster);
        }
    }
}

