/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wild;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.EntangleVines;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class EntanglingSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.EntanglingCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.EntanglingDuration.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WILD;
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.WILD_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.EntanglingDuration.get();
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
        }
        HitResult rayTraceResult = this.rayTrace((Level)worldIn, caster, range, 3.0);
        if (this.rightStaff(staff)) {
            int i = (int)caster.m_20185_();
            int j = (int)caster.m_20186_();
            int k = (int)caster.m_20189_();
            int amount = 0;
            List list = worldIn.m_45976_(LivingEntity.class, new AABB((double)i, (double)j, (double)k, (double)i, (double)(j - 4), (double)k).m_82400_(16.0));
            if (!list.isEmpty()) {
                for (LivingEntity entity : list) {
                    if (amount >= 8 || entity == caster || MobUtil.areAllies((Entity)entity, (Entity)caster)) continue;
                    EntangleVines entangleVines = new EntangleVines((Level)worldIn, caster, (Entity)entity);
                    entangleVines.setLifeSpan(entangleVines.getLifeSpan() + MathHelper.secondsToTicks(duration));
                    if (CuriosFinder.hasWildRobe(caster)) {
                        entangleVines.setDamaging(true);
                    }
                    if (!worldIn.m_7967_((Entity)entangleVines)) continue;
                    ++amount;
                }
            } else if (rayTraceResult instanceof BlockHitResult) {
                BlockPos blockPos = ((BlockHitResult)rayTraceResult).m_82425_();
                EntangleVines entangleVines = new EntangleVines((Level)worldIn, caster, blockPos);
                entangleVines.setLifeSpan(entangleVines.getLifeSpan() + MathHelper.secondsToTicks(duration));
                worldIn.m_7967_((Entity)entangleVines);
            }
        } else {
            LivingEntity target = this.getTarget(caster, range);
            if (target != null) {
                EntangleVines entangleVines = new EntangleVines((Level)worldIn, caster, (Entity)target);
                entangleVines.setLifeSpan(entangleVines.getLifeSpan() + MathHelper.secondsToTicks(duration));
                if (CuriosFinder.hasWildRobe(caster)) {
                    entangleVines.setDamaging(true);
                }
                worldIn.m_7967_((Entity)entangleVines);
            } else if (rayTraceResult instanceof BlockHitResult) {
                BlockPos blockPos = ((BlockHitResult)rayTraceResult).m_82425_();
                EntangleVines entangleVines = new EntangleVines((Level)worldIn, caster, blockPos);
                entangleVines.setLifeSpan(entangleVines.getLifeSpan() + MathHelper.secondsToTicks(duration));
                worldIn.m_7967_((Entity)entangleVines);
            }
        }
    }
}

