/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wild;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.PoisonQuill;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class PoisonDartSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setVelocity(1.6f);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.PoisonDartCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.PoisonDartDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.WILD_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.PoisonDartCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WILD;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        float velocity = spellStat.getVelocity();
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            velocity += (float)WandUtil.getLevels((Enchantment)ModEnchantments.VELOCITY.get(), caster) / 3.0f;
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
        }
        PoisonQuill poisonQuill = new PoisonQuill((Level)worldIn, caster);
        poisonQuill.setSpear(this.rightStaff(staff), potency);
        poisonQuill.m_37251_((Entity)caster, caster.m_146909_(), caster.m_146908_(), 0.0f, velocity, 1.0f);
        poisonQuill.m_5602_((Entity)caster);
        poisonQuill.setExtraDamage(potency);
        poisonQuill.setDuration(duration);
        if (caster.m_5842_()) {
            poisonQuill.setAqua(true);
        }
        worldIn.m_7967_((Entity)poisonQuill);
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.POISON_QUILL_VINE_SHOOT.get(), 1.0f, this.projPitch(worldIn.m_213780_()));
    }
}

