/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.ritual;

import com.Polarice3.Goety.common.blocks.entities.DarkAltarBlockEntity;
import com.Polarice3.Goety.common.crafting.RitualRecipe;
import com.Polarice3.Goety.common.ritual.Ritual;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class EnchantItemRitual
extends Ritual {
    public EnchantItemRitual(RitualRecipe recipe) {
        super(recipe);
    }

    @Override
    public boolean isValid(Level world, BlockPos darkAltarPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, ItemStack activationItem, List<Ingredient> remainingAdditionalIngredients) {
        return this.recipe.getEnchantment() != null && (activationItem.canApplyAtEnchantingTable(this.recipe.getEnchantment()) || this.recipe.getEnchantment().m_6081_(activationItem) || activationItem.m_41720_() instanceof BookItem || activationItem.m_41720_() instanceof EnchantedBookItem) && this.compatibleEnchant(activationItem) && this.areAdditionalIngredientsFulfilled(world, darkAltarPos, castingPlayer, remainingAdditionalIngredients);
    }

    @Override
    public boolean identify(Level world, BlockPos darkAltarPos, Player player, ItemStack activationItem) {
        return this.recipe.getEnchantment() != null && this.areAdditionalIngredientsFulfilled(world, darkAltarPos, player, (List<Ingredient>)this.recipe.m_7527_());
    }

    public int getLevelCost(ItemStack activationItem) {
        Map map = EnchantmentHelper.m_44831_((ItemStack)activationItem);
        if (activationItem.m_41793_() && map.containsKey(this.recipe.getEnchantment())) {
            return this.recipe.getXPLevelCost() * ((Integer)map.get(this.recipe.getEnchantment()) + 1);
        }
        return this.recipe.getXPLevelCost();
    }

    public boolean compatibleEnchant(ItemStack activationItem) {
        Map map = EnchantmentHelper.m_44831_((ItemStack)activationItem);
        if (activationItem.m_41793_()) {
            return EnchantmentHelper.m_44859_(map.keySet(), (Enchantment)this.recipe.getEnchantment()) || activationItem.m_41720_() instanceof BookItem || activationItem.m_41720_() instanceof EnchantedBookItem || map.containsKey(this.recipe.getEnchantment());
        }
        return true;
    }

    @Override
    public void finish(Level world, BlockPos blockPos, DarkAltarBlockEntity tileEntity, Player castingPlayer, ItemStack activationItem) {
        super.finish(world, blockPos, tileEntity, castingPlayer, activationItem);
        for (int i = 0; i < 20; ++i) {
            double d0 = (double)blockPos.m_123341_() + world.f_46441_.m_188500_();
            double d1 = (double)blockPos.m_123342_() + world.f_46441_.m_188500_();
            double d2 = (double)blockPos.m_123343_() + world.f_46441_.m_188500_();
            world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
        Map map = EnchantmentHelper.m_44831_((ItemStack)activationItem);
        ItemStack result = activationItem;
        EnchantmentInstance enchantmentInstance = new EnchantmentInstance(this.recipe.getEnchantment(), 1);
        if (result.m_41720_() instanceof BookItem) {
            result = EnchantedBookItem.m_41161_((EnchantmentInstance)enchantmentInstance);
            activationItem.m_41774_(1);
            IItemHandler handler = (IItemHandler)tileEntity.itemStackHandler.orElseThrow(RuntimeException::new);
            handler.insertItem(0, result, false);
        } else if (map.containsKey(this.recipe.getEnchantment())) {
            for (Enchantment enchantment : map.keySet()) {
                if (enchantment == null || this.recipe.getEnchantment() != enchantment) continue;
                int j2 = (Integer)map.get(enchantment) + 1;
                if (j2 > enchantment.m_6586_()) {
                    j2 = enchantment.m_6586_();
                }
                map.put(enchantment, j2);
                EnchantmentHelper.m_44865_((Map)map, (ItemStack)result);
            }
        } else if (result.m_41720_() instanceof EnchantedBookItem) {
            EnchantedBookItem.m_41153_((ItemStack)result, (EnchantmentInstance)enchantmentInstance);
        } else {
            result.m_41663_(this.recipe.getEnchantment(), 1);
        }
        result.m_41678_(world, castingPlayer, 1);
    }
}

