/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.ritual;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.entities.RitualBlockEntity;
import com.Polarice3.Goety.common.ritual.Ritual;
import com.Polarice3.Goety.common.ritual.RitualTypes;
import com.Polarice3.Goety.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LavaCauldronBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.SculkBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SmithingTableBlock;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class RitualRequirements
extends RitualTypes {
    public static final int RANGE = Ritual.RANGE;

    public static boolean noConvertEntity(TagKey<EntityType<?>> entityType, BlockPos pPos, Level pLevel) {
        return RitualRequirements.getConvertEntity(entityType, pPos, pLevel) == null;
    }

    public static Mob getConvertEntity(TagKey<EntityType<?>> entityType, BlockPos pPos, Level pLevel) {
        for (Mob mob : pLevel.m_45976_(Mob.class, new AABB(pPos).m_82400_((double)RANGE))) {
            if (!mob.m_6095_().m_204039_(entityType)) continue;
            return mob;
        }
        return null;
    }

    public static boolean canSummon(Level level, Player castingPlayer, EntityType<?> summonType) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity summon = summonType.m_20615_(level);
            if (summon instanceof IOwned) {
                IOwned owned = (IOwned)summon;
                int count = 0;
                for (ServerLevel serverLevel1 : serverLevel.m_7654_().m_129785_()) {
                    for (Entity entity : serverLevel1.m_8583_()) {
                        if (!(entity instanceof IOwned)) continue;
                        IOwned servant = (IOwned)entity;
                        if (!owned.summonPredicate().test(entity) || servant.getTrueOwner() != castingPlayer) continue;
                        ++count;
                    }
                }
                if (count >= owned.getSummonLimit((LivingEntity)castingPlayer)) {
                    castingPlayer.m_5661_((Component)Component.m_237115_((String)"info.goety.summon.limit"), true);
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    public static boolean getProperStructure(String craftType, RitualBlockEntity pTileEntity, BlockPos pPos, Level pLevel) {
        return switch (craftType) {
            case "animation", "forge", "magic", "sabbath" -> RitualRequirements.getStructures(craftType, pPos, pLevel);
            case "geoturgy" -> RitualRequirements.geoturgyRitual(pPos, pLevel);
            case "necroturgy" -> {
                if (RitualRequirements.getStructures(craftType, pPos, pLevel) && pLevel.m_7445_() >= 4 && pLevel.m_6042_().f_223549_()) {
                    yield true;
                }
                yield false;
            }
            case "adept_nether", "expert_nether" -> {
                if (RitualRequirements.getStructures(craftType, pPos, pLevel) && (pLevel.m_6042_().f_63857_() || pLevel.m_204166_(pPos).m_203656_(BiomeTags.f_207612_))) {
                    yield true;
                }
                yield false;
            }
            case "end" -> {
                if (RitualRequirements.getStructures(craftType, pPos, pLevel) && (pLevel.m_46472_() == Level.f_46430_ || pLevel.m_204166_(pPos).m_203656_(BiomeTags.f_215818_))) {
                    yield true;
                }
                yield false;
            }
            case "frost" -> RitualRequirements.frostRitual(pPos, pLevel);
            case "sky" -> RitualRequirements.skyRitual(pTileEntity, pLevel, pPos);
            case "storm" -> {
                if (RitualRequirements.getStructures(craftType, pPos, pLevel) && RitualRequirements.skyRitual(pTileEntity, pLevel, pPos) && pLevel.m_46470_() && pLevel.m_45527_(pPos.m_7494_())) {
                    yield true;
                }
                yield false;
            }
            case "deep" -> RitualRequirements.deepRitual(pTileEntity, pLevel, pPos);
            default -> false;
        };
    }

    public static boolean geoturgyRitual(BlockPos pPos, Level pLevel) {
        return !pLevel.m_45527_(pPos) && pPos.m_123342_() <= 32 || RitualRequirements.getStructures("geoturgy", pPos, pLevel);
    }

    public static boolean frostRitual(BlockPos pPos, Level pLevel) {
        return ((Biome)pLevel.m_204166_(pPos).get()).m_198904_(pPos) || RitualRequirements.getStructures("frost", pPos, pLevel);
    }

    public static boolean skyRitual(RitualBlockEntity pTileEntity, Level pLevel, BlockPos pPos) {
        return pPos.m_123342_() >= 128 || pLevel.m_46472_().m_135782_().toString().contains("aether") || RitualRequirements.getStructures("sky", pPos, pTileEntity.m_58904_());
    }

    public static boolean deepRitual(RitualBlockEntity pTileEntity, Level pLevel, BlockPos pPos) {
        return (pPos.m_123342_() <= pLevel.m_5736_() && pLevel.m_204166_(pPos).m_203656_(BiomeTags.f_207602_) || RitualRequirements.getStructures("deep", pPos, pTileEntity.m_58904_())) && pTileEntity.m_58900_().m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)pTileEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61362_) != false;
    }

    public static boolean getStructures(String craftType, BlockPos pPos, Level pLevel) {
        int firstCount = 0;
        int secondCount = 0;
        int thirdCount = 0;
        int totalFirst = 0;
        int totalSecond = 0;
        int totalThird = 0;
        for (int i = -RANGE; i <= RANGE; ++i) {
            for (int j = -RANGE; j <= RANGE; ++j) {
                block32: for (int k = -RANGE; k <= RANGE; ++k) {
                    BlockPos blockpos1 = pPos.m_7918_(i, j, k);
                    BlockState blockstate = pLevel.m_8055_(blockpos1);
                    switch (craftType) {
                        case "animation": {
                            totalFirst = 15;
                            totalSecond = 15;
                            totalThird = 1;
                            if (blockstate.m_60734_() instanceof LadderBlock || blockstate.m_60734_().m_7705_().contains("ladder")) {
                                ++firstCount;
                            }
                            if (blockstate.m_60734_() instanceof BaseRailBlock) {
                                ++secondCount;
                            }
                            if (!(blockstate.m_60734_() instanceof CarvedPumpkinBlock)) continue block32;
                            ++thirdCount;
                            continue block32;
                        }
                        case "necroturgy": {
                            FlowerPotBlock flowerPotBlock;
                            Block block;
                            totalFirst = 16;
                            totalSecond = 16;
                            totalThird = 8;
                            if (blockstate.m_60734_() instanceof SculkBlock) {
                                ++firstCount;
                            }
                            if (blockstate.m_60734_() instanceof SlabBlock) {
                                ++secondCount;
                            }
                            if (!((block = blockstate.m_60734_()) instanceof FlowerPotBlock) || (flowerPotBlock = (FlowerPotBlock)block).m_53560_() == Blocks.f_50016_) continue block32;
                            ++thirdCount;
                            continue block32;
                        }
                        case "forge": {
                            totalFirst = 1;
                            totalSecond = 2;
                            totalThird = 1;
                            if (blockstate.m_60734_() instanceof LavaCauldronBlock) {
                                ++firstCount;
                            }
                            if (blockstate.m_60734_() instanceof FurnaceBlock || blockstate.m_60734_() instanceof BlastFurnaceBlock) {
                                ++secondCount;
                            }
                            if (!blockstate.m_60734_().m_7705_().contains("anvil")) continue block32;
                            ++thirdCount;
                            continue block32;
                        }
                        case "geoturgy": {
                            totalFirst = 8;
                            totalSecond = 1;
                            totalThird = 16;
                            if (blockstate.m_60734_() instanceof AmethystBlock) {
                                ++firstCount;
                            }
                            if (blockstate.m_60734_() instanceof SmithingTableBlock) {
                                ++secondCount;
                            }
                            if (!blockstate.m_60734_().m_7705_().contains("deepslate") || !blockstate.m_60804_((BlockGetter)pLevel, blockpos1)) continue block32;
                            ++thirdCount;
                            continue block32;
                        }
                        case "magic": {
                            LecternBlockEntity lecternTileEntity;
                            Block block;
                            totalFirst = 16;
                            totalSecond = 1;
                            totalThird = 1;
                            if (blockstate.getEnchantPowerBonus((LevelReader)pLevel, blockpos1) > 0.0f) {
                                firstCount += (int)blockstate.getEnchantPowerBonus((LevelReader)pLevel, blockpos1);
                            }
                            if (blockstate.m_60734_() instanceof LecternBlock && blockstate.m_155947_() && (block = pLevel.m_7702_(blockpos1)) instanceof LecternBlockEntity && !(lecternTileEntity = (LecternBlockEntity)block).m_59566_().m_41619_()) {
                                ++secondCount;
                            }
                            if (!(blockstate.m_60734_() instanceof EnchantmentTableBlock)) continue block32;
                            ++thirdCount;
                            continue block32;
                        }
                        case "sabbath": {
                            totalFirst = 8;
                            totalSecond = 16;
                            totalThird = 4;
                            if (blockstate.m_60734_() == Blocks.f_50723_) {
                                ++firstCount;
                            }
                            if (blockstate.m_60734_() == Blocks.f_50080_) {
                                ++secondCount;
                            }
                            if (blockstate.m_60734_() != Blocks.f_50084_) continue block32;
                            ++thirdCount;
                            continue block32;
                        }
                        case "adept_nether": {
                            totalFirst = 8;
                            totalSecond = 16;
                            totalThird = 4;
                            if (blockstate.m_60734_().m_7705_().contains("basalt")) {
                                ++firstCount;
                            }
                            if (blockstate.m_60734_().m_7705_().contains("blackstone")) {
                                ++secondCount;
                            }
                            if (blockstate.m_60734_() != Blocks.f_50141_) continue block32;
                            ++thirdCount;
                            continue block32;
                        }
                        case "expert_nether": {
                            totalFirst = 4;
                            totalSecond = 32;
                            totalThird = 8;
                            if (blockstate.m_60734_() == Blocks.f_50312_ || blockstate.m_60734_() == Blocks.f_50313_) {
                                ++firstCount;
                            }
                            if (blockstate.m_60734_() == Blocks.f_50197_ || blockstate.m_60734_() == Blocks.f_50452_) {
                                ++secondCount;
                            }
                            if (blockstate.m_60734_() != Blocks.f_50200_) continue block32;
                            ++thirdCount;
                            continue block32;
                        }
                        case "end": {
                            totalFirst = 16;
                            totalSecond = 64;
                            totalThird = 32;
                            if (blockstate.m_60734_() == ModBlocks.VOID_BLOCK.get()) {
                                ++firstCount;
                            }
                            if (blockstate.m_204336_(ModTags.Blocks.END_STONE) || blockstate.m_60713_(Blocks.f_50443_)) {
                                ++secondCount;
                            }
                            if (!blockstate.m_60734_().m_7705_().contains("purpur")) continue block32;
                            ++thirdCount;
                            continue block32;
                        }
                        case "frost": {
                            totalFirst = 16;
                            totalSecond = 8;
                            totalThird = 4;
                            if (blockstate.m_204336_(BlockTags.f_13047_)) {
                                ++firstCount;
                            }
                            if (blockstate.m_204336_(BlockTags.f_144279_)) {
                                ++secondCount;
                            }
                            if (!blockstate.m_60713_((Block)ModBlocks.FREEZING_LAMP.get())) continue block32;
                            ++thirdCount;
                            continue block32;
                        }
                        case "sky": {
                            totalFirst = 8;
                            totalSecond = 16;
                            totalThird = 4;
                            if (blockstate.m_204336_(ModTags.Blocks.MARBLE_BLOCKS)) {
                                ++firstCount;
                            }
                            if (blockstate.m_204336_(ModTags.Blocks.JADE_BLOCKS)) {
                                ++secondCount;
                            }
                            if (!blockstate.m_204336_(ModTags.Blocks.INDENTED_GOLD_BLOCKS)) continue block32;
                            ++thirdCount;
                            continue block32;
                        }
                        case "storm": {
                            totalFirst = 12;
                            totalSecond = 4;
                            totalThird = 20;
                            if (blockstate.m_60734_().m_7705_().contains("copper")) {
                                ++firstCount;
                            }
                            if (blockstate.m_60734_() instanceof LightningRodBlock) {
                                ++secondCount;
                            }
                            if (!(blockstate.m_60734_() instanceof ChainBlock)) continue block32;
                            ++thirdCount;
                            continue block32;
                        }
                        case "deep": {
                            totalFirst = 4;
                            totalSecond = 16;
                            totalThird = 16;
                            if (blockstate.m_60713_(Blocks.f_50386_)) {
                                ++firstCount;
                            }
                            if (blockstate.m_60734_().m_7705_().contains("prismarine")) {
                                ++secondCount;
                            }
                            if (!blockstate.m_60734_().m_7705_().contains("granite")) continue block32;
                            ++thirdCount;
                        }
                    }
                }
            }
        }
        return firstCount >= totalFirst && secondCount >= totalSecond && thirdCount >= totalThird;
    }
}

