/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.compat.jei;

import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.compat.jei.JeiRecipeTypes;
import com.Polarice3.Goety.compat.jei.WitchBrewJeiRecipe;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class WitchBrewCategory
implements IRecipeCategory<WitchBrewJeiRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String inputSlotName = "inputSlot";
    private final String catalystSlotName = "catalystSlot";
    private final String outputSlotName = "outputSlot";

    public WitchBrewCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(125, 60);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.BREWING_CAULDRON.get()));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<WitchBrewJeiRecipe> getRecipeType() {
        return JeiRecipeTypes.BREWING;
    }

    public Component getTitle() {
        return ((Block)ModBlocks.BREWING_CAULDRON.get()).m_49954_();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WitchBrewJeiRecipe recipe, IFocusGroup focuses) {
        int y = 20;
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, y).addItemStack(new ItemStack((ItemLike)Items.f_42590_))).setSlotName("inputSlot");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 36, y).addItemStack(new ItemStack((ItemLike)Items.f_42588_))).setSlotName("catalystSlot");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 72, y).addItemStack(recipe.getCatalyst())).setSlotName("catalystSlot");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 108, y).addItemStack(recipe.getOutput())).setSlotName("outputSlot");
    }

    public void draw(@NotNull WitchBrewJeiRecipe recipe, IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        Optional rightStack = recipeSlotsView.findSlotByName("catalystSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        Optional outputStack = recipeSlotsView.findSlotByName("outputSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        if (rightStack.isEmpty() || outputStack.isEmpty()) {
            return;
        }
        if (recipe.getCapacity() != 0) {
            this.drawStringCentered(graphics, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.capacityUse", (Object[])new Object[]{recipe.getCapacity()}), 63, 0);
        }
        if (recipe.getSoulCost() != 0) {
            this.drawStringCentered(graphics, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.single.soulcost", (Object[])new Object[]{recipe.getSoulCost()}), 63, 9);
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.getWidth() / 1.5f - 14.0f, (float)this.getHeight() / 2.0f + 8.0f, 0.0f);
        graphics.m_280168_().m_85841_(1.4f, 1.4f, 1.4f);
        this.icon.draw(graphics);
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.getWidth() / 3.0f - 8.4f, (float)this.getHeight() / 2.0f + 8.0f, 0.0f);
        graphics.m_280168_().m_85841_(1.4f, 1.4f, 1.4f);
        this.icon.draw(graphics);
        graphics.m_280168_().m_85849_();
    }

    protected void drawStringCentered(GuiGraphics matrixStack, Font fontRenderer, String text, int x, int y) {
        matrixStack.m_280056_(fontRenderer, text, (int)((float)x - (float)fontRenderer.m_92895_(text) / 2.0f), y, 0, false);
    }
}

