/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.common.network.EntityUpdatePacket;
import com.Polarice3.Goety.common.network.ModNetwork;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class EntityFinder {
    public static Optional<ServerPlayer> getPlayerByUuiDGlobal(UUID uuid) {
        for (ServerLevel world : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            ServerPlayer player = (ServerPlayer)world.m_46003_(uuid);
            if (player == null) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public static Optional<? extends Entity> getEntityByUuiDGlobal(UUID uuid) {
        return EntityFinder.getEntityByUuiDGlobal(ServerLifecycleHooks.getCurrentServer(), uuid);
    }

    public static Optional<? extends Entity> getEntityByUuiDGlobal(MinecraftServer server, UUID uuid) {
        if (uuid != null && server != null) {
            for (ServerLevel world : server.m_129785_()) {
                Entity entity = world.m_8791_(uuid);
                if (entity == null) continue;
                return Optional.of(entity);
            }
        }
        return Optional.empty();
    }

    public static Player getServerPlayersByUuiD(UUID uuid) {
        return EntityFinder.getServerPlayersByUuiD(ServerLifecycleHooks.getCurrentServer(), uuid);
    }

    public static Player getServerPlayersByUuiD(MinecraftServer server, UUID uuid) {
        Iterator iterator;
        if (uuid != null && server != null && (iterator = server.m_129785_().iterator()).hasNext()) {
            ServerLevel world = (ServerLevel)iterator.next();
            return world.m_46003_(uuid);
        }
        return null;
    }

    @Nullable
    public static Entity getEntityByUuiD(Level level, UUID uuid) {
        return EntityFinder.getEntityByUuiD(level.m_7654_(), uuid);
    }

    @Nullable
    public static Entity getEntityByUuiD(UUID uuid) {
        return EntityFinder.getEntityByUuiD(ServerLifecycleHooks.getCurrentServer(), uuid);
    }

    @Nullable
    public static Entity getEntityByUuiD(MinecraftServer server, UUID uuid) {
        Iterator iterator;
        if (uuid != null && server != null && (iterator = server.m_129785_().iterator()).hasNext()) {
            ServerLevel world = (ServerLevel)iterator.next();
            return world.m_8791_(uuid);
        }
        return null;
    }

    public static LivingEntity getLivingEntityByUuiD(Level level, UUID uuid) {
        return EntityFinder.getLivingEntityByUuiD(level.m_7654_(), uuid);
    }

    public static LivingEntity getLivingEntityByUuiD(UUID uuid) {
        return EntityFinder.getLivingEntityByUuiD(ServerLifecycleHooks.getCurrentServer(), uuid);
    }

    public static LivingEntity getLivingEntityByUuiD(MinecraftServer server, UUID uuid) {
        if (uuid != null && server != null) {
            for (ServerLevel world : server.m_129785_()) {
                Entity entity = world.m_8791_(uuid);
                if (!(entity instanceof LivingEntity)) continue;
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    public static Player getNearbyPlayer(Level world, BlockPos blockPos) {
        Iterator iterator = world.m_45976_(Player.class, new AABB(blockPos).m_82400_(256.0)).iterator();
        if (iterator.hasNext()) {
            Player player = (Player)iterator.next();
            return player;
        }
        return null;
    }

    public static void sendEntityUpdatePacket(Player player, LivingEntity livingEntity) {
        ModNetwork.sendTo(player, new EntityUpdatePacket(livingEntity.m_20148_(), livingEntity.getPersistentData()));
    }

    public static void sendEntityUpdatePacket(LivingEntity livingEntity) {
        ModNetwork.sendToALL(new EntityUpdatePacket(livingEntity.m_20148_(), livingEntity.getPersistentData()));
    }
}

