/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.NoKnockBackDamageSource;
import com.Polarice3.Goety.utils.OwnedDamageSource;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ModDamageSource
extends DamageSource {
    public static ResourceKey<DamageType> SUMMON = ModDamageSource.create("summon");
    public static ResourceKey<DamageType> SHOCK = ModDamageSource.create("shock");
    public static ResourceKey<DamageType> DIRECT_SHOCK = ModDamageSource.create("direct_shock");
    public static ResourceKey<DamageType> INDIRECT_SHOCK = ModDamageSource.create("indirect_shock");
    public static ResourceKey<DamageType> LIGHTNING = ModDamageSource.create("lightning");
    public static ResourceKey<DamageType> DIRECT_FREEZE = ModDamageSource.create("direct_freeze");
    public static ResourceKey<DamageType> INDIRECT_FREEZE = ModDamageSource.create("indirect_freeze");
    public static ResourceKey<DamageType> ICE_SPIKE = ModDamageSource.create("ice_spike");
    public static ResourceKey<DamageType> DRENCH = ModDamageSource.create("drench");
    public static ResourceKey<DamageType> DIRECT_DRENCH = ModDamageSource.create("direct_drench");
    public static ResourceKey<DamageType> INDIRECT_DRENCH = ModDamageSource.create("indirect_drench");
    public static ResourceKey<DamageType> SWORD = ModDamageSource.create("sword");
    public static ResourceKey<DamageType> WIND_BLAST = ModDamageSource.create("wind_blast");
    public static ResourceKey<DamageType> ICE_BOUQUET = ModDamageSource.create("ice_bouquet");
    public static ResourceKey<DamageType> HELLFIRE = ModDamageSource.create("hellfire");
    public static ResourceKey<DamageType> INDIRECT_HELLFIRE = ModDamageSource.create("indirect_hellfire");
    public static ResourceKey<DamageType> MAGIC_FIRE = ModDamageSource.create("magic_fire");
    public static ResourceKey<DamageType> MAGIC_FIREBALL = ModDamageSource.create("magic_fireball");
    public static ResourceKey<DamageType> NO_OWNER_MAGIC_FIREBALL = ModDamageSource.create("no_owner_magic_fireball");
    public static ResourceKey<DamageType> LOOT_EXPLODE = ModDamageSource.create("loot_explode");
    public static ResourceKey<DamageType> LOOT_EXPLODE_OWNED = ModDamageSource.create("loot_explode_owned");
    public static ResourceKey<DamageType> FIRE_BREATH = ModDamageSource.create("fire_breath");
    public static ResourceKey<DamageType> FROST_BREATH = ModDamageSource.create("frost_breath");
    public static ResourceKey<DamageType> BUBBLE_STREAM = ModDamageSource.create("bubble_stream");
    public static ResourceKey<DamageType> MAGIC_BOLT = ModDamageSource.create("magic_bolt");
    public static ResourceKey<DamageType> SOUL_LEECH = ModDamageSource.create("soul_leech");
    public static ResourceKey<DamageType> LIFE_LEECH = ModDamageSource.create("life_leech");
    public static ResourceKey<DamageType> ACID = ModDamageSource.create("acid");
    public static ResourceKey<DamageType> SPIKE = ModDamageSource.create("spike");
    public static ResourceKey<DamageType> BOILING = ModDamageSource.create("boiling");
    public static ResourceKey<DamageType> PHOBIA = ModDamageSource.create("phobia");
    public static ResourceKey<DamageType> CHOKE = ModDamageSource.create("choke");
    public static ResourceKey<DamageType> SWARM = ModDamageSource.create("swarm");
    public static ResourceKey<DamageType> VOIDED = ModDamageSource.create("voided");
    public static ResourceKey<DamageType> DOOM = ModDamageSource.create("doom");
    public static ResourceKey<DamageType> DEATH = ModDamageSource.create("death");

    public ModDamageSource(Holder<DamageType> p_270906_, @Nullable Entity p_270796_, @Nullable Entity p_270459_, @Nullable Vec3 p_270623_) {
        super(p_270906_, p_270796_, p_270459_, p_270623_);
    }

    public static ResourceKey<DamageType> create(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)Goety.location(name));
    }

    public static DamageSource getDamageSource(Level level, ResourceKey<DamageType> type, EntityType<?> ... toIgnore) {
        return ModDamageSource.getEntityDamageSource(level, type, null, toIgnore);
    }

    public static DamageSource entityDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, EntityType<?> ... toIgnore) {
        return ModDamageSource.getEntityDamageSource(level, type, attacker, new EntityType[0]);
    }

    public static DamageSource getEntityDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, EntityType<?> ... toIgnore) {
        return ModDamageSource.getIndirectEntityDamageSource(level, type, attacker, attacker, toIgnore);
    }

    public static DamageSource indirectEntityDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, @Nullable Entity indirectAttacker) {
        return ModDamageSource.getIndirectEntityDamageSource(level, type, attacker, indirectAttacker, new EntityType[0]);
    }

    public static DamageSource getIndirectEntityDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, @Nullable Entity indirectAttacker, EntityType<?> ... toIgnore) {
        return toIgnore.length > 0 ? new EntityExcludedDamageSource((Holder<DamageType>)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(type), toIgnore) : ModDamageSource.source(level, type, attacker, indirectAttacker);
    }

    public static DamageSource source(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, @Nullable Entity indirectAttacker) {
        return new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(type), attacker, indirectAttacker);
    }

    public static DamageSource noKnockbackDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, @Nullable Entity indirectAttacker, EntityType<?> ... toIgnore) {
        return new NoKnockBackDamageSource((Holder<DamageType>)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(type), attacker, indirectAttacker);
    }

    public static DamageSource ownedDamageSource(Level level, ResourceKey<DamageType> type, Entity attacker, LivingEntity owned) {
        return new OwnedDamageSource((Holder<DamageType>)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(type), attacker, owned);
    }

    public static DamageSource summonAttack(LivingEntity owned, LivingEntity owner) {
        return ModDamageSource.ownedDamageSource(owned.f_19853_, SUMMON, (Entity)owned, owner);
    }

    public static DamageSource directShock(LivingEntity pMob) {
        return ModDamageSource.entityDamageSource(pMob.f_19853_, DIRECT_SHOCK, (Entity)pMob, new EntityType[0]);
    }

    public static DamageSource indirectShock(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.indirectEntityDamageSource(pSource.f_19853_, INDIRECT_SHOCK, pSource, pIndirectEntity);
    }

    public static DamageSource lightning(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.indirectEntityDamageSource(pSource.f_19853_, LIGHTNING, pSource, pIndirectEntity);
    }

    public static DamageSource directFreeze(LivingEntity pMob) {
        return ModDamageSource.entityDamageSource(pMob.f_19853_, DIRECT_FREEZE, (Entity)pMob, new EntityType[0]);
    }

    public static DamageSource indirectFreeze(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.indirectEntityDamageSource(pSource.f_19853_, INDIRECT_FREEZE, pSource, pIndirectEntity);
    }

    public static DamageSource iceSpike(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.indirectEntityDamageSource(pSource.f_19853_, ICE_SPIKE, pSource, pIndirectEntity);
    }

    public static DamageSource directDrench(LivingEntity pMob) {
        return ModDamageSource.entityDamageSource(pMob.f_19853_, DIRECT_DRENCH, (Entity)pMob, new EntityType[0]);
    }

    public static DamageSource indirectDrench(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.indirectEntityDamageSource(pSource.f_19853_, INDIRECT_DRENCH, pSource, pIndirectEntity);
    }

    public static DamageSource modFireball(@Nullable Entity pIndirectEntity, Level world) {
        LargeFireball fireball = new LargeFireball(EntityType.f_20463_, world);
        return pIndirectEntity == null ? ModDamageSource.indirectEntityDamageSource(world, (ResourceKey<DamageType>)DamageTypes.f_268684_, (Entity)fireball, (Entity)fireball) : ModDamageSource.indirectEntityDamageSource(world, (ResourceKey<DamageType>)DamageTypes.f_268684_, (Entity)fireball, pIndirectEntity);
    }

    public static DamageSource magicFireball(Fireball p_270147_, @Nullable Entity pIndirectEntity, Level world) {
        return pIndirectEntity == null ? ModDamageSource.indirectEntityDamageSource(world, NO_OWNER_MAGIC_FIREBALL, (Entity)p_270147_, null) : ModDamageSource.indirectEntityDamageSource(world, MAGIC_FIREBALL, (Entity)p_270147_, pIndirectEntity);
    }

    public static DamageSource lootExplosion(@Nullable Entity pSource, @Nullable Entity pIndirectEntity, Level world) {
        return ModDamageSource.source(world, pIndirectEntity != null && pSource != null ? LOOT_EXPLODE_OWNED : LOOT_EXPLODE, pSource, pIndirectEntity);
    }

    public static DamageSource sword(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.indirectEntityDamageSource(pSource.f_19853_, SWORD, pSource, pIndirectEntity);
    }

    public static DamageSource iceBouquet(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.noKnockbackDamageSource(pSource.f_19853_, ICE_BOUQUET, pSource, pIndirectEntity, new EntityType[0]);
    }

    public static DamageSource hellfire(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.noKnockbackDamageSource(pSource.f_19853_, HELLFIRE, pSource, pIndirectEntity, new EntityType[0]);
    }

    public static DamageSource fireBreath(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.noKnockbackDamageSource(pSource.f_19853_, FIRE_BREATH, pSource, pIndirectEntity, new EntityType[0]);
    }

    public static DamageSource magicFireBreath(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.noKnockbackDamageSource(pSource.f_19853_, MAGIC_FIRE, pSource, pIndirectEntity, new EntityType[0]);
    }

    public static DamageSource frostBreath(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.noKnockbackDamageSource(pSource.f_19853_, FROST_BREATH, pSource, pIndirectEntity, new EntityType[0]);
    }

    public static DamageSource bubbleStream(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.noKnockbackDamageSource(pSource.f_19853_, BUBBLE_STREAM, pSource, pIndirectEntity, new EntityType[0]);
    }

    public static DamageSource magicBolt(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.noKnockbackDamageSource(pSource.f_19853_, MAGIC_BOLT, pSource, pIndirectEntity, new EntityType[0]);
    }

    public static DamageSource acid(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.noKnockbackDamageSource(pSource.f_19853_, ACID, pSource, pIndirectEntity, new EntityType[0]);
    }

    public static DamageSource spike(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.noKnockbackDamageSource(pSource.f_19853_, SPIKE, pSource, pIndirectEntity, new EntityType[0]);
    }

    public static DamageSource windBlast(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.indirectEntityDamageSource(pSource.f_19853_, WIND_BLAST, pSource, pIndirectEntity);
    }

    public static DamageSource deathCurse(Entity pSource) {
        return ModDamageSource.noKnockbackDamageSource(pSource.f_19853_, DEATH, pSource, pSource, new EntityType[0]);
    }

    public static boolean hellfireAttacks(DamageSource source) {
        return source != null && source.m_269533_(ModTags.DamageTypes.HELLFIRE);
    }

    public static boolean isMagicFire(DamageSource source) {
        return source != null && source.m_269533_(ModTags.DamageTypes.MAGIC_FIRE);
    }

    public static boolean shockAttacks(DamageSource source) {
        return source.m_19385_().equals(ModDamageSource.source("shock")) || source.m_19385_().equals(ModDamageSource.source("directShock")) || source.m_19385_().equals(ModDamageSource.source("indirectShock")) || source.m_269533_(ModTags.DamageTypes.SHOCK_ATTACKS);
    }

    public static boolean freezeAttacks(DamageSource source) {
        return source.m_19385_().equals(ModDamageSource.source("indirectFreeze")) || source.m_19385_().equals(ModDamageSource.source("directFreeze")) || source.m_19385_().equals(ModDamageSource.source("iceBouquet")) || source.m_19385_().equals(ModDamageSource.source("frostBreath")) || source.m_269533_(ModTags.DamageTypes.FROST_ATTACKS);
    }

    public static boolean waterAttacks(DamageSource source) {
        return source.m_19385_().equals(ModDamageSource.source("drench")) || source.m_19385_().equals(ModDamageSource.source("directDrench")) || source.m_19385_().equals(ModDamageSource.source("indirectDrench")) || source.m_19385_().equals(ModDamageSource.source("bubbleStream")) || source.m_269533_(ModTags.DamageTypes.WATER_ATTACKS);
    }

    public static boolean physicalAttacks(DamageSource source) {
        return source.m_7640_() != null && source.m_7640_() instanceof LivingEntity && (source.m_19385_().equals("mob") || source.m_19385_().equals("sting") || source.m_19385_().equals("player") || source.m_19385_().equals(ModDamageSource.source("summon")) || source.m_269533_(ModTags.DamageTypes.PHYSICAL));
    }

    public static boolean toolAttack(DamageSource source, Predicate<Item> item) {
        Entity entity;
        if (ModDamageSource.physicalAttacks(source) && (entity = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return item.test(living.m_21205_().m_41720_());
        }
        return false;
    }

    public static DamageSource soulLeech(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.noKnockbackDamageSource(pSource.f_19853_, SOUL_LEECH, pSource, pIndirectEntity, new EntityType[0]);
    }

    public static DamageSource lifeLeech(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.noKnockbackDamageSource(pSource.f_19853_, LIFE_LEECH, pSource, pIndirectEntity, new EntityType[0]);
    }

    public static DamageSource choke(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.noKnockbackDamageSource(pSource.f_19853_, CHOKE, pSource, pIndirectEntity, new EntityType[0]);
    }

    public static DamageSource swarm(Entity pSource, @Nullable Entity pIndirectEntity) {
        return ModDamageSource.noKnockbackDamageSource(pSource.f_19853_, SWARM, pSource, pIndirectEntity, new EntityType[0]);
    }

    public static boolean wantingAttacks(DamageSource source) {
        return source.m_269533_(ModTags.DamageTypes.WANTING_DAMAGE);
    }

    public static String source(String source) {
        return "goety." + source;
    }

    public static void bootstrap(BootstapContext<DamageType> context) {
        context.m_255272_(SUMMON, (Object)new DamageType("goety.summon", 0.1f));
        context.m_255272_(SHOCK, (Object)new DamageType("goety.shock", 0.0f));
        context.m_255272_(DIRECT_SHOCK, (Object)new DamageType("goety.directShock", 0.0f));
        context.m_255272_(INDIRECT_SHOCK, (Object)new DamageType("goety.indirectShock", 0.0f));
        context.m_255272_(LIGHTNING, (Object)new DamageType("goety.lightning", 0.0f));
        context.m_255272_(DIRECT_FREEZE, (Object)new DamageType("goety.directFreeze", 0.0f, DamageEffects.FREEZING));
        context.m_255272_(INDIRECT_FREEZE, (Object)new DamageType("goety.indirectFreeze", 0.0f, DamageEffects.FREEZING));
        context.m_255272_(ICE_SPIKE, (Object)new DamageType("goety.indirectFreeze", 0.0f, DamageEffects.FREEZING));
        context.m_255272_(DRENCH, (Object)new DamageType("goety.drench", 0.0f, DamageEffects.DROWNING));
        context.m_255272_(DIRECT_DRENCH, (Object)new DamageType("goety.directDrench", 0.0f, DamageEffects.DROWNING));
        context.m_255272_(INDIRECT_DRENCH, (Object)new DamageType("goety.indirectDrench", 0.0f, DamageEffects.DROWNING));
        context.m_255272_(SWORD, (Object)new DamageType("goety.sword", 0.0f));
        context.m_255272_(WIND_BLAST, (Object)new DamageType("goety.windBlast", 0.0f));
        context.m_255272_(ICE_BOUQUET, (Object)new DamageType("goety.iceBouquet", 0.0f, DamageEffects.FREEZING));
        context.m_255272_(HELLFIRE, (Object)new DamageType("goety.hellfire", 0.0f, DamageEffects.BURNING));
        context.m_255272_(INDIRECT_HELLFIRE, (Object)new DamageType("goety.indirectHellfire", 0.0f, DamageEffects.BURNING));
        context.m_255272_(MAGIC_FIREBALL, (Object)new DamageType("fireball", 0.1f, DamageEffects.BURNING));
        context.m_255272_(NO_OWNER_MAGIC_FIREBALL, (Object)new DamageType("onFire", 0.1f, DamageEffects.BURNING));
        context.m_255272_(LOOT_EXPLODE, (Object)new DamageType("explosion", DamageScaling.ALWAYS, 0.1f));
        context.m_255272_(LOOT_EXPLODE_OWNED, (Object)new DamageType("explosion.player", DamageScaling.ALWAYS, 0.1f));
        context.m_255272_(FIRE_BREATH, (Object)new DamageType("goety.fireBreath", 0.0f, DamageEffects.BURNING));
        context.m_255272_(MAGIC_FIRE, (Object)new DamageType("goety.fireBreath", 0.0f, DamageEffects.BURNING));
        context.m_255272_(FROST_BREATH, (Object)new DamageType("goety.frostBreath", 0.0f, DamageEffects.FREEZING));
        context.m_255272_(BUBBLE_STREAM, (Object)new DamageType("goety.bubbleStream", 0.0f, DamageEffects.DROWNING));
        context.m_255272_(MAGIC_BOLT, (Object)new DamageType("indirectMagic", 0.0f));
        context.m_255272_(ACID, (Object)new DamageType("goety.acid", 0.0f));
        context.m_255272_(SOUL_LEECH, (Object)new DamageType("goety.soulLeech", 0.0f));
        context.m_255272_(LIFE_LEECH, (Object)new DamageType("goety.lifeLeech", 0.0f));
        context.m_255272_(SPIKE, (Object)new DamageType("goety.spike", 0.0f, DamageEffects.POKING));
        context.m_255272_(BOILING, (Object)new DamageType("goety.boiling", 0.0f, DamageEffects.BURNING));
        context.m_255272_(PHOBIA, (Object)new DamageType("goety.phobia", 0.0f));
        context.m_255272_(CHOKE, (Object)new DamageType("goety.choke", 0.0f));
        context.m_255272_(SWARM, (Object)new DamageType("goety.swarm", 0.0f));
        context.m_255272_(VOIDED, (Object)new DamageType("goety.voided", 0.0f));
        context.m_255272_(DOOM, (Object)new DamageType("goety.doom", 0.0f));
        context.m_255272_(DEATH, (Object)new DamageType("goety.death", 0.0f));
    }

    public static class EntityExcludedDamageSource
    extends DamageSource {
        protected final List<EntityType<?>> entities;

        public EntityExcludedDamageSource(Holder<DamageType> type, EntityType<?> ... entities) {
            super(type);
            this.entities = Arrays.stream(entities).toList();
        }

        public Component m_6157_(LivingEntity living) {
            LivingEntity livingentity = living.m_21232_();
            String s = "death.attack." + this.m_269415_().f_268677_();
            String s1 = s + ".player";
            if (livingentity != null) {
                for (EntityType<?> entity : this.entities) {
                    if (livingentity.m_6095_() != entity) continue;
                    return Component.m_237110_((String)s, (Object[])new Object[]{living.m_5446_()});
                }
            }
            return livingentity != null ? Component.m_237110_((String)s1, (Object[])new Object[]{living.m_5446_(), livingentity.m_5446_()}) : Component.m_237110_((String)s, (Object[])new Object[]{living.m_5446_()});
        }
    }
}

