/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.api.items.magic.IFocus;
import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.api.magic.ISpell;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.entities.neutral.AbstractVine;
import com.Polarice3.Goety.common.entities.neutral.TotemicBomb;
import com.Polarice3.Goety.common.entities.projectiles.Fangs;
import com.Polarice3.Goety.common.entities.projectiles.IceBouquet;
import com.Polarice3.Goety.common.entities.projectiles.Spike;
import com.Polarice3.Goety.common.entities.util.TridentStorm;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SLightningPacket;
import com.Polarice3.Goety.common.network.server.SThunderBoltPacket;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.Vec3Util;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WandUtil {
    public static final int[] CONFIG_1_NORTH_ROW = new int[]{2, 3, 4, 5, 6};
    public static final int[] CONFIG_1_WEST_ROW = new int[]{6, 7, 8, 9, 10};
    public static final int[] CONFIG_1_SOUTH_ROW = new int[]{10, 11, 12, 13, 14};
    public static final int[] CONFIG_1_EAST_ROW = new int[]{14, 15, 0, 1, 2};
    public static final int[][] CONFIG_1_ROWS = new int[][]{CONFIG_1_NORTH_ROW, CONFIG_1_WEST_ROW, CONFIG_1_SOUTH_ROW, CONFIG_1_EAST_ROW};

    private static boolean isMatchingItem(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof IWand;
    }

    public static ItemStack findWandOnHand(LivingEntity livingEntity, InteractionHand hand) {
        ItemStack foundStack = ItemStack.f_41583_;
        if (WandUtil.isMatchingItem(livingEntity.m_21120_(hand))) {
            foundStack = livingEntity.m_21120_(hand);
        }
        return foundStack;
    }

    public static ItemStack findWand(LivingEntity livingEntity) {
        ItemStack foundStack = ItemStack.f_41583_;
        if (WandUtil.isMatchingItem(livingEntity.m_21205_())) {
            foundStack = livingEntity.m_21205_();
        } else if (WandUtil.isMatchingItem(livingEntity.m_21206_())) {
            foundStack = livingEntity.m_21206_();
        }
        return foundStack;
    }

    public static ItemStack findFocusOnHand(LivingEntity livingEntity, InteractionHand hand) {
        ItemStack foundStack = ItemStack.f_41583_;
        if (!WandUtil.findWandOnHand(livingEntity, hand).m_41619_() && !IWand.getFocus(WandUtil.findWandOnHand(livingEntity, hand)).m_41619_()) {
            foundStack = IWand.getFocus(WandUtil.findWandOnHand(livingEntity, hand));
        }
        return foundStack;
    }

    public static ItemStack findFocus(LivingEntity livingEntity) {
        ItemStack foundStack = ItemStack.f_41583_;
        if (!WandUtil.findWand(livingEntity).m_41619_() && !IWand.getFocus(WandUtil.findWand(livingEntity)).m_41619_()) {
            foundStack = IWand.getFocus(WandUtil.findWand(livingEntity));
        }
        return foundStack;
    }

    public static ItemStack findFocusInInv(@Nullable Player player) {
        ItemStack foundStack = ItemStack.f_41583_;
        if (player != null) {
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack inSlot = player.m_150109_().m_8020_(i);
                if (!(inSlot.m_41720_() instanceof IFocus)) continue;
                foundStack = inSlot;
            }
        }
        return foundStack;
    }

    public static ISpell getSpellOnHand(LivingEntity livingEntity, InteractionHand hand) {
        IFocus magicFocus;
        Item item = WandUtil.findFocusOnHand(livingEntity, hand).m_41720_();
        if (item instanceof IFocus && (magicFocus = (IFocus)item).getSpell() != null) {
            return magicFocus.getSpell();
        }
        return null;
    }

    public static ISpell getSpell(LivingEntity livingEntity) {
        IFocus magicFocus;
        Item item = WandUtil.findFocus(livingEntity).m_41720_();
        if (item instanceof IFocus && (magicFocus = (IFocus)item).getSpell() != null) {
            return magicFocus.getSpell();
        }
        return null;
    }

    public static int getShots(LivingEntity livingEntity) {
        Item item;
        if (livingEntity.m_6117_() && (item = livingEntity.m_21211_().m_41720_()) instanceof IWand) {
            IWand wand = (IWand)item;
            return wand.ShotsFired(livingEntity.m_21211_());
        }
        return 0;
    }

    public static boolean hasFocusInInv(@Nullable Player player) {
        return !WandUtil.findFocusInInv(player).m_41619_();
    }

    public static boolean enchantedFocus(LivingEntity livingEntity) {
        return !WandUtil.findFocus(livingEntity).m_41619_() && WandUtil.findFocus(livingEntity).m_41793_();
    }

    public static int getLevels(Enchantment enchantment, LivingEntity livingEntity) {
        if (WandUtil.enchantedFocus(livingEntity)) {
            return WandUtil.findFocus(livingEntity).getEnchantmentLevel(enchantment);
        }
        return 0;
    }

    public static void chainLightning(LivingEntity pTarget, @Nullable LivingEntity pAttacker, double range, float damage) {
        WandUtil.chainLightning(pTarget, pAttacker, range, damage, false);
    }

    public static void chainLightning(LivingEntity pTarget, @Nullable LivingEntity pAttacker, double range, float damage, boolean small) {
        Level level = pTarget.f_19853_;
        ArrayList<Entity> harmed = new ArrayList<Entity>();
        Predicate<Entity> selector = entity -> {
            LivingEntity livingEntity;
            return entity instanceof LivingEntity && !harmed.contains(livingEntity = (LivingEntity)entity);
        };
        if (pAttacker != null) {
            selector = selector.and(entity -> {
                LivingEntity livingEntity;
                return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity) != pAttacker && MobUtil.canAttack(pAttacker, livingEntity);
            });
        }
        LivingEntity prevTarget = pTarget;
        int hops = level.m_46470_() ? 8 : 4;
        for (int i = 0; i < hops; ++i) {
            LivingEntity finalPrevTarget;
            AABB aabb = new AABB(Vec3Util.subtract(prevTarget.m_20182_(), range), Vec3Util.add(prevTarget.m_20182_(), range));
            List entities = level.m_6249_((Entity)prevTarget, aabb, selector.and(arg_0 -> WandUtil.lambda$chainLightning$2((Entity)(finalPrevTarget = prevTarget), arg_0)));
            if (entities.isEmpty()) continue;
            Entity target = (Entity)entities.get(level.m_213780_().m_188503_(entities.size()));
            DamageSource damageSource = ModDamageSource.getDamageSource(pTarget.f_19853_, ModDamageSource.SHOCK, new EntityType[0]);
            if (pAttacker != null) {
                damageSource = ModDamageSource.directShock(pAttacker);
            }
            if (target.m_6469_(damageSource, damage) && prevTarget != target) {
                Vec3 vec3 = prevTarget.m_146892_();
                Vec3 vec31 = target.m_146892_();
                if (small) {
                    ModNetwork.sendToALL(new SLightningPacket(vec3, vec31, 5));
                } else {
                    ModNetwork.sendToALL(new SThunderBoltPacket(vec3, vec31, 8));
                }
            }
            harmed.add(target);
            prevTarget = target;
            damage -= 1.0f;
        }
    }

    public static void spawnFangs(LivingEntity livingEntity, double pPosX, double pPosZ, double PPPosY, double pOPosY, float pYRot, int pWarmUp) {
        WandUtil.spawnFangs(livingEntity, pPosX, pPosZ, PPPosY, pOPosY, pYRot, pWarmUp, 0, 0);
    }

    public static void spawnFangs(LivingEntity livingEntity, double pPosX, double pPosZ, double PPPosY, double pOPosY, float pYRot, int pWarmUp, int pPotency, int pBurning) {
        BlockPos blockpos = BlockPos.m_274561_((double)pPosX, (double)pOPosY, (double)pPosZ);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = livingEntity.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)livingEntity.f_19853_, blockpos1, Direction.UP)) continue;
            if (!livingEntity.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = livingEntity.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)livingEntity.f_19853_, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)PPPosY) - 1);
        if (flag) {
            Player player;
            Fangs fangEntity = new Fangs(livingEntity.f_19853_, pPosX, (double)blockpos.m_123342_() + d0, pPosZ, pYRot, pWarmUp, livingEntity);
            if (livingEntity instanceof Player && WandUtil.enchantedFocus((LivingEntity)(player = (Player)livingEntity))) {
                if (WandUtil.getLevels((Enchantment)ModEnchantments.ABSORB.get(), (LivingEntity)player) != 0) {
                    fangEntity.setAbsorbing(true);
                }
                if (WandUtil.getLevels((Enchantment)ModEnchantments.SOUL_EATER.get(), (LivingEntity)player) > 0) {
                    fangEntity.setSoulEater(WandUtil.getLevels((Enchantment)ModEnchantments.SOUL_EATER.get(), (LivingEntity)player));
                }
            }
            fangEntity.setDamage(pPotency);
            fangEntity.setBurning(pBurning);
            livingEntity.f_19853_.m_7967_((Entity)fangEntity);
        }
    }

    public static void spawnSpikes(LivingEntity livingEntity, double pPosX, double pPosZ, double PPPosY, double pOPosY, float pYRot, int pWarmUp) {
        BlockPos blockpos = BlockPos.m_274561_((double)pPosX, (double)pOPosY, (double)pPosZ);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = livingEntity.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)livingEntity.f_19853_, blockpos1, Direction.UP)) continue;
            if (!livingEntity.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = livingEntity.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)livingEntity.f_19853_, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)PPPosY) - 1);
        if (flag) {
            Player player;
            Spike spike = new Spike(livingEntity.f_19853_, pPosX, (double)blockpos.m_123342_() + d0, pPosZ, pYRot, pWarmUp, livingEntity);
            if (livingEntity instanceof Player && WandUtil.enchantedFocus((LivingEntity)(player = (Player)livingEntity))) {
                float enchantment = 0.0f;
                int burning = 0;
                int soulEater = 0;
                if (WandUtil.enchantedFocus((LivingEntity)player)) {
                    enchantment = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), (LivingEntity)player);
                    burning = WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), (LivingEntity)player);
                    soulEater = WandUtil.getLevels((Enchantment)ModEnchantments.SOUL_EATER.get(), (LivingEntity)player);
                }
                spike.setExtraDamage(enchantment);
                spike.setBurning(burning);
                spike.setSoulEater(soulEater);
            }
            livingEntity.f_19853_.m_7967_((Entity)spike);
        }
    }

    public static void spawnIceBouquet(Level world, Vec3 pPos, LivingEntity livingEntity) {
        WandUtil.spawnIceBouquet(world, pPos, livingEntity, 0.0f, 0);
    }

    public static void spawnIceBouquet(Level level, LivingEntity casterEntity, Vec3 targetPos, double xshift, double zshift, float damage, int duration) {
        WandUtil.spawnIceBouquet(level, casterEntity, targetPos, xshift, zshift, damage, duration, false);
    }

    public static void spawnIceBouquet(Level level, LivingEntity casterEntity, Vec3 targetPos, double xshift, double zshift, float damage, int duration, boolean isCenter) {
        targetPos = targetPos.m_82520_(xshift, 0.5, zshift);
        IceBouquet iceBouquet = (IceBouquet)((EntityType)ModEntityType.ICE_BOUQUET.get()).m_20615_(level);
        if (iceBouquet != null) {
            iceBouquet.setOwner(casterEntity);
            iceBouquet.m_6034_(targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_());
            iceBouquet.setExtraDamage(damage);
            iceBouquet.addLifeSpan(duration);
            iceBouquet.setCenter(isCenter);
            MobUtil.moveDownToGround(iceBouquet);
            level.m_7967_((Entity)iceBouquet);
        }
    }

    public static void spawnIceBouquet(Level world, Vec3 pPos, LivingEntity livingEntity, float damage, int duration) {
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, 0.0, 0.0, damage, duration, true);
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, 0.0, 1.0, damage, duration);
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, 0.0, -1.0, damage, duration);
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, 1.0, 0.0, damage, duration);
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, 1.0, 1.0, damage, duration);
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, 1.0, -1.0, damage, duration);
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, -1.0, 0.0, damage, duration);
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, -1.0, 1.0, damage, duration);
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, -1.0, -1.0, damage, duration);
    }

    public static void spawnCrossIceBouquet(Level world, Vec3 pPos, LivingEntity livingEntity) {
        WandUtil.spawnCrossIceBouquet(world, pPos, livingEntity, 0.0f, 0);
    }

    public static void spawnCrossIceBouquet(Level world, Vec3 pPos, LivingEntity livingEntity, float damage, int duration) {
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, 0.0, 0.0, damage, duration, true);
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, 1.0, 0.0, damage, duration);
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, -1.0, 0.0, damage, duration);
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, 0.0, 1.0, damage, duration);
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, 0.0, -1.0, damage, duration);
    }

    public static void spawn4x4IceBouquet(Level world, Vec3 pPos, LivingEntity livingEntity) {
        WandUtil.spawn4x4IceBouquet(world, pPos, livingEntity, 0.0f, 0);
    }

    public static void spawn4x4IceBouquet(Level world, Vec3 pPos, LivingEntity livingEntity, float damage, int duration) {
        WandUtil.spawnIceBouquet(world, livingEntity, pPos, 0.0, 0.0, damage, duration, true);
        int random = world.f_46441_.m_188503_(4);
        if (random == 0) {
            WandUtil.spawnIceBouquet(world, livingEntity, pPos, 0.0, 1.0, damage, duration);
            WandUtil.spawnIceBouquet(world, livingEntity, pPos, 1.0, 0.0, damage, duration);
            WandUtil.spawnIceBouquet(world, livingEntity, pPos, 1.0, 1.0, damage, duration);
        } else if (random == 1) {
            WandUtil.spawnIceBouquet(world, livingEntity, pPos, 0.0, -1.0, damage, duration);
            WandUtil.spawnIceBouquet(world, livingEntity, pPos, 1.0, 0.0, damage, duration);
            WandUtil.spawnIceBouquet(world, livingEntity, pPos, 1.0, -1.0, damage, duration);
        } else if (random == 2) {
            WandUtil.spawnIceBouquet(world, livingEntity, pPos, 0.0, 1.0, damage, duration);
            WandUtil.spawnIceBouquet(world, livingEntity, pPos, -1.0, 0.0, damage, duration);
            WandUtil.spawnIceBouquet(world, livingEntity, pPos, -1.0, 1.0, damage, duration);
        } else {
            WandUtil.spawnIceBouquet(world, livingEntity, pPos, 0.0, -1.0, damage, duration);
            WandUtil.spawnIceBouquet(world, livingEntity, pPos, -1.0, 0.0, damage, duration);
            WandUtil.spawnIceBouquet(world, livingEntity, pPos, -1.0, -1.0, damage, duration);
        }
    }

    public static void summonTridentStorm(LivingEntity casterEntity, Vec3 targetPos, double xshift, double zshift, int warmUp, int potency) {
        targetPos = targetPos.m_82520_(xshift, 0.5, zshift);
        Level level = casterEntity.f_19853_;
        TridentStorm tridentStorm = (TridentStorm)((EntityType)ModEntityType.TRIDENT_STORM.get()).m_20615_(level);
        if (tridentStorm != null) {
            tridentStorm.setOwner(casterEntity);
            tridentStorm.m_6034_(targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_());
            tridentStorm.setWarmUp(warmUp);
            tridentStorm.setExtraDamage(potency);
            MobUtil.moveDownToGround(tridentStorm);
            level.m_7967_((Entity)tridentStorm);
        }
    }

    public static void summonTridentMinor(LivingEntity casterEntity, int warmUp, int potency) {
        Vec3 vec3 = casterEntity.m_20182_();
        if (casterEntity.m_217043_().m_188499_()) {
            WandUtil.summonTridentStorm(casterEntity, vec3, 2.0, 0.0, warmUp, potency);
            WandUtil.summonTridentStorm(casterEntity, vec3, 0.0, 2.0, warmUp, potency);
            WandUtil.summonTridentStorm(casterEntity, vec3, -2.0, 0.0, warmUp, potency);
            WandUtil.summonTridentStorm(casterEntity, vec3, 0.0, -2.0, warmUp, potency);
        } else {
            WandUtil.summonTridentStorm(casterEntity, vec3, 2.0, 2.0, warmUp, potency);
            WandUtil.summonTridentStorm(casterEntity, vec3, -2.0, 2.0, warmUp, potency);
            WandUtil.summonTridentStorm(casterEntity, vec3, 2.0, -2.0, warmUp, potency);
            WandUtil.summonTridentStorm(casterEntity, vec3, -2.0, -2.0, warmUp, potency);
        }
    }

    public static void summonTridentSurround(LivingEntity casterEntity, int warmUp, int potency) {
        Vec3 vec3 = casterEntity.m_20182_();
        WandUtil.summonTridentStorm(casterEntity, vec3, 3.0, 0.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 2.0, 2.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -3.0, 0.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -2.0, 2.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 0.0, 3.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 2.0, -2.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 0.0, -3.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -2.0, -2.0, warmUp, potency);
    }

    public static void summonTridentSquare(LivingEntity casterEntity, int warmUp, int potency) {
        Vec3 vec3 = casterEntity.m_20182_();
        WandUtil.summonTridentStorm(casterEntity, vec3, 2.25, 0.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 5.0, 0.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 2.25, 3.5, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 5.0, 3.5, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 2.25, -3.5, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 5.0, -3.5, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -2.25, 0.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -5.0, 0.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -2.25, 3.5, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -5.0, 3.5, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -2.25, -3.5, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -5.0, -3.5, warmUp, potency);
    }

    public static void summonTridentCross(LivingEntity casterEntity, int warmUp, int potency) {
        Vec3 vec3 = casterEntity.m_20182_();
        WandUtil.summonTridentStorm(casterEntity, vec3, 2.0, 0.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 0.0, 2.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -2.0, 0.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 0.0, -2.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 3.5, -3.5, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -3.5, -3.5, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 3.5, 3.5, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -3.5, 3.5, warmUp, potency);
    }

    public static void summonTridentWideCircle(LivingEntity casterEntity, int warmUp, int potency) {
        Vec3 vec3 = casterEntity.m_20182_();
        WandUtil.summonTridentStorm(casterEntity, vec3, 2.0, 0.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 0.0, 2.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -2.0, 0.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 0.0, -2.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 0.0, 5.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 0.0, -5.0, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 4.5, 2.25, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, 4.5, -2.25, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -4.5, 2.25, warmUp, potency);
        WandUtil.summonTridentStorm(casterEntity, vec3, -4.5, -2.25, warmUp, potency);
    }

    private static boolean isValueInArray(int[] array, int toCheckValue) {
        for (int element : array) {
            if (element != toCheckValue) continue;
            return true;
        }
        return false;
    }

    private static double getXShift(int i, double xshift) {
        if (i == 0 || i == 1 || i == 2 || i == 14 || i == 15) {
            xshift = -2.0;
        }
        if (i >= 6 && i <= 10) {
            xshift = 2.0;
        }
        if (i == 3 || i == 13) {
            xshift = -1.0;
        }
        if (i == 5 || i == 11) {
            xshift = 1.0;
        }
        return xshift;
    }

    private static double getZShift(int i, double zshift) {
        if (i >= 10 && i <= 14) {
            zshift = -2.0;
        }
        if (i >= 2 && i <= 6) {
            zshift = 2.0;
        }
        if (i == 9 || i == 15) {
            zshift = -1.0;
        }
        if (i == 1 || i == 7) {
            zshift = 1.0;
        }
        return zshift;
    }

    private static BlockPos createCenteredBlockPosOnTarget(Entity targetEntity) {
        return BlockPos.m_274561_((double)Math.floor(targetEntity.m_20185_()), (double)Math.floor(targetEntity.m_20186_()), (double)Math.floor(targetEntity.m_20189_()));
    }

    public static void summonMonolith(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends AbstractMonolith> wallEntityType, double xshift, double zshift, int extra) {
        WandUtil.summonMonolith(casterEntity, targetPos, wallEntityType, xshift, zshift, 0, extra);
    }

    public static void summonMonolith(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends AbstractMonolith> wallEntityType, double xshift, double zshift, int delay, int extra) {
        targetPos = targetPos.m_7918_((int)xshift, 1, (int)zshift);
        Vec3 vec3 = Vec3.m_82539_((Vec3i)targetPos);
        Level level = casterEntity.f_19853_;
        AbstractMonolith monolith = (AbstractMonolith)wallEntityType.m_20615_(level);
        if (monolith != null) {
            EntityType entityType;
            Player player = null;
            if (casterEntity instanceof Player) {
                Player player1;
                player = player1 = (Player)casterEntity;
            }
            if ((entityType = monolith.getVariant(player, level, targetPos)) != null) {
                monolith = (AbstractMonolith)entityType.m_20615_(level);
            }
            if (monolith != null) {
                monolith.setTrueOwner(casterEntity);
                monolith.m_6034_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    monolith.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(targetPos), MobSpawnType.MOB_SUMMONED, null, null);
                }
                if (monolith instanceof AbstractVine) {
                    AbstractVine vine = (AbstractVine)monolith;
                    vine.setWarmup(delay);
                    monolith.setLifeSpan(3 + extra);
                } else if (monolith instanceof TotemicBomb) {
                    TotemicBomb totemicBomb = (TotemicBomb)monolith;
                    totemicBomb.setExplosionPower(2.0f + (float)extra / 4.0f);
                } else {
                    monolith.setLifeSpan(6 + extra);
                }
                level.m_7967_((Entity)monolith);
            }
        }
    }

    public static void summonMonolith(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends AbstractMonolith> wallEntityType, double xshift, double zshift, int extra) {
        BlockPos targetPos = WandUtil.createCenteredBlockPosOnTarget(targetEntity);
        WandUtil.summonMonolith(casterEntity, targetPos, wallEntityType, xshift, zshift, extra);
    }

    public static void summonTurret(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends AbstractMonolith> wallEntityType, @Nullable Entity target, int duration, int potency) {
        WandUtil.summonTurret(casterEntity, targetPos, wallEntityType, target, 0, duration, potency);
    }

    public static void summonTurret(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends AbstractMonolith> wallEntityType, @Nullable Entity target, int delay, int duration, int potency) {
        targetPos = targetPos.m_7494_();
        Vec3 vec3 = Vec3.m_82539_((Vec3i)targetPos);
        Level level = casterEntity.f_19853_;
        AbstractMonolith monolith = (AbstractMonolith)wallEntityType.m_20615_(level);
        if (monolith != null) {
            EntityType entityType;
            Player player = null;
            if (casterEntity instanceof Player) {
                Player player1;
                player = player1 = (Player)casterEntity;
            }
            if ((entityType = monolith.getVariant(player, level, targetPos)) != null) {
                monolith = (AbstractMonolith)entityType.m_20615_(level);
            }
            if (monolith != null) {
                monolith.setTrueOwner(casterEntity);
                monolith.m_6034_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    monolith.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(targetPos), MobSpawnType.MOB_SUMMONED, null, null);
                }
                if (monolith instanceof AbstractVine) {
                    AbstractVine vine = (AbstractVine)monolith;
                    vine.setWarmup(delay);
                }
                if (potency > 0 && !casterEntity.m_21023_((MobEffect)GoetyEffects.SUMMON_DOWN.get())) {
                    monolith.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUFF.get(), EffectsUtil.infiniteEffect(), potency - 1, false, false));
                }
                if (target instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)target;
                    monolith.m_6710_(living);
                }
                monolith.setLifeSpan(7 * (duration + 1));
                level.m_7967_((Entity)monolith);
            }
        }
    }

    public static void summonLesserSquareTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends AbstractMonolith> entityType, int[] rowToRemove, int extra) {
        for (int constructPositionIndex = 0; constructPositionIndex <= 7; ++constructPositionIndex) {
            if (WandUtil.isValueInArray(rowToRemove, constructPositionIndex)) continue;
            double xshift = 0.0;
            double zshift = 0.0;
            xshift = WandUtil.getXShift(constructPositionIndex, xshift);
            zshift = WandUtil.getZShift(constructPositionIndex, zshift);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, xshift, zshift, extra);
        }
    }

    public static void summonSquareTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends AbstractMonolith> entityType, int[] rowToRemove, int extra) {
        for (int constructPositionIndex = 0; constructPositionIndex <= 15; ++constructPositionIndex) {
            if (WandUtil.isValueInArray(rowToRemove, constructPositionIndex)) continue;
            double xshift = 0.0;
            double zshift = 0.0;
            xshift = WandUtil.getXShift(constructPositionIndex, xshift);
            zshift = WandUtil.getZShift(constructPositionIndex, zshift);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, xshift, zshift, extra);
        }
    }

    public static void summonSquareTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends AbstractMonolith> entityType, int[] rowToRemove, int extra) {
        BlockPos targetPos = WandUtil.createCenteredBlockPosOnTarget(targetEntity);
        WandUtil.summonSquareTrap(casterEntity, targetPos, entityType, rowToRemove, extra);
    }

    public static void summonMinorSquareTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends AbstractMonolith> entityType, Direction direction, int extra) {
        BlockPos targetPos = WandUtil.createCenteredBlockPosOnTarget(targetEntity);
        if (direction.m_122434_() == Direction.Axis.X) {
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, 0.0, -2.0, 0, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, 0.0, 2.0, 0, extra);
            if (casterEntity.m_217043_().m_188499_()) {
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, -1.0, -2.0, 2, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, -2.0, 4, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, -1.0, 6, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, 0.0, 8, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, 1.0, 6, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, 2.0, 4, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, -1.0, 2.0, 2, extra);
            } else {
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 1.0, -2.0, 2, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, -2.0, 4, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, -1.0, 6, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, 0.0, 8, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, 1.0, 6, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, 2.0, 4, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 1.0, 2.0, 2, extra);
            }
        } else if (direction.m_122434_() == Direction.Axis.Z) {
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, 0.0, 0, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, 0.0, 0, extra);
            if (casterEntity.m_217043_().m_188499_()) {
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, -1.0, 2, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, -2.0, 4, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, -1.0, -2.0, 6, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 0.0, -2.0, 8, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 1.0, -2.0, 6, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, -2.0, 4, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, -1.0, 2, extra);
            } else {
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, 1.0, 2, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, 2.0, 4, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, -1.0, 2.0, 6, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 0.0, 2.0, 8, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 1.0, 2.0, 6, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, 2.0, 4, extra);
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, 1.0, 2, extra);
            }
        }
    }

    public static void summonCircleTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends AbstractMonolith> entityType, Direction direction, int extra) {
        BlockPos targetPos = WandUtil.createCenteredBlockPosOnTarget(targetEntity);
        if (direction.m_122434_() == Direction.Axis.X) {
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, 1.0, 2.0, 0, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, -1.0, 2.0, 0, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, -1.0, 1, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, 0.0, 2, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, 1.0, 3, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, -1.0, 3, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, 0.0, 2, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, 1.0, 1, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, 1.0, -2.0, 0, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, -1.0, -2.0, 0, extra);
        } else if (direction.m_122434_() == Direction.Axis.Z) {
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, 1.0, 0, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, -1.0, 0, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, 1.0, 2.0, 1, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, 0.0, 2.0, 2, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, -1.0, 2.0, 3, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, 1.0, -2.0, 3, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, 0.0, -2.0, 2, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, -1.0, -2.0, 1, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, 1.0, 0, extra);
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, -1.0, 0, extra);
        }
    }

    public static void summonCubeTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends AbstractMonolith> entityType, int extra) {
        for (int constructPositionIndex = 0; constructPositionIndex <= 25; ++constructPositionIndex) {
            if (constructPositionIndex == 4 || constructPositionIndex == 8 || constructPositionIndex == 12 || constructPositionIndex == 16) continue;
            double xshift = 0.0;
            double zshift = 0.0;
            xshift = WandUtil.getXShift(constructPositionIndex, xshift);
            zshift = WandUtil.getZShift(constructPositionIndex, zshift);
            if (xshift == 0.0 || zshift == 0.0) continue;
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, xshift, zshift, constructPositionIndex, extra);
        }
    }

    public static void summonCubeTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends AbstractMonolith> entityType, int extra) {
        BlockPos targetPos = WandUtil.createCenteredBlockPosOnTarget(targetEntity);
        WandUtil.summonCubeTrap(casterEntity, targetPos, entityType, extra);
    }

    public static void summonHallTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends AbstractMonolith> entityType, int extra) {
        block5: {
            int length;
            Direction direction;
            block4: {
                int length2;
                direction = Direction.m_122364_((double)casterEntity.m_6080_());
                if (direction.m_122434_() != Direction.Axis.X) break block4;
                for (length2 = -2; length2 <= 2; ++length2) {
                    WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, length2, length2 + 2, extra);
                }
                for (length2 = -2; length2 <= 2; ++length2) {
                    WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, length2, length2 + 2, extra);
                }
                break block5;
            }
            if (direction.m_122434_() != Direction.Axis.Z) break block5;
            for (length = -2; length <= 2; ++length) {
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, length, 2.0, length + 2, extra);
            }
            for (length = -2; length <= 2; ++length) {
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, length, -2.0, length + 2, extra);
            }
        }
    }

    public static void summonHallTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends AbstractMonolith> entityType, int extra) {
        BlockPos targetPos = WandUtil.createCenteredBlockPosOnTarget(targetEntity);
        WandUtil.summonHallTrap(casterEntity, targetPos, entityType, extra);
    }

    public static void summonSurroundTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends AbstractMonolith> entityType, int extra) {
        WandUtil.summonMonolith(casterEntity, targetPos, entityType, 1.0, 0.0, 0, extra);
        WandUtil.summonMonolith(casterEntity, targetPos, entityType, -1.0, 0.0, 1, extra);
        WandUtil.summonMonolith(casterEntity, targetPos, entityType, 1.0, 1.0, 2, extra);
        WandUtil.summonMonolith(casterEntity, targetPos, entityType, -1.0, 1.0, 3, extra);
        WandUtil.summonMonolith(casterEntity, targetPos, entityType, 1.0, -1.0, 4, extra);
        WandUtil.summonMonolith(casterEntity, targetPos, entityType, -1.0, -1.0, 5, extra);
        WandUtil.summonMonolith(casterEntity, targetPos, entityType, 0.0, 1.0, 6, extra);
        WandUtil.summonMonolith(casterEntity, targetPos, entityType, 0.0, -1.0, 7, extra);
    }

    public static void summonSurroundTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends AbstractMonolith> entityType, int extra) {
        BlockPos targetPos = WandUtil.createCenteredBlockPosOnTarget(targetEntity);
        WandUtil.summonSurroundTrap(casterEntity, targetPos, entityType, extra);
    }

    public static void summonWallTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends AbstractMonolith> entityType, int extra) {
        WandUtil.summonWallTrap(casterEntity, targetPos, entityType, 5, extra);
    }

    public static void summonWallTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends AbstractMonolith> entityType, int amount, int extra) {
        block3: {
            Direction direction;
            block2: {
                direction = Direction.m_122364_((double)casterEntity.m_6080_());
                if (direction.m_122434_() != Direction.Axis.X) break block2;
                for (int length = -amount; length < amount; ++length) {
                    WandUtil.summonMonolith(casterEntity, targetPos, entityType, 0.0, (double)length, extra);
                }
                break block3;
            }
            if (direction.m_122434_() != Direction.Axis.Z) break block3;
            for (int length = -amount; length < amount; ++length) {
                WandUtil.summonMonolith(casterEntity, targetPos, entityType, (double)length, 0.0, extra);
            }
        }
    }

    public static void summonWallTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends AbstractMonolith> entityType, int extra) {
        WandUtil.summonWallTrap(casterEntity, targetEntity, entityType, 5, extra);
    }

    public static void summonWallTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends AbstractMonolith> entityType, int amount, int extra) {
        block10: {
            Direction direction;
            BlockPos targetPos;
            block9: {
                targetPos = WandUtil.createCenteredBlockPosOnTarget(targetEntity);
                direction = Direction.m_122364_((double)targetEntity.m_6080_());
                if (targetEntity instanceof Mob) {
                    direction = targetEntity.m_6374_();
                }
                if (direction.m_122434_() != Direction.Axis.X) break block9;
                if (casterEntity.m_217043_().m_188499_()) {
                    for (int length = -amount; length < amount; ++length) {
                        WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, (double)length, extra);
                    }
                } else {
                    for (int length = -amount; length < amount; ++length) {
                        WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, (double)length, extra);
                    }
                }
                break block10;
            }
            if (direction.m_122434_() != Direction.Axis.Z) break block10;
            if (casterEntity.m_217043_().m_188499_()) {
                for (int length = -amount; length < amount; ++length) {
                    WandUtil.summonMonolith(casterEntity, targetPos, entityType, (double)length, -2.0, extra);
                }
            } else {
                for (int length = -amount; length < amount; ++length) {
                    WandUtil.summonMonolith(casterEntity, targetPos, entityType, (double)length, 2.0, extra);
                }
            }
        }
    }

    public static void summonRandomPillarsTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends AbstractMonolith> entityType, int extra) {
        for (int length = 0; length < 25; ++length) {
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, (double)(-8 + casterEntity.m_217043_().m_188503_(16)), (double)(-8 + casterEntity.m_217043_().m_188503_(16)), extra);
        }
    }

    public static void summonRandomPillarsTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends AbstractMonolith> entityType, int extra) {
        WandUtil.summonRandomPillarsTrap(casterEntity, targetEntity, entityType, 12, extra);
    }

    public static void summonRandomPillarsTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends AbstractMonolith> entityType, int amount, int extra) {
        BlockPos targetPos = WandUtil.createCenteredBlockPosOnTarget(targetEntity);
        for (int length = 0; length < amount; ++length) {
            WandUtil.summonMonolith(casterEntity, targetPos, entityType, (double)(-4 + casterEntity.m_217043_().m_188503_(8)), (double)(-4 + casterEntity.m_217043_().m_188503_(8)), extra);
        }
    }

    public static void summonQuadOffensiveTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends AbstractMonolith> entityType, int extra) {
        WandUtil.summonMonolith(casterEntity, targetPos, entityType, -2.0, 0.0, extra);
        WandUtil.summonMonolith(casterEntity, targetPos, entityType, 2.0, 0.0, extra);
        WandUtil.summonMonolith(casterEntity, targetPos, entityType, 0.0, -2.0, extra);
        WandUtil.summonMonolith(casterEntity, targetPos, entityType, 0.0, 2.0, extra);
    }

    public static void summonQuadOffensiveTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends AbstractMonolith> entityType, int extra) {
        BlockPos targetPos = WandUtil.createCenteredBlockPosOnTarget(targetEntity);
        WandUtil.summonQuadOffensiveTrap(casterEntity, targetPos, entityType, extra);
    }

    private static /* synthetic */ boolean lambda$chainLightning$2(Entity finalPrevTarget, Entity entity) {
        return MobUtil.hasLineOfSight(finalPrevTarget, entity);
    }
}

