/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.content.tweaks.block.WaterPetalBlock;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickBlock;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickItem;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="tweaks")
public class PetalsOnWaterModule
extends ZetaModule {
    Block water_pink_petals;

    @LoadEvent
    public final void register(ZRegister event) {
        this.water_pink_petals = new WaterPetalBlock(Items.f_271209_, "water_pink_petals", this, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_271445_));
    }

    @PlayEvent
    public void onUseOnAir(ZRightClickItem event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_150930_(Items.f_271209_)) {
            Player player = event.getEntity();
            Level level = event.getLevel();
            InteractionHand hand = event.getHand();
            BlockHitResult blockhitresult = Item.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            BlockPos pos = blockhitresult.m_82425_();
            BlockState state = level.m_8055_(pos);
            Direction direction = blockhitresult.m_82434_();
            if (state.m_60713_(Blocks.f_49990_) && this.rightClickPetal(player, level, pos, state, direction, hand, stack)) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            }
        }
    }

    @PlayEvent
    public void onUseOnBlock(ZRightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_150930_(Items.f_271209_) && this.rightClickPetal(event.getPlayer(), event.getLevel(), event.getPos(), event.getLevel().m_8055_(event.getPos()), event.getFace(), event.getHand(), event.getItemStack())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)event.getLevel().f_46443_));
        }
    }

    private boolean rightClickPetal(Player player, Level level, BlockPos pos, BlockState state, Direction direction, InteractionHand hand, ItemStack stack) {
        boolean ret;
        if (direction == Direction.UP && !state.m_60713_(Blocks.f_49990_) && !state.m_60713_(this.water_pink_petals)) {
            pos = pos.m_7494_();
            state = level.m_8055_(pos);
        }
        if (ret = this.tryPlacePetal(player, level, pos, state, direction, hand, stack)) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            level.m_247517_(player, pos, SoundEvents.f_271130_, SoundSource.PLAYERS);
        }
        return ret;
    }

    private boolean tryPlacePetal(Player player, Level level, BlockPos pos, BlockState state, Direction direction, InteractionHand hand, ItemStack stack) {
        int amt;
        BlockPlaceContext ctx = new BlockPlaceContext(player, hand, stack, new BlockHitResult(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), direction, pos, false));
        if (state.m_60713_(Blocks.f_49990_)) {
            FluidState fluid = level.m_6425_(pos);
            if (!fluid.m_76170_()) {
                return false;
            }
            BlockPos above = pos.m_7494_();
            BlockState stateAbove = level.m_8055_(above);
            if (stateAbove.m_60713_(this.water_pink_petals)) {
                state = stateAbove;
                pos = above;
            } else if (stateAbove.m_60795_()) {
                level.m_7731_(above, this.water_pink_petals.m_5573_(ctx), 3);
                return true;
            }
        }
        if (state.m_60713_(this.water_pink_petals) && (amt = ((Integer)state.m_61143_((Property)PinkPetalsBlock.f_271373_)).intValue()) < 4) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)PinkPetalsBlock.f_271373_, (Comparable)Integer.valueOf(amt + 1)), 3);
            return true;
        }
        return false;
    }
}

