/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.particle;

import com.github.L_Ender.cataclysm.client.render.etc.LightningBoltData;
import com.github.L_Ender.cataclysm.client.render.etc.LightningRender;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector4f;

public class CircleLightningParticle
extends Particle {
    private LightningRender lightningRender = new LightningRender();

    public CircleLightningParticle(ClientLevel world, double x, double y, double z, double xd, double yd, double zd, int r, int g, int b) {
        super(world, x, y, z);
        this.m_107250_(6.0f, 6.0f);
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.f_107227_ = r;
        this.f_107228_ = g;
        this.f_107229_ = b;
        Vec3 lightningTo = new Vec3(xd - x, yd - y, zd - z);
        this.f_107225_ = 10;
        LightningBoltData.BoltRenderInfo boltData = new LightningBoltData.BoltRenderInfo(0.5f, 0.1f, 0.5f, 0.85f, new Vector4f(this.f_107227_ / 255.0f, this.f_107228_ / 255.0f, this.f_107229_ / 255.0f, 0.8f), 0.1f);
        LightningBoltData bolt = new LightningBoltData(boltData, Vec3.f_82478_, lightningTo, 5).size(0.1f).lifespan(this.f_107225_).spawn(LightningBoltData.SpawnFunction.CONSECUTIVE);
        this.lightningRender.update((Object)this, bolt, 1.0f);
    }

    public AABB getRenderBoundingBox(float partialTicks) {
        return this.m_107277_().m_82400_(0.0);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107216_ -= (double)this.f_107226_;
        }
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTick) {
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 cameraPos = camera.m_90583_();
        float x = (float)Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_);
        float y = (float)Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_);
        float z = (float)Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_);
        PoseStack posestack = new PoseStack();
        posestack.m_85836_();
        posestack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        posestack.m_252880_(x, y, z);
        this.lightningRender.render(partialTick, posestack, (MultiBufferSource)multibuffersource$buffersource);
        multibuffersource$buffersource.m_109911_();
        posestack.m_85849_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public static class CircleData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<CircleData> DESERIALIZER = new ParticleOptions.Deserializer<CircleData>(){

            public CircleData fromCommand(ParticleType<CircleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int r = reader.readInt();
                reader.expect(' ');
                int g = reader.readInt();
                reader.expect(' ');
                int b = reader.readInt();
                return new CircleData(r, g, b);
            }

            public CircleData fromNetwork(ParticleType<CircleData> particleTypeIn, FriendlyByteBuf buffer) {
                return new CircleData(buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        };
        private final int r;
        private final int g;
        private final int b;

        public CircleData(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.r);
            buffer.writeInt(this.g);
            buffer.writeInt(this.b);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d %d %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.r, this.g, this.b);
        }

        public ParticleType<CircleData> m_6012_() {
            return (ParticleType)ModParticle.CIRCLE_LIGHTNING.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getB() {
            return this.b;
        }

        public static Codec<CircleData> CODEC(ParticleType<CircleData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.INT.fieldOf("r").forGetter(CircleData::getR), (App)Codec.INT.fieldOf("g").forGetter(CircleData::getG), (App)Codec.INT.fieldOf("b").forGetter(CircleData::getB)).apply((Applicative)codecBuilder, CircleData::new));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<CircleData> {
        public Particle createParticle(CircleData data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CircleLightningParticle particle = new CircleLightningParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, data.getR(), data.getG(), data.getB());
            return particle;
        }
    }
}

