/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.config;

import gisellevonbingen.mmp.common.material.MaterialType;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    public static final int RADIX = 16;
    public final Map<MaterialType, ForgeConfigSpec.ConfigValue<String>> colors;
    public final Map<MaterialType, Integer> parsedColors;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("color : ores rgb color");
        builder.push("ores");
        this.colors = new HashMap<MaterialType, ForgeConfigSpec.ConfigValue<String>>();
        this.parsedColors = new HashMap<MaterialType, Integer>();
        for (MaterialType materialType : MaterialType.values()) {
            builder.push(materialType.getBaseName());
            builder.comment(new String[]{"if empty, use default", "default : " + Integer.toString(materialType.getDefaultColor() & 0xFFFFFF, 16)});
            this.colors.put(materialType, (ForgeConfigSpec.ConfigValue<String>)builder.define("color", (Object)""));
            builder.pop();
        }
        builder.pop();
    }

    public void parseConfig() {
        this.parsedColors.clear();
        for (MaterialType materialType : MaterialType.values()) {
            ForgeConfigSpec.ConfigValue<String> value = this.colors.get((Object)materialType);
            int color = this.parseColor(value, materialType.getColor());
            this.parsedColors.put(materialType, color);
        }
    }

    public int parseColor(ForgeConfigSpec.ConfigValue<String> configValue, int fallback) {
        try {
            if (configValue != null) {
                return Integer.parseInt((String)configValue.get(), 16);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallback;
    }
}

