/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.config;

import gisellevonbingen.mmp.common.config.ClientConfig;
import gisellevonbingen.mmp.common.config.CommonConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class MMPConfigs {
    public static final Map<ModConfig.Type, ForgeConfigSpec> SPECS = new HashMap<ModConfig.Type, ForgeConfigSpec>();
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    public static void register(ModLoadingContext modLoadingContext) {
        MMPConfigs.register(modLoadingContext, ModConfig.Type.COMMON);
        Dist dist = FMLEnvironment.dist;
        if (dist.isClient()) {
            MMPConfigs.register(modLoadingContext, ModConfig.Type.CLIENT);
        }
        if (dist.isDedicatedServer()) {
            MMPConfigs.register(modLoadingContext, ModConfig.Type.SERVER);
        }
    }

    public static void register(ModLoadingContext modLoadingContext, ModConfig.Type type) {
        ForgeConfigSpec spec = SPECS.get(type);
        if (spec != null) {
            modLoadingContext.registerConfig(type, (IConfigSpec)spec);
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        MMPConfigs.parseConfig((ModConfigEvent)event);
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        MMPConfigs.parseConfig((ModConfigEvent)event);
    }

    public static void parseConfig(ModConfigEvent event) {
        if (event.getConfig().getSpec() == CLIENT_SPEC) {
            CLIENT.parseConfig();
        }
    }

    static {
        Pair common = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)common.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        SPECS.put(ModConfig.Type.COMMON, COMMON_SPEC);
        Pair client = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)client.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        SPECS.put(ModConfig.Type.CLIENT, CLIENT_SPEC);
    }
}

