/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gisellevonbingen.mmp.common.crafting.SingleOutputRecipeBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class ShapelessRecipeBuilder
extends SingleOutputRecipeBuilder {
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

    public ShapelessRecipeBuilder(ResourceLocation id) {
        super(id);
    }

    public Result getResult() {
        return new Result(this);
    }

    public void add(Ingredient ingredient) {
        this.ingredients.add(ingredient);
    }

    public void add(Ingredient ingredient, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add(ingredient);
        }
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public RecipeSerializer<?> getType() {
        return RecipeSerializer.f_44077_;
    }

    public static class Result
    extends SingleOutputRecipeBuilder.SingleOutputRecipeResult {
        private final ArrayList<Ingredient> ingredients;

        public Result(ShapelessRecipeBuilder builder) {
            super(builder);
            this.ingredients = new ArrayList<Ingredient>(builder.ingredients);
        }

        @Override
        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            JsonArray ingredientsJson = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                ingredientsJson.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredientsJson);
        }

        public ArrayList<Ingredient> getIngredients() {
            return Lists.newArrayList(this.ingredients);
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44077_;
        }
    }
}

