/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.tntsweeper.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.tntsweeper.TntsweeperMod;
import net.mcreator.tntsweeper.procedures.HardGameCreatorProcedure;
import net.mcreator.tntsweeper.procedures.MediumGameCreatorProcedure;
import net.mcreator.tntsweeper.procedures.SmallGameCreatorProcedure;
import net.mcreator.tntsweeper.procedures.TNTSweeperRemoveGameButtonProcedure;
import net.mcreator.tntsweeper.world.inventory.GameCreatorGuiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GameCreatorGuiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GameCreatorGuiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GameCreatorGuiButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GameCreatorGuiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GameCreatorGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GameCreatorGuiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GameCreatorGuiMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SmallGameCreatorProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            MediumGameCreatorProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            HardGameCreatorProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            TNTSweeperRemoveGameButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TntsweeperMod.addNetworkMessage(GameCreatorGuiButtonMessage.class, GameCreatorGuiButtonMessage::buffer, GameCreatorGuiButtonMessage::new, GameCreatorGuiButtonMessage::handler);
    }
}

