/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.FreezerBlock;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWithEntity;
import com.unlikepaladin.pfm.blocks.IronFridgeBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.blockentities.FridgeBlockEntity;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FridgeBlock
extends HorizontalFacingBlockWithEntity {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    private final Block baseBlock;
    private final BlockState baseBlockState;
    private static final List<FurnitureBlock> FRIDGES = new ArrayList<FurnitureBlock>();
    private final Supplier<FreezerBlock> freezer;
    protected static final Map<Direction, VoxelShape> FRIDGE_SINGLE = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)12.0, (double)3.0, (double)-0.5, (double)13.0, (double)14.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)2.0), Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_TOP = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83110_((VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)-0.5, (double)13.0, (double)15.0, (double)1.0), (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0)));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_MIDDLE = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83110_((VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)-0.5, (double)13.0, (double)16.0, (double)1.0), (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0)));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_BOTTOM = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)-0.5, (double)13.0, (double)16.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)2.0), Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)-0.5, (double)13.0, (double)20.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)21.0, (double)2.0), Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)32.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_MIDDLE_FREEZER = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)-0.5, (double)13.0, (double)20.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)21.0, (double)16.0), Block.m_49796_((double)1.0, (double)21.0, (double)2.0, (double)15.0, (double)32.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_SINGLE_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-0.5, (double)3.0, (double)-10.0, (double)1.0, (double)14.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)1.0, (double)-12.0, (double)3.0, (double)16.0, (double)2.0), Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_TOP_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-0.5, (double)0.0, (double)-10.0, (double)1.0, (double)15.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)-12.0, (double)3.0, (double)16.0, (double)2.0), Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_MIDDLE_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-0.5, (double)0.0, (double)-10.0, (double)1.0, (double)16.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)-12.0, (double)3.0, (double)16.0, (double)2.0), Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_BOTTOM_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-0.5, (double)4.0, (double)-10.0, (double)1.0, (double)16.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)1.0, (double)-12.0, (double)3.0, (double)16.0, (double)2.0), Block.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)16.0, (double)3.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-0.5, (double)4.0, (double)-10.0, (double)1.0, (double)20.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)1.0, (double)-12.0, (double)3.0, (double)20.0, (double)2.0), Block.m_49796_((double)1.0, (double)20.0, (double)1.0, (double)15.0, (double)21.0, (double)2.0), Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)32.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_MIDDLE_FREEZER_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-0.5, (double)0.0, (double)-10.0, (double)1.0, (double)20.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)-12.0, (double)3.0, (double)20.0, (double)2.0), Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)32.0, (double)16.0), Block.m_49796_((double)1.0, (double)20.0, (double)1.0, (double)15.0, (double)21.0, (double)2.0)}));
        }
    };

    public FridgeBlock(BlockBehaviour.Properties settings, Supplier<FreezerBlock> freezer) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        FRIDGES.add(new FurnitureBlock((Block)this, "fridge"));
        this.freezer = freezer;
    }

    public static Stream<FurnitureBlock> streamFridges() {
        return FRIDGES.stream();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        stateManager.m_61104_(new Property[]{OPEN});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return super.m_7898_(state, world, pos);
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = world.m_7702_(pos)) instanceof FridgeBlockEntity) {
            ((FridgeBlockEntity)blockEntity).m_58638_(itemStack.m_41786_());
        }
        super.m_6402_(world, pos, state, placer, itemStack);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
            world.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction.m_122434_().m_122478_() && neighborState.m_60734_() == this ? (neighborState.m_61143_((Property)FACING) == state.m_61143_((Property)FACING) ? (BlockState)state.m_61124_((Property)OPEN, (Comparable)((Boolean)neighborState.m_61143_((Property)OPEN))) : state) : state;
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FridgeBlockEntity) {
            player.m_5893_((MenuProvider)((FridgeBlockEntity)blockEntity));
            player.m_36220_(Statistics.FRIDGE_OPENED);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void onBreakInCreative(Level world, BlockPos pos, BlockState state, Player player) {
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_ && player.m_7500_()) {
            this.onBreakInCreative(world, pos, state, player);
        }
        super.m_5707_(world, pos, state, player);
    }

    public boolean m_6104_(BlockState state, BlockState stateFrom, Direction direction) {
        if (stateFrom.m_60713_((Block)this)) {
            return true;
        }
        return super.m_6104_(state, stateFrom, direction);
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean hasFreezer;
        Direction dir = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        boolean open = (Boolean)state.m_61143_((Property)OPEN);
        boolean bottom = state.m_60713_(world.m_8055_(pos.m_7494_()).m_60734_());
        boolean top = state.m_60713_(world.m_8055_(pos.m_7495_()).m_60734_());
        boolean bl = hasFreezer = world.m_8055_(pos.m_7494_()).m_60734_() instanceof FreezerBlock && !(world.m_8055_(pos.m_7494_()).m_60734_() instanceof IronFridgeBlock);
        if (top && hasFreezer) {
            if (open) {
                if (!FRIDGE_MIDDLE_FREEZER_OPEN.containsKey(dir)) {
                    FRIDGE_MIDDLE_FREEZER_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_MIDDLE_FREEZER_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_MIDDLE_FREEZER_OPEN.get(dir);
            }
            if (!FRIDGE_MIDDLE_FREEZER.containsKey(dir)) {
                FRIDGE_MIDDLE_FREEZER.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_MIDDLE_FREEZER.get(Direction.NORTH)));
            }
            return FRIDGE_MIDDLE_FREEZER.get(dir);
        }
        if (top && bottom) {
            if (open) {
                if (!FRIDGE_MIDDLE_OPEN.containsKey(dir)) {
                    FRIDGE_MIDDLE_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_MIDDLE_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_MIDDLE_OPEN.get(dir);
            }
            if (!FRIDGE_MIDDLE.containsKey(dir)) {
                FRIDGE_MIDDLE.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_MIDDLE.get(Direction.NORTH)));
            }
            return FRIDGE_MIDDLE.get(dir);
        }
        if (bottom) {
            if (open) {
                if (!FRIDGE_BOTTOM_OPEN.containsKey(dir)) {
                    FRIDGE_BOTTOM_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_BOTTOM_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_BOTTOM_OPEN.get(dir);
            }
            if (!FRIDGE_BOTTOM.containsKey(dir)) {
                FRIDGE_BOTTOM.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_BOTTOM.get(Direction.NORTH)));
            }
            return FRIDGE_BOTTOM.get(dir);
        }
        if (top) {
            if (open) {
                if (!FRIDGE_TOP_OPEN.containsKey(dir)) {
                    FRIDGE_TOP_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_TOP_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_TOP_OPEN.get(dir);
            }
            if (!FRIDGE_TOP.containsKey(dir)) {
                FRIDGE_TOP.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_TOP.get(Direction.NORTH)));
            }
            return FRIDGE_TOP.get(dir);
        }
        if (hasFreezer) {
            if (open) {
                if (!FRIDGE_OPEN.containsKey(dir)) {
                    FRIDGE_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_OPEN.get(dir);
            }
            if (!FRIDGE.containsKey(dir)) {
                FRIDGE.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE.get(Direction.NORTH)));
            }
            return FRIDGE.get(dir);
        }
        if (open) {
            if (!FRIDGE_SINGLE_OPEN.containsKey(dir)) {
                FRIDGE_SINGLE_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_SINGLE_OPEN.get(Direction.NORTH)));
            }
            return FRIDGE_SINGLE_OPEN.get(dir);
        }
        if (!FRIDGE_SINGLE.containsKey(dir)) {
            FRIDGE_SINGLE.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_SINGLE.get(Direction.NORTH)));
        }
        return FRIDGE_SINGLE.get(dir);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return FridgeBlockEntity.getFactory().m_155267_(pos, state);
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

