/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.blocks.blockentities.GenericStorageBlockEntity9x3;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KitchenCabinetBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private final BlockState baseBlockState;
    private final Block baseBlock;
    private static final List<FurnitureBlock> WOOD_CABINETS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_CABINETS = new ArrayList<FurnitureBlock>();
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    protected static final VoxelShape STRAIGHT = Shapes.m_83124_((VoxelShape)KitchenCabinetBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{KitchenCabinetBlock.m_49796_((double)0.0, (double)1.0, (double)8.0, (double)16.0, (double)16.0, (double)9.0), KitchenCabinetBlock.m_49796_((double)6.0, (double)3.0, (double)9.0, (double)7.0, (double)7.0, (double)10.0), KitchenCabinetBlock.m_49796_((double)9.0, (double)3.0, (double)9.0, (double)10.0, (double)7.0, (double)10.0)});
    protected static final VoxelShape INNER_CORNER = Shapes.m_83124_((VoxelShape)KitchenCabinetBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{KitchenCabinetBlock.m_49796_((double)1.0, (double)3.0, (double)9.0, (double)2.0, (double)7.0, (double)10.0), KitchenCabinetBlock.m_49796_((double)0.0, (double)1.0, (double)8.0, (double)8.0, (double)16.0, (double)9.0), KitchenCabinetBlock.m_49796_((double)7.0, (double)1.0, (double)9.0, (double)8.0, (double)16.0, (double)16.0), KitchenCabinetBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), KitchenCabinetBlock.m_49796_((double)6.0, (double)3.0, (double)13.0, (double)7.0, (double)7.0, (double)14.0)});
    protected static final VoxelShape OUTER_CORNER = Shapes.m_83124_((VoxelShape)KitchenCabinetBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{KitchenCabinetBlock.m_49796_((double)6.0, (double)3.0, (double)9.0, (double)7.0, (double)7.0, (double)10.0), KitchenCabinetBlock.m_49796_((double)0.0, (double)1.0, (double)8.0, (double)8.0, (double)16.0, (double)9.0), KitchenCabinetBlock.m_49796_((double)8.0, (double)1.0, (double)0.0, (double)9.0, (double)16.0, (double)8.0), KitchenCabinetBlock.m_49796_((double)9.0, (double)3.0, (double)6.0, (double)10.0, (double)7.0, (double)7.0)});
    protected static final VoxelShape STRAIGHT_OPEN = Shapes.m_83124_((VoxelShape)KitchenCabinetBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{KitchenCabinetBlock.m_49796_((double)16.0, (double)3.0, (double)14.0, (double)17.0, (double)7.0, (double)15.0), KitchenCabinetBlock.m_49796_((double)15.0, (double)1.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), KitchenCabinetBlock.m_49796_((double)-1.0, (double)3.0, (double)14.0, (double)0.0, (double)7.0, (double)15.0), KitchenCabinetBlock.m_49796_((double)0.0, (double)1.0, (double)8.0, (double)1.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape INNER_CORNER_OPEN = Shapes.m_83124_((VoxelShape)KitchenCabinetBlock.m_49796_((double)7.0, (double)1.0, (double)9.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{KitchenCabinetBlock.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), KitchenCabinetBlock.m_49796_((double)6.0, (double)3.0, (double)13.0, (double)7.0, (double)7.0, (double)14.0), KitchenCabinetBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)});
    protected static final VoxelShape OUTER_CORNER_OPEN = Shapes.m_83124_((VoxelShape)KitchenCabinetBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{KitchenCabinetBlock.m_49796_((double)0.0, (double)1.0, (double)8.0, (double)1.0, (double)16.0, (double)16.0), KitchenCabinetBlock.m_49796_((double)-1.0, (double)3.0, (double)14.0, (double)0.0, (double)7.0, (double)15.0), KitchenCabinetBlock.m_49796_((double)8.0, (double)1.0, (double)0.0, (double)9.0, (double)16.0, (double)8.0), KitchenCabinetBlock.m_49796_((double)9.0, (double)3.0, (double)6.0, (double)10.0, (double)7.0, (double)7.0)});
    protected static final VoxelShape STRAIGHT_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, STRAIGHT);
    protected static final VoxelShape STRAIGHT_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, STRAIGHT);
    protected static final VoxelShape STRAIGHT_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, STRAIGHT);
    protected static final VoxelShape STRAIGHT_OPEN_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, STRAIGHT_OPEN);
    protected static final VoxelShape STRAIGHT_OPEN_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, STRAIGHT_OPEN);
    protected static final VoxelShape STRAIGHT_OPEN_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, STRAIGHT_OPEN);
    protected static final VoxelShape INNER_CORNER_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, INNER_CORNER);
    protected static final VoxelShape INNER_CORNER_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, INNER_CORNER);
    protected static final VoxelShape INNER_CORNER_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, INNER_CORNER);
    protected static final VoxelShape INNER_CORNER_OPEN_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, INNER_CORNER_OPEN);
    protected static final VoxelShape INNER_CORNER_OPEN_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, INNER_CORNER_OPEN);
    protected static final VoxelShape INNER_CORNER_OPEN_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, INNER_CORNER_OPEN);
    protected static final VoxelShape OUTER_CORNER_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, OUTER_CORNER);
    protected static final VoxelShape OUTER_CORNER_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, OUTER_CORNER);
    protected static final VoxelShape OUTER_CORNER_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, OUTER_CORNER);
    protected static final VoxelShape OUTER_CORNER_OPEN_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, OUTER_CORNER_OPEN);
    protected static final VoxelShape OUTER_CORNER_OPEN_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, OUTER_CORNER_OPEN);
    protected static final VoxelShape OUTER_CORNER_OPEN_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, OUTER_CORNER_OPEN);

    public KitchenCabinetBlock(BlockBehaviour.Properties settings) {
        super(settings.m_60953_(state -> 0).m_60991_((blockstate, b, c) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        if (AbstractSittableBlock.isWoodBased(this.m_49966_()) && ((Object)((Object)this)).getClass().isAssignableFrom(KitchenCabinetBlock.class)) {
            WOOD_CABINETS.add(new FurnitureBlock((Block)this, "kitchen_cabinet"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(KitchenCabinetBlock.class)) {
            STONE_CABINETS.add(new FurnitureBlock((Block)this, "kitchen_cabinet"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodCabinets() {
        return WOOD_CABINETS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneCabinets() {
        return STONE_CABINETS.stream();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        stateManager.m_61104_(new Property[]{OPEN});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)KitchenCounterBlock.f_54117_);
        BlockState neighborStateFacing = view.m_8055_(pos.m_121945_(direction));
        BlockState neighborStateOpposite = view.m_8055_(pos.m_121945_(direction.m_122424_()));
        boolean open = (Boolean)state.m_61143_((Property)OPEN);
        if (this.isCabinet(neighborStateFacing) && neighborStateFacing.m_61147_().contains(BlockStateProperties.f_61374_)) {
            Direction direction2 = (Direction)neighborStateFacing.m_61143_((Property)BlockStateProperties.f_61374_);
            if (direction2.m_122434_() != ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() && this.isDifferentOrientation(state, view, pos, direction2.m_122424_())) {
                if (direction2 == direction.m_122428_()) {
                    switch (direction) {
                        case NORTH: {
                            if (open) {
                                return OUTER_CORNER_OPEN;
                            }
                            return OUTER_CORNER;
                        }
                        case SOUTH: {
                            if (open) {
                                return OUTER_CORNER_OPEN_SOUTH;
                            }
                            return OUTER_CORNER_SOUTH;
                        }
                        case EAST: {
                            if (open) {
                                return OUTER_CORNER_OPEN_EAST;
                            }
                            return OUTER_CORNER_EAST;
                        }
                    }
                    if (open) {
                        return OUTER_CORNER_OPEN_WEST;
                    }
                    return OUTER_CORNER_WEST;
                }
                switch (direction) {
                    case NORTH: {
                        if (open) {
                            return OUTER_CORNER_OPEN_EAST;
                        }
                        return OUTER_CORNER_EAST;
                    }
                    case SOUTH: {
                        if (open) {
                            return OUTER_CORNER_OPEN_WEST;
                        }
                        return OUTER_CORNER_WEST;
                    }
                    case EAST: {
                        if (open) {
                            return OUTER_CORNER_OPEN_SOUTH;
                        }
                        return OUTER_CORNER_SOUTH;
                    }
                }
                if (open) {
                    return OUTER_CORNER_OPEN;
                }
                return OUTER_CORNER;
            }
            switch (direction) {
                case NORTH: {
                    if (open) {
                        return STRAIGHT_OPEN;
                    }
                    return STRAIGHT;
                }
                case SOUTH: {
                    if (open) {
                        return STRAIGHT_OPEN_SOUTH;
                    }
                    return STRAIGHT_SOUTH;
                }
                case EAST: {
                    if (open) {
                        return STRAIGHT_OPEN_EAST;
                    }
                    return STRAIGHT_EAST;
                }
            }
            if (open) {
                return STRAIGHT_OPEN_WEST;
            }
            return STRAIGHT_WEST;
        }
        if (this.isCabinet(neighborStateOpposite) && neighborStateOpposite.m_61147_().contains(BlockStateProperties.f_61374_)) {
            Direction direction3 = neighborStateOpposite.m_60734_() instanceof AbstractFurnaceBlock ? ((Direction)neighborStateOpposite.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_() : (Direction)neighborStateOpposite.m_61143_((Property)BlockStateProperties.f_61374_);
            if (direction3.m_122434_() != ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() && this.isDifferentOrientation(state, view, pos, direction3)) {
                if (direction3 == direction.m_122428_()) {
                    switch (direction) {
                        case NORTH: {
                            return INNER_CORNER_WEST;
                        }
                        case SOUTH: {
                            return INNER_CORNER_EAST;
                        }
                        case EAST: {
                            return INNER_CORNER;
                        }
                    }
                    return INNER_CORNER_SOUTH;
                }
                switch (direction) {
                    case NORTH: {
                        return INNER_CORNER;
                    }
                    case SOUTH: {
                        return INNER_CORNER_SOUTH;
                    }
                    case EAST: {
                        return INNER_CORNER_EAST;
                    }
                }
                return INNER_CORNER_WEST;
            }
            switch (direction) {
                case NORTH: {
                    if (open) {
                        return STRAIGHT_OPEN;
                    }
                    return STRAIGHT;
                }
                case SOUTH: {
                    if (open) {
                        return STRAIGHT_OPEN_SOUTH;
                    }
                    return STRAIGHT_SOUTH;
                }
                case EAST: {
                    if (open) {
                        return STRAIGHT_OPEN_EAST;
                    }
                    return STRAIGHT_EAST;
                }
            }
            if (open) {
                return STRAIGHT_OPEN_WEST;
            }
            return STRAIGHT_WEST;
        }
        switch (direction) {
            case NORTH: {
                if (open) {
                    return STRAIGHT_OPEN;
                }
                return STRAIGHT;
            }
            case SOUTH: {
                if (open) {
                    return STRAIGHT_OPEN_SOUTH;
                }
                return STRAIGHT_SOUTH;
            }
            case EAST: {
                if (open) {
                    return STRAIGHT_OPEN_EAST;
                }
                return STRAIGHT_EAST;
            }
        }
        if (open) {
            return STRAIGHT_OPEN_WEST;
        }
        return STRAIGHT_WEST;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
            world.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    public boolean isCabinet(BlockState state) {
        return state.m_60734_() instanceof KitchenCabinetBlock;
    }

    public boolean isDifferentOrientation(BlockState state, BlockGetter world, BlockPos pos, Direction dir) {
        BlockState blockState = world.m_8055_(pos.m_121945_(dir));
        return !this.isCabinet(blockState);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.m_60713_(state.m_60734_())) {
            this.baseBlockState.m_60690_(world, pos, Blocks.f_50016_, pos, false);
            this.baseBlock.m_6807_(this.baseBlockState, world, pos, oldState, false);
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof GenericStorageBlockEntity9x3) {
            player.m_5893_((MenuProvider)((GenericStorageBlockEntity9x3)blockEntity));
            player.m_36220_(Statistics.CABINET_SEARCHED);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = world.m_7702_(pos)) instanceof GenericStorageBlockEntity9x3) {
            ((GenericStorageBlockEntity9x3)blockEntity).m_58638_(itemStack.m_41786_());
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return GenericStorageBlockEntity9x3.getFactory().m_155267_(pos, state);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

