/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.patchouli;

import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class FreezingRecipeProcessor
implements IComponentProcessor {
    private Recipe<?> recipe;

    public void setup(Level level, IVariableProvider variables) {
        String recipeId = variables.get("recipe").asString();
        RecipeManager manager = level.m_7465_();
        this.recipe = manager.m_44043_(new ResourceLocation(recipeId)).orElse(null);
    }

    @NotNull
    public IVariable process(Level level, String key) {
        if (this.recipe != null) {
            switch (key) {
                case "ingredient": {
                    Ingredient ingredient = (Ingredient)this.recipe.m_7527_().get(0);
                    ItemStack[] stacks = ingredient.m_43908_();
                    ItemStack stack = stacks.length == 0 ? ItemStack.f_41583_ : stacks[0];
                    return IVariable.from((Object)stack);
                }
                case "output": {
                    ItemStack result = this.recipe.m_8043_(level.m_9598_());
                    return IVariable.from((Object)result);
                }
                case "icon": {
                    ItemStack icon = this.recipe.m_8042_();
                    return IVariable.from((Object)icon);
                }
                case "text": {
                    ItemStack out = this.recipe.m_8043_(level.m_9598_());
                    return IVariable.wrap((String)(out.m_41613_() + "x$(br)" + String.valueOf(out.m_41786_())));
                }
                case "icount": {
                    return IVariable.wrap((Number)this.recipe.m_8043_(level.m_9598_()).m_41613_());
                }
                case "iname": {
                    return IVariable.wrap((String)this.recipe.m_8043_(level.m_9598_()).m_41786_().getString());
                }
            }
        }
        return IVariable.empty();
    }

    public void refresh(Screen parent, int left, int top) {
        super.refresh(parent, left, top);
    }

    public boolean allowRender(String group) {
        return this.recipe != null;
    }
}

