/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.rei;

import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FurnitureDisplay
implements Display {
    protected FurnitureRecipe recipe;
    public static final CategoryIdentifier<FurnitureDisplay> IDENTIFIER = CategoryIdentifier.of((ResourceLocation)new ResourceLocation("pfm", "furniture"));
    private int itemsPerInnerRecipe;
    private final List<EntryIngredient> inputs = new ArrayList<EntryIngredient>();
    private final List<EntryIngredient> outputs = new ArrayList<EntryIngredient>();

    public FurnitureDisplay(FurnitureRecipe recipe) {
        this.recipe = recipe;
        this.itemsPerInnerRecipe = recipe.m_7527_().size();
    }

    public List<EntryIngredient> getInputEntries() {
        if (!this.inputs.isEmpty()) {
            return this.inputs;
        }
        ArrayList inputEntries = new ArrayList();
        this.itemsPerInnerRecipe = this.recipe.getMaxInnerRecipeSize();
        for (FurnitureRecipe.CraftableFurnitureRecipe innerRecipe : this.recipe.getInnerRecipes()) {
            List<Ingredient> ingredients = innerRecipe.getIngredients();
            HashMap<Item, Integer> containedItems = new HashMap<Item, Integer>();
            for (Ingredient ingredient : ingredients) {
                for (ItemStack stack : ingredient.m_43908_()) {
                    if (!containedItems.containsKey(stack.m_41720_())) {
                        containedItems.put(stack.m_41720_(), stack.m_41613_());
                        continue;
                    }
                    containedItems.put(stack.m_41720_(), (Integer)containedItems.get(stack.m_41720_()) + stack.m_41613_());
                }
            }
            ArrayList<Ingredient> finalList = new ArrayList<Ingredient>();
            for (Map.Entry entry : containedItems.entrySet()) {
                finalList.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue())}));
            }
            finalList.sort(Comparator.comparing(o -> o.m_43908_()[0].m_41720_().toString()));
            if (finalList.size() != this.itemsPerInnerRecipe) {
                while (finalList.size() != this.itemsPerInnerRecipe) {
                    finalList.add(Ingredient.f_43901_);
                }
            }
            inputEntries.addAll(finalList);
        }
        for (Ingredient ingredient : inputEntries) {
            if (!ingredient.m_43947_()) {
                this.inputs.add(EntryIngredients.ofIngredient((Ingredient)ingredient));
                continue;
            }
            this.inputs.add(EntryIngredient.empty());
        }
        return this.inputs;
    }

    public int itemsPerInnerRecipe() {
        return this.itemsPerInnerRecipe;
    }

    public List<EntryIngredient> getOutputEntries() {
        if (this.outputs.isEmpty()) {
            this.outputs.addAll(this.recipe.getInnerRecipes().stream().map(FurnitureRecipe.CraftableFurnitureRecipe::getRecipeOuput).map(EntryIngredients::of).toList());
        }
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return IDENTIFIER;
    }

    public Display provideInternalDisplay() {
        return super.provideInternalDisplay();
    }
}

